/*								-*- C++ -*-
 * $Id: WIN_menu.h,v 1.2 1997-01-15 14:58:01+01 mho Exp $
 *
 * Purpose: simple menu class
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifndef Menu_h
#define Menu_h

#ifdef __GNUG__
#pragma interface
#endif

class wxCommandEvent;
class wxColour;
class wxFont;

typedef void (*wxFunction)(wxObject&, wxCommandEvent&);
typedef void wxMenuItem;

class wxMenu : public wxItem {
DECLARE_DYNAMIC_CLASS(wxMenu)
public:
    wxMenu(char *title=NULL, wxFunction func=NULL);
    ~wxMenu(void);

    // popup menu (used by wxWindow);
    Bool  PopupMenu(wxWindow *parent, int root_x, int root_y);

    // add items to menu
    void  Append(int id, char *label, char *help=NULL, Bool checkable=FALSE);
    void  Append(int id, char *label, wxMenu *submenu, char *help=NULL);
    void  AppendSeparator(void);
    void  Delete(int id);
    // modify items
    void  Break(void) {}; // not supported
    void  Check(int id, Bool flag);
    Bool  Checked(int id);
    void  Enable(int id, Bool flag);
    char  *GetHelpString(int id);
    char  *GetLabel(int id);
    char  *GetTitle(void);
    void  SetHelpString(int id, char *help);
    void  SetLabel(int id, char *label);
    void  SetTitle(char *title);
    // set font & colour
    void  SetFont(wxFont *newfont)            { if (newfont) font = newfont; }
    void  SetBackgroundColour(wxColour& col)  { bg = col; }
    void  SetForegroundColour(wxColour& col)  { fg = col; }
    // search for item by label in subtree
    int FindItem(char *label);
    // search only this menu for label
    int FindItem(char *label, wxMenu **submenu);
private:
    // allow callback and menubar access to private data
    friend class wxMenuBar;

    wxMenuItem  *FindItemForId(int id, wxMenu **menu=NULL); // search for internal data
    #ifdef Have_Xt_Types
    static void EventCallback(Widget, XtPointer, XtPointer);
    #endif

    // internal representation
    wxMenuItem*  title;		// title, if specified with constructor
    wxMenuItem*  top;		// first menu item
    wxMenuItem*  last;		// last menu item for wxMenu::Append
    wxMenuItem*  topdummy;
    wxMenuItem** owner;		// Pointer to pointer to top
};

// onother way to popup a menu
extern Bool PopupMenu(wxWindow *parent, wxMenu *menu, int x, int y);

#endif // Menu_h
