/*								-*- C++ -*-
 * $Id: WIN_window.cpp,v 1.1 1997/10/30 20:16:02 wg Exp wg $
 *
 * Purpose: base class for all windows
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifdef __GNUG__
#pragma implementation "WIN_window.h"
#endif

#define  Uses_XtIntrinsicP
#define  Uses_wxGDI
#define  Uses_wxWindow
#define  Uses_wxWindowDC
#include "wx.h"
#define  Uses_ScrollWinWidget
#define  Uses_ShellWidget
#define  Uses_SimpleWidget
#include <widgets.h>

#include <X11/keysym.h> // needed for IsFunctionKey, etc.

// simplify setting of args
#define SET_ARG(n, v) args[i].name = n; args[i].value = v; ++i;

//-----------------------------------------------------------------------------
// Private structure with X and Xt types and access methods
//-----------------------------------------------------------------------------

class wxWindow_Xintern {
public:
    Widget	  frame;			// frame widgets
    Widget	  priv_frame;			// optional widget, e.g. for scrolling
    Widget	  handle;			// X implementation of functionality
    Region	  expose_region;		// exposed region
    XEvent*	  expose_event;			// expose event 
    EventMask	  translations_eventmask;	// events selected by widget-translations
    unsigned long last_clicktime; 		// last time and button to compute
    unsigned int  last_clickbutton;		//   if a double click has arrived
};

Widget& wxWindow::FWidget(void) // widget of frame
{
    return (X->frame);
}

Widget& wxWindow::PWidget(void) // widget of private frame
{
    return (X->priv_frame);
}

Widget& wxWindow::HWidget(void) // widget of handle
{
    return (X->handle);
}

Widget& wxWindow::GetParentWidget(wxWindow *p)
{
    if ( (style & wxPRIVATE_CHILD) && p->PWidget() )
	return p->PWidget();
    return p->HWidget();
}

//-----------------------------------------------------------------------------
// wxWindow constructor
//-----------------------------------------------------------------------------

IMPLEMENT_DYNAMIC_CLASS(wxWindow, wxEvtHandler)

wxWindow::wxWindow(void)
{ 
    __type = wxTYPE_WINDOW;

    // X representation
    X = wxNEW wxWindow_Xintern;
    X->frame = X->handle = X->priv_frame = NULL;
    X->expose_region = NULL;
    X->expose_event = NULL;
    X->translations_eventmask = 0;
    X->last_clicktime = 0;
    X->last_clickbutton = 0;
    // device context
    dc = NULL;
    // child <-> parent relationships
    parent   = NULL;
    // event handler
    event_handler = this;
    // layout information
#if USE_CONSTRAINTS
    InitConstraints();
#endif
    // GDI objects
    fg     = wxBLACK;
    bg     = wxLIGHT_GREY;
    cmap   = *wxAPP_COLOURMAP;
    cursor = wxSTANDARD_CURSOR;
    font   = wxSWISS_FONT;
    // misc info
    allow_dclicks    = FALSE;
    captured         = FALSE;
    drag_accept      = FALSE;
    first_painting   = TRUE;
    painting_enabled = TRUE;
    style            = 0;
    mapped           = FALSE;
    is_shown         = TRUE;
    selected         = FALSE;
    user_edit_mode   = FALSE;

    WXGC_IGNORE(parent);
}

wxWindow::~wxWindow(void)
{
    // just in case this window is deleted directly
    // by a "delete this" , for example .....
//     extern wxList wxPostDeleteList;
//     wxPostDeleteList.DeleteObject(this);

    // destroy children
    DestroyChildren();
    // destroy device context
    if (dc) delete dc; dc = NULL;
    // remove from parents list
    if (parent)	parent->RemoveChild(this); parent = NULL;
    // destroy widgets
    if (X->frame) {
	RemoveEventHandlers();
	XtDestroyWidget(X->frame);
    }
    X->frame = X->handle = X->priv_frame = NULL;
    // delete contraints
#if USE_CONSTRAINTS
    DestroyConstraints();
#endif
    // delete X internal data
    delete X; X = NULL;
}

//-----------------------------------------------------------------------------
// close window
//-----------------------------------------------------------------------------

Bool wxWindow::Close(Bool force)
{
    if (!force && !GetEventHandler()->OnClose())
	return FALSE;
    wxPostDelete(this);
    return TRUE;
}

//-----------------------------------------------------------------------------
// child - parent relationships
//-----------------------------------------------------------------------------

wxWindow *wxWindow::GetGrandParent(void)
{
    return (parent ? parent->parent : (wxWindow*)NULL);
}

void wxWindow::AddChild(wxWindow *child)
{
    children.Append(child);
}

void wxWindow::DestroyChildren(void)
{
    wxNode *node;
    while ( (node=children.First()) != (wxNode*)NULL ) {
	wxWindow *child = (wxWindow*)(node->Data());
	if (child) {
	    delete child;
	}
    }
}

void wxWindow::RemoveChild(wxWindow *child)
{
    children.DeleteObject(child);
}

//-----------------------------------------------------------------------------
// label, name, title of wxWindow
//-----------------------------------------------------------------------------

char *wxWindow::GetLabel(void)
{
    if (!X->frame) return NULL; // forbid, if no widget associated

    char *label;
    XtVaGetValues(X->frame, XtNlabel, &label, NULL);
    return label;
}

char *wxWindow::GetName(void)
{
    if (!X->handle) return NULL; // forbid, if no widget associated

    return XtName(X->handle);
}

char *wxWindow::GetTitle(void)
{
    if (!X->frame) return NULL; // forbid, if no widget associated

    char *title;
    XtVaGetValues(X->frame, XtNtitle, &title, NULL);
    return title;
}

void wxWindow::SetLabel(char *label)
{
    if (!X->frame) return; // forbid, if no widget associated

    XtVaSetValues(X->frame, XtNlabel, label, NULL);
}

void wxWindow::SetName(char *name)
{
    if (!X->handle) return; // forbid, if no widget associated

    // overwrite quark computed on widget creation
    X->handle->core.xrm_name = XrmStringToName((name != NULL) ? name : "");
}

void wxWindow::SetTitle(char *title)
{
    if (!X->frame) return; // forbid, if no widget associated

    XtVaSetValues(X->frame, XtNtitle, title, XtNiconName, title, NULL);
}

//-----------------------------------------------------------------------------
// translate coordinates to/from screen
//-----------------------------------------------------------------------------

void wxWindow::ClientToScreen(int *x, int *y)
{
    if (!X->handle) return; // forbid, if no widget associated

    short int root_x, root_y;
    XtTranslateCoords(X->handle, *x, *y, &root_x, &root_y);
    *x = root_x; *y = root_y;
}

void wxWindow::ScreenToClient(int *x, int *y)
{
    if (!X->handle) return; // forbid, if no widget associated

    Display *dpy  = XtDisplay(X->handle);
    Screen  *scn  = XtScreen(X->handle);
    Window  root  = RootWindowOfScreen(scn);
    Window  win   = XtWindow(X->handle);
    Window  child;
    int xx = *x;
    int yy = *y;
    XTranslateCoordinates(dpy, root, win, xx, yy, x, y, &child);
}

//-----------------------------------------------------------------------------
// set & query size and position of wxWindow
//-----------------------------------------------------------------------------

void wxWindow::Centre(int direction)
{
    int x=-1,       y=-1,       width=0,      height=0,
	parent_x=0, parent_y=0, parent_width, parent_height;

    // get position and width of parent
    if (parent)
	parent->GetClientSize(&parent_width, &parent_height);
    // get position and size of THIS window
    if (direction & wxCENTRE_TOPLEFT) {
	x = parent_x + parent_width / 2;
	y = parent_y + parent_height / 2;
    } else {
	GetPosition(&x, &y); GetSize(&width, &height);
	// compute centered position
	if (direction & wxHORIZONTAL)
	    x = parent_x + (parent_width - width) / 2;
	if (direction & wxVERTICAL)
	    y = parent_y + (parent_height - height) / 2;
    }
    // move window
    Move(x, y);
}

void wxWindow::GetClientPosition(int *x, int *y)
{
    if (!X->handle) { // forbid, if no widget associated
	*x = *y = 0;
	return;
    }
    Position xx, yy;
    XtVaGetValues(X->handle, XtNx, &xx, XtNy, &yy, NULL);
    if (x) *x = xx;
    if (y) *y = yy;
}

void wxWindow::GetClientSize(int *width, int *height)
{
    if (!X->handle) { // forbid, if no widget associated
	*width = *width = 0;
	return;
    }
    Dimension ww, hh;
    XtVaGetValues(X->handle, XtNwidth, &ww, XtNheight, &hh, NULL);
    if (width)  *width = ww;
    if (height) *height = hh;
}

void wxWindow::GetPosition(int *x, int *y)
{
    if (!X->frame) { // forbid, if no widget associated
	*x = *y = 0;
	return;
    }
    Position xx, yy;
    XtVaGetValues(X->frame, XtNx, &xx, XtNy, &yy, NULL);
    if (x) *x = xx;
    if (y) *y = yy;
}

void wxWindow::GetSize(int *width, int *height)
{
    if (!X->frame) { // forbid, if no widget associated
	*width = *height = 0;
	return;
    }
    Dimension ww, hh;
    XtVaGetValues(X->frame, XtNwidth, &ww, XtNheight, &hh, NULL);
    if (width)  *width = ww;
    if (height) *height = hh;
}

void wxWindow::SetClientSize(int x, int y, int width, int height)
{
    if (!X->handle) return; // forbid, if no widget associated

    Arg args[4]; int i = 0;

    if (width==0 || height==0)
	wxError("cannot resize client to ZERO width or height", GetName());

    if (x > -1)      { SET_ARG(XtNx, x);           }
    if (y > -1)      { SET_ARG(XtNy, y);           }
    if (width > 0)   { SET_ARG(XtNwidth, width);   }
    if (height > 0)  { SET_ARG(XtNheight, height); }
    // printf("%s::SetClientSize(%d, %d, %d, %d)\n", GetName(), x, y, width, height);
    if (i) XtSetValues(X->handle, args, i);
}

void wxWindow::SetSize(int x, int y, int width, int height, int flags)
{
    if (!X->frame) return; // forbid, if no widget associated

    Arg args[4]; int i = 0;

    // fit into parent
    if (parent && (flags & wxSIZE_FIT_ONE)) {
	x = y = 0; parent->GetClientSize(&width, &height);
    }
    if (width==0 || height==0)
	wxError("cannot resize frame to ZERO width or height", GetName());

    if ((x > -1) || (flags & wxSIZE_USE_NEGATIVE))
	{ SET_ARG(XtNx, x); }
    if ((y > -1) || (flags & wxSIZE_USE_NEGATIVE))
	{ SET_ARG(XtNy, y); }
    if (width > 0)
	{ SET_ARG(XtNwidth, width); }
    if (height > 0)
	{ SET_ARG(XtNheight, height); }
    // printf("%s::SetSize(%d, %d, %d, %d)\n", GetName(), x, y, width, height);
    if (i) XtSetValues(X->frame, args, i);
    // call event handlers
    PreResize(x, y, width, height);
}

//-----------------------------------------------------------------------------
// GDI objects (colours, colourmap, font, cursor)
//-----------------------------------------------------------------------------

void wxWindow::ChangeColours(void)
{
    if (X->frame)
	XtVaSetValues(X->frame,
		      XtNbackground,  bg.GetPixel(&cmap),
		      XtNforeground,  fg.GetPixel(&cmap),
		      XtNborderColor, bg.GetPixel(&cmap),
		      NULL);
    if (X->handle)
	XtVaSetValues(X->handle,
		      XtNbackground,  bg.GetPixel(&cmap),
		      XtNforeground,  fg.GetPixel(&cmap),
		      XtNborderColor, bg.GetPixel(&cmap),
		      NULL);
}

// merged with DC-method: float wxWindow::GetCharHeight(void)
// merged with DC-method: float wxWindow::GetCharWidth(void)
// merged with DC-method: wxFont *GetFont(void)
// merged with DC-method: void wxWindow::GetTextExtent()

void wxWindow::SetBackgroundColour(wxColour &col)
{
    bg = col; ChangeColours();
}

// merged with DC-method: void wxWindow::SetColourMap(wxColourMap *new_cmap)

void wxWindow::SetBusyCursor(wxCursor *busy_cursor)
{
    // change own cursor
    XtVaSetValues(X->handle,
		  XtNcursor, (busy_cursor ?
			      busy_cursor->GetCursor() :
			      cursor->GetCursor()),
		  NULL);
    // change children's cursors
    wxNode *node;
    for (node=GetChildren()->First(); node; node=node->Next())
	((wxWindow*)(node->Data()))->SetBusyCursor(busy_cursor);
}

wxCursor *wxWindow::SetCursor(wxCursor *new_cursor)
{
    if (!X->handle) return NULL; // forbid, if no widget associated

    wxCursor *previous = cursor;

    if (new_cursor && new_cursor->Ok()) {
	cursor = new_cursor;
	XtVaSetValues(X->handle, XtNcursor, new_cursor->GetCursor(), NULL);
    }
    return previous;
}

// merged with DC-method: void wxWindow::SetFont(wxFont *new_font)

void wxWindow::SetForegroundColour(wxColour &col)
{
    fg = col; ChangeColours();
}

//-----------------------------------------------------------------------------
// Scrolling
//-----------------------------------------------------------------------------

#define SCROLLABLE							\
    (X->priv_frame &&							\
     XtIsSubclass(X->priv_frame, xfwfScrolledWindowWidgetClass))

//--- set scrollbars ---
void wxWindow::SetScrollbars(int h_pixels, int v_pixels, int h_len, int v_len,
			     int h_page, int v_page, int x_pos, int y_pos,
			     Bool setVirtualSize)
{
    if (!SCROLLABLE) return;

    // set new size for window
    if (setVirtualSize)
	SetVirtualSize(h_pixels * h_len, v_pixels * v_len);
    // set scroll steps of scrollbars
    Arg args[6]; int i = 0;
    SET_ARG(XtNhideHScrollbar, h_pixels <= 0);
    SET_ARG(XtNhideVScrollbar, v_pixels <= 0);
    if (h_pixels > 0) {
 	SET_ARG(XtNhIncrement,     h_pixels);
	SET_ARG(XtNhPageIncrement, h_pixels*h_page);
    }
    if (v_pixels > 0) {
 	SET_ARG(XtNvIncrement,     v_pixels);
	SET_ARG(XtNvPageIncrement, v_pixels*v_page);
    }
    XtSetValues(PWidget(), args, i);
    // move window to new position
    Scroll(x_pos, y_pos);
}

//--- set and get virtual window size ---
int wxWindow::GetScrollRange(int orient)
{
    int w, h; GetVirtualSize(&w, &h);
    return orient == (wxHORIZONTAL ? w : h);
}

void wxWindow::GetVirtualSize(int *w, int *h)
{
    Dimension ww, hh;
    XtVaGetValues(X->handle, XtNwidth, &ww, XtNheight, &hh, NULL);
    *w = ww; *h = hh;
}

void wxWindow::SetScrollRange(int orient, int range)
{
    if (orient == wxHORIZONTAL) SetVirtualSize(range, -1);
    else			SetVirtualSize(-1, range);
}

void wxWindow::SetVirtualSize(int hsize, int vsize)
{
    if (!SCROLLABLE || (hsize <=0 && vsize <= 0)) return;

    Dimension wd, ht, vwd, vht; Position x, y;
    // size of viewport
    XfwfCallComputeInside(X->priv_frame, &x, &y, &vwd, &vht);
    // get geometry of scrollable window
    XtVaGetValues(X->handle, XtNx, &x, XtNy, &y, XtNwidth, &wd, XtNheight, &ht, NULL);
    // adjust values
    x = -x; y = -y;
    if (hsize > 0)     { wd = wxMax(hsize, vwd);         }
    if (vsize > 0)     { ht = wxMax(vsize, vht);         }
    if (x + vwd > wd)  { x  = wd - vwd; x = wxMax(0, x); }
    if (y + vht > ht)  { y  = ht - vht; y = wxMax(0, y); }
    // set geometry of scrollable window
    XtVaSetValues(X->handle, XtNx, -x, XtNy, -y, XtNwidth, wd, XtNheight, ht, NULL);
}

//--- set and get virtual window position ---
int wxWindow::GetScrollPos(int orient)
{
    int x, y; ViewStart(&x, &y);
    return ((orient == wxHORIZONTAL) ? x : y);
}

void wxWindow::Scroll(int x_pos, int y_pos)
{
    if (!SCROLLABLE || (x_pos < 0 && y_pos < 0)) return;

    Dimension wd, ht, vwd, vht; Position x, y;
    // size of viewport
    XfwfCallComputeInside(X->priv_frame, &x, &y, &vwd, &vht);
    // get geometry of scrollable window
    XtVaGetValues(X->handle, XtNx, &x, XtNy, &y, XtNwidth, &wd, XtNheight, &ht, NULL);
    // adjust values
    if (x_pos >= 0) { x = wxMin(x_pos, wd - vwd); x = wxMax(0, x); }
    if (y_pos >= 0) { y = wxMin(y_pos, ht - vht); y = wxMax(0, y); }
    // set geometry of scrollable window
    XtVaSetValues(X->handle, XtNx, -x, XtNy, -y, NULL);
}

void wxWindow::SetScrollPos(int orient, int pos)
{
    if (orient == wxHORIZONTAL) Scroll(pos, -1);
    else			Scroll(-1, pos);
}

void wxWindow::ViewStart(int *x, int *y)
{
    Position xx, yy;
    XtVaGetValues(X->handle, XtNx, &xx, XtNy, &yy, NULL);
    *x = -xx; *y = -yy;
}

//--- scroll page size ---

int wxWindow::GetScrollPage(int orient)
{
    int page_amount = 0;

    if (SCROLLABLE)
	XtVaGetValues(X->priv_frame,
		      orient == wxHORIZONTAL ? XtNhPageIncrement : XtNvPageIncrement,
		      &page_amount,
		      NULL);
    return page_amount;
}


void wxWindow::SetScrollPage(int orient, int range)
{
    if (SCROLLABLE)
	XtVaSetValues(X->priv_frame,
		      orient == wxHORIZONTAL ? XtNhPageIncrement : XtNvPageIncrement,
		      range,
		      NULL);
}

#undef SCROLLABLE

//-----------------------------------------------------------------------------
// miscellaneous
//-----------------------------------------------------------------------------

void wxWindow::AllowDoubleClick(Bool allow)
{
    allow_dclicks = allow;
}

void wxWindow::CaptureMouse(void)
{
    if (!X->frame) return; // forbid, if no widget associated

    if (!captured) {
	XtAddGrab(X->frame, TRUE, FALSE);
	captured = TRUE;
    }
}

void wxWindow::DragAcceptFiles(Bool accept)
{
    drag_accept = accept;
}

void wxWindow::Enable(Bool enable)
{
    if (X->frame)
	XtSetSensitive(X->frame, enable);
    if (X->priv_frame)
	XtSetSensitive(X->priv_frame, enable);
    if (X->handle)
	XtSetSensitive(X->handle, enable);
}

Bool wxWindow::Enabled(void)
{
    if (X->handle)
	return XtIsSensitive(X->handle);
    return FALSE;
}

void wxWindow::EnablePainting(Bool enable)
{
    painting_enabled = enable;
}

Bool wxWindow::GetUserEditMode(void)
{
    return user_edit_mode;
}

long wxWindow::GetWindowStyleFlag(void)
{
    return style;
}

void wxWindow::GrabMouse(wxCursor *cursor)
{
    XtGrabPointer(HWidget(), FALSE,
		  (ButtonMotionMask | PointerMotionHintMask |
		   ButtonReleaseMask | ButtonPressMask),
		  GrabModeAsync, GrabModeAsync,
		  XtWindow(HWidget()),
		  (cursor ? cursor->GetCursor() : None),
		  CurrentTime);
}

Bool wxWindow::IsMapped(void)
{
    return mapped;
}

Bool wxWindow::IsSelected(void)
{
    return selected;
}

Bool wxWindow::IsShown(void)
{
    return is_shown;
}

void wxWindow::Paint(void)
{
    OnPaint();
}

Bool wxWindow::PopupMenu(wxMenu *menu, float x, float y)
{
    extern Bool PopupMenu(wxWindow *window, wxMenu *menu, int x, int y);

    int dev_x = LogicalToDeviceX(x);
    int dev_y = LogicalToDeviceY(y);

    ClientToScreen(&dev_x, &dev_y);

    PopupMenu(this, menu, dev_x, dev_y);
    return TRUE;
}

void wxWindow::Refresh(Bool eraseBack, wxRectangle *rect, int count)
{
    // no refresh without widget or window
    if (!X->handle || !XtIsRealized(X->handle))
	return;

    XExposeEvent dummyEvent;

    dummyEvent.type	  = Expose;
    dummyEvent.display	  = XtDisplay(X->handle);
    dummyEvent.send_event = True;
    dummyEvent.window	  = XtWindow(X->handle);
    dummyEvent.count      = count;
    if (rect) {
	// area is the specified rectangle
	dummyEvent.x      = rect->x;
	dummyEvent.y      = rect->y;
	dummyEvent.width  = rect->width;
	dummyEvent.height = rect->height;
    } else {
	// area is complete window
	GetClientSize(&(dummyEvent.width), &(dummyEvent.height));
	dummyEvent.x = dummyEvent.y = 0;
    }
    // What about clearing background?
    if (eraseBack) XClearArea(dummyEvent.display, dummyEvent.window,
			      dummyEvent.x,       dummyEvent.y,
			      dummyEvent.width,   dummyEvent.height,
			      /* generate no exposure */ FALSE);
    XSendEvent(dummyEvent.display, dummyEvent.window,
	       False, ExposureMask, (XEvent*)&dummyEvent);
}

void wxWindow::ReleaseMouse(void)
{
    if (!X->frame) return; // forbid, if no widget associated

    if (captured) {
	XtRemoveGrab(X->frame);
	captured = FALSE;
    }
}

void wxWindow::SelectItem(Bool select)
{
    selected = select;
    GetEventHandler()->OnSelect(selected);
}

void wxWindow::SetFocus(void)
{
    if (!X->frame) return; // forbid, if no widget associated

    /* MATTHEW: Avoids trying to set focus when it's already there: */
    if (XtIsSubclass(X->frame, xfwfCommonWidgetClass)) {
        Time time = CurrentTime;

	XtCallAcceptFocus(X->frame, &time);
	return;
    }
    // search for the frame of this widget
    wxWindow *win = wxFindFrame(this);
    if (win)
        XtSetKeyboardFocus(win->X->frame, X->frame);
}

void wxWindow::SetUserEditMode(Bool edit)
{
    user_edit_mode = edit;
}

void wxWindow::SetWindowStyleFlag(long flag)
{
    style = flag;
}

Bool wxWindow::Show(Bool show)
{
    if (!X->frame) return TRUE; // forbid, if no widget associated

    if ( (is_shown=show) )
	XtManageChild(X->frame);
    else
	XtUnmanageChild(X->frame);
    return TRUE;
}

void wxWindow::UngrabMouse(void)
{
    XtUngrabPointer(HWidget(), CurrentTime);
}

//-----------------------------------------------------------------------------
// debugging info
//-----------------------------------------------------------------------------

#if WXDEBUG

void wxWindow::Dump(ostream& str)
{
    if (GetClassInfo() && GetClassInfo()->GetClassName())
	str << GetClassInfo()->GetClassName();
    else
	str << "<wxWindow unknown>";
    if (GetName()) {
	// if a widget is associated print name and geometry
	int x, y, w, h; GetPosition(&x, &y); GetSize(&w, &h);
	str << ": " << GetName() << "(" << x << ", " << y << ", " << w << ","  << h << ")";
    }
}

#endif // WXDEBUG

//-----------------------------------------------------------------------------
// include device context and event handling methods
//-----------------------------------------------------------------------------

#include "WIN_windowdraw.cpp"
#include "WIN_windowevent.cpp"
#if USE_CONSTRAINTS
#include "WIN_windowlayout.cpp"
#endif
#include "WIN_windowupdate.cpp"
