//	dinocmdw.h:	Header for Dinocmdw class
//=======================================================================

#ifndef DinoCMDW_H
#define DinoCMDW_H

#include <v/vcmdwin.h>	// So we can use vCmdWindow
#include <v/vmenu.h>	// For the menu pane
#include <v/vutil.h>	// For V Utilities
#include <v/vcmdpane.h> // command pane
#include <v/vstatusp.h>	// For the status pane
#include <v/vtimer.h>   // Timer

#ifdef vDEBUG
#include <v/vdebug.h>
#endif

#include "dinocnv.h"	// DinoCanvasPane

    class DinoCmdWindow;

    class DinoTimer : public vTimer
      {
      public:		//---------------------------------------- public
	DinoTimer(DinoCmdWindow* cw) { cmdw = cw; }
	~DinoTimer() {}
	virtual void TimerTick();
      private:		//--------------------------------------- private
	DinoCmdWindow* cmdw;
      };

    class DinoCmdWindow : public vCmdWindow
      {
	friend int AppMain(int, char**);	// allow AppMain access
	friend class DinoTimer;

      public:		//---------------------------------------- public
	DinoCmdWindow(char*, int, int);
	virtual ~DinoCmdWindow();
	virtual void WindowCommand(ItemVal id, ItemVal val, CmdType cType);
	virtual void KeyIn(vKey keysym, unsigned int shift);

      protected:	//--------------------------------------- protected

      private:		//--------------------------------------- private

	int _spinSpeed;		// speed when spinning 0-100

	// Standard elements
	vMenuPane* DinoMenu;		// For the menu bar
	DinoCanvasPane* DinoCanvas;		// For the canvas
	vCommandPane* DinoCmdPane;	// for the command pane
	vStatusPane* DinoStatus;		// For the status bar
	DinoTimer* _timer;    // Timer for spin

      };
#endif
