#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include <Xm/BulletinB.h>
#include <Xm/GrabShell.h>
#include <Xm/PushB.h>
#include <Xm/Label.h>

#include "../combobox/XdbPrintTree.c"

/*
This tests how the grab shell widget determines width and height.
*/
void onActivate(Widget w, XtPointer mydata, XtPointer cbs)
{
  Widget grabshell = (Widget) mydata;

  XtPopupSpringLoaded(grabshell);
}

void GrabShellResources(Widget w)
{
  int grabStyle = -1;
  Boolean ownerEvents, saveUnder, overrideRedirect;
  Dimension shadowThickness;

  XtVaGetValues(w,
                XmNgrabStyle, &grabStyle, 
                XtNoverrideRedirect, &overrideRedirect,
                XmNownerEvents, &ownerEvents,
                XtNsaveUnder, &saveUnder,
                XmNshadowThickness, &shadowThickness,
                NULL);

  fprintf(stderr,"GrabStyle (%d)\n",grabStyle);
  fprintf(stderr,"OverrideRedirect (%d)\n",(int) overrideRedirect);
  fprintf(stderr,"OwnerEvents (%d)\n",(int) ownerEvents);
  fprintf(stderr,"SaveUnder (%d)\n",(int) saveUnder);
  fprintf(stderr,"ShadowThickness (%d)\n",(int) shadowThickness);
}

int
main(int argc, char **argv)
{
  int i;
  Widget toplevel, grabshell, bb, label, pressme, pb;
  XtAppContext app;
  XmString item;
  Arg args[5];

  XtSetLanguageProc(NULL, NULL, NULL);

  toplevel = XtVaAppInitialize(&app, "GrabShell", NULL, 0, &argc, argv, NULL, NULL);

  bb = XmCreateBulletinBoard(toplevel, "bb", NULL, 0);

  
  pressme = XmCreatePushButton(bb,"Press me and let's see what the grab shell does.",NULL,0);
  
  XtManageChild(pressme);

  XtManageChild(bb);

  grabshell = XmCreateGrabShell(bb, "grab", NULL, 0);
  label = XmCreateLabel(grabshell, "Hello World", NULL, 0);

  XtManageChild(label);

  i = 0;
  XtSetArg(args[i], XmNy, 100); i++;
  XtSetArg(args[i], XmNx, 0); i++;
  pb = XmCreatePushButton(grabshell,"hello", args, i);
  XtManageChild(pb);

  /* setup callback for an activate action */
  XtAddCallback(pressme, 
                XmNactivateCallback,
                (XtCallbackProc) onActivate, 
                (XtPointer) grabshell);

  XtRealizeWidget(toplevel);

  #if 1
  XdbPrintCompleteTree(grabshell);
  #endif

  #if 1
  GrabShellResources(grabshell); 
  #endif

  XtAppMainLoop(app);

  exit(0);
}

