
/*
 * bltDebug.c --
 *
 * Copyright 1993-1997 Bell Labs Innovations for Lucent Technologies.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that the
 * copyright notice and warranty disclaimer appear in supporting documentation,
 * and that the names of Lucent Technologies any of their entities not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 *
 * Lucent Technologies disclaims all warranties with regard to this software,
 * including all implied warranties of merchantability and fitness.  In no event
 * shall Lucent Technologies be liable for any special, indirect or
 * consequential damages or any damages whatsoever resulting from loss of use,
 * data or profits, whether in an action of contract, negligence or other
 * tortuous action, arising out of or in connection with the use or performance
 * of this software.
 */

#include "bltInt.h"

#define DEBUG_VERSION "1.0"

static Blt_List watchList;

/*ARGSUSED*/
static void
DebugProc(clientData, interp, level, command, proc, cmdClientData,
    argc, argv)
    ClientData clientData;	/* not used */
    Tcl_Interp *interp;		/* not used */
    int level;			/* Current level */
    char *command;		/* Command before substitution */
    int (*proc) ();		/* not used */
    ClientData cmdClientData;	/* not used */
    int argc;
    char **argv;		/* Command after parsing, but before
				 * evaluation */
{
    static unsigned char traceStack[200];
    register int i;
    char *string;

    /* This is pretty crappy, but there's no way to trigger stack pops */
    for (i = level + 1; i < 200; i++) {
	traceStack[i] = 0;
    }
    if (Blt_ListGetLength(&watchList) > 0) {
	register Blt_ListItem *iPtr;

	for(iPtr = Blt_ListFirstItem(&watchList); iPtr != NULL; 
	    iPtr = Blt_ListNextItem(iPtr)) {
	    if (Tcl_StringMatch(argv[0], Blt_ListGetKey(iPtr))) {
		break;
	    }
	}
	if ((iPtr != NULL) && (level < 200)) {
	    traceStack[level] = 1;
	    traceStack[level + 1] = 1;
	}
	if ((level >= 200) || (!traceStack[level])) {
	    return;
	}
    } 
    fprintf(stderr, "%d>\t%s\n\t", level, command);
    string = Tcl_Merge(argc, argv);
    fputs(string, stderr);
    free(string);
    fputs("\n", stderr);
}

/*ARGSUSED*/
static int
DebugCmd(clientData, interp, argc, argv)
    ClientData clientData;	/* not used */
    Tcl_Interp *interp;
    int argc;
    char **argv;
{
    static Tcl_Trace token;
    static int level;
    int newLevel;
    char c;
    int length;
    Blt_ListItem *iPtr;
    register int i;

    if (argc == 1) {
	sprintf(interp->result, "%d", level);
	return TCL_OK;
    }
    c = argv[1][0];
    length = strlen(argv[1]);
    if ((c == 'w') && (strncmp(argv[1], "watch", length) == 0)) {
	/* Add patterns of command names to watch to the list */
	for (i = 2; i < argc; i++) {
	    iPtr = Blt_ListFind(&watchList, argv[i]);
	    if (iPtr == NULL) {
		Blt_ListAppend(&watchList, argv[i], (ClientData)0);
	    }
	}
    } else if ((c == 'i') && (strncmp(argv[1], "ignore", length) == 0)) {
	for (i = 2; i < argc; i++) {
	    Blt_ListDelete(&watchList, argv[i]);
	}
    } else {
	goto levelTest;
    }
    /* Return the current watch patterns */
    for (iPtr = Blt_ListFirstItem(&watchList); iPtr != NULL; 
	 iPtr = Blt_ListNextItem(iPtr)) {
	Tcl_AppendElement(interp, Blt_ListGetKey(iPtr));
    }
    return TCL_OK;
    
levelTest:
    if (Tcl_GetBoolean(interp, argv[1], &newLevel) == TCL_OK) {
	if (newLevel > 0) {
	    newLevel = 10000;	/* Max out the level */
	}
    } else if (Tcl_GetInt(interp, argv[1], &newLevel) == TCL_OK) {
	if (newLevel < 0) {
	    newLevel = 0;
	}
    } else {
	return TCL_ERROR;
    }
    if (token != 0) {
	Tcl_DeleteTrace(interp, token);
    }
    if (newLevel > 0) {
	token = Tcl_CreateTrace(interp, newLevel, DebugProc, (ClientData)0);
    }
    level = newLevel;
    sprintf(interp->result, "%d", level);
    return TCL_OK;
}

int
Blt_DebugInit(interp)
    Tcl_Interp *interp;
{
    static Blt_CmdSpec cmdSpec = { "bltdebug", DebugCmd, };

    Blt_InitList(&watchList, TCL_STRING_KEYS);
    return (Blt_InitCmd(interp, "blt", &cmdSpec));
}
