/* Simple primitives for manipulating rectangles.

  This code is part of xink, by Raph Levien.

  xink version 0.02

  Copyright 1997 Raph Levien <raph@acm.org>

  This code is free for commercial and non-commercial use or
  redistribution, as long as the source code release, startup screen,
  or product packaging includes this copyright notice.
*/

#include "rect.h"

/* Make a copy of the rectangle. */
void rect_copy (rect *dest, const rect *src) {
  dest->x0 = src->x0;
  dest->y0 = src->y0;
  dest->x1 = src->x1;
  dest->y1 = src->y1;
}

/* These two routines might get moved into a common "util" file. */
static double fmin (double a, double b) {
  return (a > b) ? b : a;
}

static double fmax (double a, double b) {
  return (a > b) ? a : b;
}

/* Find the smallest rectangle that includes both source rectangles. */
void rect_union (rect *dest, const rect *src1, const rect *src2) {
  if (rect_empty (src1)) {
    rect_copy (dest, src2);
  } else if (rect_empty (src2)) {
    rect_copy (dest, src1);
  } else {
    dest->x0 = fmin (src1->x0, src2->x0);
    dest->y0 = fmin (src1->y0, src2->y0);
    dest->x1 = fmax (src1->x1, src2->x1);
    dest->y1 = fmax (src1->y1, src2->y1);
  }
}

/* Return the intersection of the two rectangles */
void rect_intersect (rect *dest, const rect *src1, const rect *src2) {
  dest->x0 = fmax (src1->x0, src2->x0);
  dest->y0 = fmax (src1->y0, src2->y0);
  dest->x1 = fmin (src1->x1, src2->x1);
  dest->y1 = fmin (src1->y1, src2->y1);
}

/* Return true if the rectangle is empty. */
bool rect_empty (const rect *src) {
  return (src->x1 <= src->x0 || src->y1 <= src->y0);
}

bool point_inside (rect *rect, point *point) {
  return (point->x >= rect->x0 && point->y >= rect->y0 &&
	  point->x < rect->x1 && point->y < rect->y1);
}
