
/*
 *   Alphabeta negamax search
 */


#include "phalanx.h"


#define WINDOW 60


#define update_PV( move, ply ) \
{ register short j; \
  PV[ply][ply] = move; \
  for(j=ply+1;PV[ply+1][j].from;j++) PV[ply][j] = PV[ply+1][j]; \
  PV[ply][j].from = 0; /* end of copied line */ \
}



/* enemy attacks given square */
short attacktest( short square, short ocolor )
{

/* pawn */
if(ocolor!=1)
{ if( B[square+11]==BP || B[square+9]==BP ) return 2; }
else
{ if( B[square-11]==WP || B[square-9]==WP ) return 2; }

/* knight */
{	int i, enemy = KNIGHT+ocolor;
	for( i=0; i!=8; i++ )
	if( B[square+N_moves[i]] == enemy ) return 2;
}

/* rook or queen */
{	int d, enemy1 = ROOK+ocolor, enemy2 = QUEEN+ocolor;
	for( d=0; d!=4; d++ )
	{	int i=square; int step=RB_dirs[d];
		do i += step; while( B[i] == 0 );
		if( B[i]==enemy1 || B[i]==enemy2 ) return 2;
	}
}

/* bishop or  queen */
{	int d, enemy1 = BISHOP+ocolor, enemy2 = QUEEN+ocolor;
	for( d=4; d!=8; d++ )
	{	int i=square; int step=RB_dirs[d];
		do i += step; while( B[i] == 0 );
		if( B[i]==enemy1 || B[i]==enemy2 ) return 2;
	}
}

/* king */
{	int i, enemy = KING+ocolor;
	for( i=0; i!=8; i++ )
	if( B[square+K_moves[i]] == enemy ) return 1;
}

return 0;

}



/* search carefuly. we expect fail-low at this node. */
short csearch(
	tmove *m, /* move list */
	short n,    /* number of moves */
	short Alpha, short Beta,
	short extend
)
{

short i;
short result;

for( i=0; i!=n; i++ )
{
	short max;

	{
		short j;
		max = i;
		for( j=i+1; j!=n; j++ ) if( m[j].value > m[max].value ) max=j;
	}

	do_move(m+max);

	result = - evaluate( -Alpha-1, -Alpha );

	if( result > Alpha )   /* let's look better at this move */
	{
		Depth+=extend;
		result = - evaluate( -Beta, -Alpha );
		Depth-=extend;
	}

	undo_move(m+max);

	FollowPV = 0;

	if( result > Alpha ) /* still better? ok, we can trust it. */
	{
		update_PV( m[max], Ply );
		Alpha = result;
		if(Alpha>=Beta) return Alpha;
		extend=0;
	}

	m[max] = m[i];
}

return Alpha;

}



short search(
	tmove *m, /* move list */
	short n,    /* number of moves */
	short Alpha, short Beta
)
{

short i;
short result;

if( Abort && ! NoAbort ) return 0;

for( i=0; i!=n; i++ )
{
	short max;

	{
		short j;
		max = i;
		for( j=i+1; j!=n; j++ ) if( m[j].value > m[max].value ) max=j;
	}

	do_move(m+max);

	if( i == 0 )
	result = - evaluate( -Beta, -Alpha );
	else
	{
		result = - evaluate( -Alpha-1, -Alpha );
		if( result>Alpha && result<Beta )
		result = - evaluate( -Beta, -Alpha-1 );
	}

	undo_move(m+max);

	FollowPV = 0;

	if( result > Alpha )
	{
/*
{ int i; for(i=Counter-Ply;i!=Counter;i++) printm(G[i].m,NULL);
  printf("[%i,%i] %i",Alpha,Beta,result); getchar(); }
*/
		update_PV( m[max], Ply );
		Alpha = result;
		if(Alpha>=Beta) return Alpha;
	}

	m[max] = m[i];
}

return Alpha;

}



int sortkey( const void *a, const void *b )
{ return ( ((tmove*)b)->value - ((tmove*)a)->value ); }



short EasyMove;

/**
*** Sorting root moves and detecting possible `Easy Move'.
**/
short sort_root_moves( tmove *m, int n )
{
	short i;
	short best = -CHECKMATE;
	short secondbest = -CHECKMATE;
	short result;

	FollowPV = 0;
	PV[0][0] = m[0];

	EasyMove = 0;
	Depth = 100;

	for( i=0; i!=n; i++ )
	{
		do_move(m+i);

		result = - evaluate( -CHECKMATE, CHECKMATE );

		m[i].value = result/4;
		if( m[i].in2 ) m[i].value += Values[ m[i].in2>>4 ];
		else if( m[i].special ) m[i].value += 100;
		if( checktest(Color) ) m[i].value += 150;

		undo_move(m+i);

		if( result > best )
		{
			tmove mm=m[0]; m[0]=m[i]; m[i]=mm;
			secondbest = best; best = result;
			update_PV( m[0], 0 );
		}
		else if( result > secondbest ) secondbest = result;
	}

	qsort( m+1, n-1, sizeof(tmove), sortkey );

	if( n == 1 ) EasyMove = 3;
	else
	if( abs(best) > CHECKMATE - 100 ) EasyMove = 2;
	else
	if( best - secondbest > 250 ) EasyMove = 2;
	else
	if( best - secondbest > 70 ) EasyMove = 1;

	if( Flag.post && EasyMove!=0 )
	{
		printf( "    -> easy move      (%i)  ", EasyMove );
		printm(m[0],NULL); puts("               ");
	}

/*	for( i=0; i!=n; i++ ) printm( m[i], NULL ); puts(""); */

	return best;
}



long LastTurn;
tmove root_search( void )
{

tmove m[256];
int n, i;
short Alpha, Beta;
short r;

Abort = 0; NoAbort = 1;

generate_legal_moves( m, &n, checktest(Color) );

if( Flag.book )
if( Counter < 20 || Bookout < 4 )
{
	int b = 0;

	if( Flag.easy && Counter > 4 )
	{ if( rand()%1024 < Flag.easy+Counter*16 ) b = -1; }

	if( b==0 ) b = bookmove( m, n );

	if( b != -1 )
	{
		/* PV[0][0] = m[b]; */
		Bookout = 0;
		PV[0][1].from = 0;   /* dont start pondering */
		m[b].value = 0;
		do_move(m+b);
		return m[b];
	} else Bookout ++;
}

init_killers();

if( n == 0 ) NoAbort = 0;
else
{
	short learndepth = 0;
	short learnalpha = 0;

	Nodes = 0;
	Age ++;

	A_n = n; A_m = m; A_i = 0;

	PV[0][0].from = 0;

	l_startsearch();

	Ply = 0;

	LastIter = Alpha = sort_root_moves( m, n );
	LastTurn = ptime();

	if( EasyMove == 3 ) { do_move(m); return m[0]; }

	FollowPV = 1;
	NoAbort = 0;
	Depth = 290; Ply = 0;
	A_d = 2;
	PlyLimit=11;

	signal(SIGINT,interrupt);

	while(   ( Flag.ponder==2 || l_iterate() )
	      && !Abort && Depth < MAXPLY*100      )
	{
		A_d++;

		Beta = Alpha + WINDOW;
		Alpha = Alpha - WINDOW;

		if( Flag.post && ! Flag.xboard ) verboseline( m, 0, n );

		for( i=0; i!=n; i++ )
		{
			A_i = i;

			do_move(m+i);
			if( i == 0 )
			{
				r = - evaluate( -Beta, -Alpha );
				if(!Abort) m[i].value = r;
				if( m[i].value <= Alpha && !Abort )
				{
					if( Flag.post ) infoline(4,NULL);
					r = - evaluate( -Alpha, CHECKMATE );
					if(!Abort) m[i].value = Alpha = r;
					update_PV( m[0], 0 );
					if( Flag.post ) infoline(1,NULL);
				}
			}
			else
			{
#define SWINDOW 5
				r = - evaluate( -Alpha-SWINDOW, -Alpha );
				if(!Abort) m[i].value = r;
				if( m[i].value > Alpha ) /* TURN */
				{
				  if( ! Abort )
				  {
				      update_PV( m[i], 0 );
				      LastTurn = ptime();
				      if( EasyMove != 0 )
				      {
				        EasyMove = 0;
				        if( Flag.post )
				        printf(
"    -> easy move off                                    \n" );
				      }
				  }
				if( m[i].value >= Alpha+SWINDOW )
				{
				  if( Flag.post ) infoline(2,NULL);
				  r = - evaluate( -Beta, -Alpha );
				  if(!Abort) m[i].value = r;
				}
				}
			}

			if( m[i].value >= Beta )
			{
				PV[0][0].value = Beta;
				if( Flag.post ) infoline(5,NULL);
				r = - evaluate( -CHECKMATE, -Beta );
				if(!Abort) m[i].value = r;
			}

			undo_move(m+i);

			if( Abort )
			{
				if( Abort == 1 && Flag.post )
					puts("\nsearch aborted");
				break;
			}

			if( m[i].value > Alpha )
			{
				short j; tmove pom;

				update_PV( m[i], 0 );
				Alpha = m[i].value;
				if( Flag.post ) infoline(1,NULL);

				/* bubble the move up */
				pom = m[i];
				for( j=i; j!=0; j-- ) m[j] = m[j-1];
				m[0] = pom;

				Beta = Alpha + WINDOW;
			}
		}

		if( !Abort && Depth>300 )
		{ learndepth = Depth; learnalpha = Alpha; }

		if( Flag.post ) infoline(3,NULL);
		Depth += 100; PlyLimit++;
		FollowPV = 1;

		if( abs(Alpha) > 29000 )
		{
			if( abs(Alpha)+Depth/100 > CHECKMATE ) break;

			if( EasyMove < 2 )
			{
				EasyMove = 2;
				if( Flag.post )
				printf(
"    -> forced checkmate -> easy move (2)              \n");
			}
		}

		LastIter = Alpha;
	}

	Depth -= 100;
	AllDepth += Depth;
	{
		extern long T1;
		long t=ptime()-T1;
		if( t != 0 ) AllNPS += 100*Nodes/t;
	}

	if( Flag.post ) infoline(0,NULL);

	if( Flag.learn && learndepth ) wlearn( learndepth, learnalpha );

	do_move(PV[0]);
}

signal(SIGINT,SIG_IGN);

return PV[0][0];

}

