#|------------------------------------------------------------*-Scheme-*--|
 | File:    test/expect.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.6
 | File mod date:    1997.11.29 23:10:42
 | System build:     v0.7.2, 97.12.21
 |
 `------------------------------------------------------------------------|#

(define *place* #f)
(define compare equal?)

(define (report-failure in-expr report-conditions-thunk)
  (if *place*
      (begin
	(set! *errors* (cons *place* *errors*))
	(display (make-string 60 #\-))
	(format #t "\nin ~j::\n" *place*)
	(set! *place* #f)))
  (format #t "ERROR IN ~@#*60s\n" in-expr)
  (report-conditions-thunk (current-output-port)))
  
(define (check* expr expected-value actual-value)
  (format #t "checking ~@#*60s\n" expr)
  (if (not (compare expected-value actual-value))
      (report-failure
       (mquote expr)
       (lambda (port)
	 (format port "  expected ~@#*60s\n" expected-value)
	 (format port "       got ~@#*60s\n" actual-value))))
  (values))

(define-syntax (check value expr)
  (check* (mquote expr) value expr))

(define-syntax (compare-using proc . body)
  (fluid-let ((compare proc))
    (begin . body)))

(define-syntax (test-section place . body)
  (fluid-let ((*place* (append (or *place* '()) (mquote place))))
    (begin . body)))


(define-syntax (expect-to-fail expr)
  (expect-to-fail* (mquote expr) (lambda () expr)))

(define (expect-to-fail* expr thunk)
  (format #t "checking failure of ~@#*60s\n" expr)
  (handler-case
   (let ((result (thunk)))
     (report-failure
      expr
      (lambda (port)
	(format port "  expected an exception to be raised,\n")
	(format port "  got ~@#*60s\n" result))))
   ((<condition>)
    #t))
  (values))

