/*-----------------------------------------------------------------*-C-*---
 * File:    handc/runtime/linkage.c
 *
 *          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 *          as part of the RScheme project, licensed for free use.
 *          See <http://www.rscheme.org/> for the latest information.
 *
 * File version:     1.10
 * File mod date:    1997.11.29 23:10:49
 * System build:     v0.7.2, 97.12.21
 *
 * Purpose:          `C' linkage unit utility functions
 *------------------------------------------------------------------------*/

#include <string.h>
#include <stdlib.h>
#include <rscheme/runtime.h>
#include <rscheme/smemory.h>
#include <rscheme/scheme.h>
#include <rscheme/allocns.h>

#if 0
#ifdef INLINES
#include "gcclient1.ci"
#include "gcclient2.ci"
#else
#include <rscheme/gcclient.h>
#endif
#endif

struct module_descr **master_table = NULL;
static rs_bool original_modules = YES;
    
#define IGNORE_FAULTS

void init_linkage( struct module_descr **initial_table )
{
    struct module_descr **m;

    master_table = initial_table;

    /* install any bytecode extensions that are in the initial
       set (statically linked) of modules */
       
    for (m=master_table; *m; m++)
      {
	unsigned i, n;
	struct module_descr *m1 = (*m);

	n = m1->num_bc_extensions;
	for (i=0; i<n; i++)
	  install_bc_extension( &m1->bc_extensions[i] );
      }

#ifdef GNU_VINSNS
    {
    struct module_descr **m;
    struct part_descr **p;
    struct function_descr **f;
    
	for (m=master_table; *m; m++)
	{
	    for (p=(*m)->parts; *p; p++)
	    {
		/*
		printf( "Fixing up %s,%s\n", (*m)->name, (*p)->name );
		*/
		for (f=(*p)->functions; *f; f++)
		{
		void **(*F)( void );
		
		    F = (void **(*)( void ))(*f)->monotones;
		    (*f)->monotones = (jump_addr *)F();
		}
	    }
	}
    }
#endif
}

void install_module( struct module_descr *new_module )
{
struct module_descr **s, **d, **new_table;
unsigned i, n;

    for (n=0, s=master_table; *s; s++, n++)
    {
      /* nothing */
    }

    new_table = (struct module_descr **)
    			malloc( sizeof( struct module_descr * ) * (n+2) );
    d = new_table;
    *d++ = new_module;
    s = master_table;
    while (*s)
	*d++ = *s++;
    *d++ = NULL;
    
    if (!original_modules)
	free( master_table );
    master_table = new_table;
    original_modules = NO;

    n = new_module->num_bc_extensions;
    for (i=0; i<n; i++)
      install_bc_extension( &new_module->bc_extensions[i] );
}

struct module_descr *dynamic_link_c_unit( const char *path,
					  const char *unit_name )
{
  void *handle;
  struct module_descr *ent;
  char ent_name[1024];

  handle = dynamic_link_file(path);
  if (!handle)
    {
      return NULL;
    }

  sprintf( ent_name, "module_%s", unit_name );
  ent = resolve_link_symbol( handle, ent_name );
  done_resolving( handle );

  if (!ent)
    {
      return NULL;
    }

  ent->loaded_from = malloc( strlen(path)+1 );
  strcpy( ent->loaded_from, path );

  install_module( ent );
  return ent;
}

struct part_descr *find_part( struct module_descr *m, int tag )
{
struct part_descr **p;

    for (p=m->parts; *p; p++)
    {
	if ((*p)->tag == tag)
	{
	    /* we've found the part */
	    return *p;
	}
    }
    return NULL;
}

static struct module_descr *find_module1( const char *module )
{
struct module_descr **m;

    for (m=master_table; *m; m++)
    {
	if (strcmp((*m)->name,module) == 0)
	{
	    /* we've found the module */
	    return *m;
	}
    }
    return NULL;
}

/*
 *  interpret a C unit name like "foo|/bar/baz/libfoo.so"
 *  as meaning the C unit "foo" as loaded from /bar/baz/libfoo.so
 *  (in case it's not loaded already, we can link it in)
 */

struct module_descr *find_module( const char *m_name )
{
  const char *b = strchr( m_name, '|' );
  if (b)
    {
      char *temp = malloc( b - m_name + 1 );
      struct module_descr *m;

      memcpy( temp, m_name, b-m_name );
      temp[b-m_name] = 0;

      m = find_module1( temp );
      if (!m)
	{
	  m = dynamic_link_c_unit( b+1, temp );
	}
      return m;
    }
  else
    {
      return find_module1( m_name );
    }
}

int process_module_roots( process_root_fn *fn, void *info )
{
  struct module_descr **p;
  obj *r;
  unsigned n;

  for (p=master_table; *p; p++)
    {
      r = (*p)->root_vector;
      n = (*p)->num_roots;
      while (n > 0)
	{
	  int rc = fn( r++, info );
	  if (rc)
	    return rc;
	  n--;
	}
    }
  return 0;
}
