/*-----------------------------------------------------------------*-C-*---
 * File:    handc/platform/sunos/dynlink.c
 *
 *          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 *          as part of the RScheme project, licensed for free use.
 *          See <http://www.rscheme.org/> for the latest information.
 *
 * File version:     1.5
 * File mod date:    1997.11.29 23:10:48
 * System build:     v0.7.2, 97.12.21
 *
 * Purpose:          SunOS dynamic linking interface
 *------------------------------------------------------------------------*/

#include <stdio.h>
#include "dynlink.h"

#ifdef HAVE_LIBDL
#include <dlfcn.h>
#endif

void *resolve_link_symbol( void *info, const char *sym )
{
#if HAVE_LIBDL
    return dlsym( info, sym );
#else
    return NULL;
#endif
}

void *dynamic_link_file( const char *path )
{
#if HAVE_LIBDL
    return dlopen( path, 1 );
#else
    return NULL;
#endif
}

void done_resolving( void *info )
{
}

void init_dynamic_link( const char *argv0 )
{
}


