#ifndef _H_COMPRESS
#define _H_COMPRESS

#include <rscheme/obj.h>

/* worst case is writing 2048 ptrs, ea. requiring a new page
   ref, and none of that compressing at all (5 bytes/word),
   leading to: 2048 data * 5 + 2048 refs * 5 * 2 words/ref = 30720 bytes
*/

struct Compressor {
    UINT_8	*ptr;
    UINT_8	temp[31744];
};

struct Decompressor {
    UINT_8	*ptr;
    UINT_8      *limit;
};

void init_compressor( struct Compressor *c );

void compress_word( struct Compressor *c, UINT_32 word );
void compress_obj( struct Compressor *c, obj item );

void stop_compressor( struct Compressor *c );
void close_compressor( struct Compressor *c );
UINT_32 compressed_size( struct Compressor *c );
void *compressed_data( struct Compressor *c );

void init_decompressor( struct Decompressor *d, void *data, UINT_32 len );

UINT_32 decompress_word( struct Decompressor *d );
obj decompress_obj( struct Decompressor *d );

void close_decompressor( struct Decompressor *d );

#endif /* _H_COMPRESS */
