
;;
;; commit the current state of the persistent store
;; (not particularly thread safe... if you have
;; one thread writing into the pstore while another
;; is trying to commit, the commit could never complete,
;; fail, and if it did, it won't necessarily represent
;; the state of the store a the time (commit) was
;; called

;;
;; if called with just one argument, doesn't change the root object
;;

(define (commit (ps <persistent-store>) . opt)
  (let ((root (if (null? opt)
		  (root-object ps)
		  (car opt))))
    (let ((reloc (make-object-table)))
      (set-relocation-table! ps reloc)
      (let loop ((i 0))
	(let ((cf (commit* ps root)))
	  (if (null? cf)
	      ;;
	      ;; return the new commit record ID
	      ;;
	      (commit-record-locator ps)
	      (begin
		(copy-in* ps reloc cf)
		(loop (+ i 1)))))))))

