#include "fasldef.h"

#if PLATFORM_ARCH_PPC

void init_stub_procs( struct FASL_Header *hdr, jump_addr stub )
{
  UINT_32 *f = (UINT_32 *)stub;
  /* this isn't really code; on POWER (and derivatives), calling
   * through a function pointer really involves destructuring
   * a FUNCTION DESCRIPTOR
   */
  hdr->stub_proc[0] = f[0];
  hdr->stub_proc[1] = f[1];
  hdr->stub_proc[2] = f[2];
}

#endif /* AIX, Rhapsody, etc */

/* linux, little-endian sunos boxes, FreeBSD, and Rhapsody for Intel
 * run on intel hardware
 */

#if PLATFORM_ARCH_I386

void init_stub_procs( struct FASL_Header *hdr, jump_addr stub )
{
  static UINT_32 stub_ptr;
  UINT_8 *d = (UINT_8 *)hdr->stub_proc;
  UINT_32 addr;
  
  stub_ptr = (UINT_32)stub;
  addr = (UINT_32)&stub_ptr;

  *d++ = 0xff;  /* jmp absolute indirect (4-byte addr of fn ptr) */
  *d++ = 0x25;
  *d++ = addr & 0xFF;
  *d++ = (addr >> 8) & 0xFF;
  *d++ = (addr >> 16) & 0xFF;
  *d++ = (addr >> 24) & 0xFF;
}
#endif /* LINUX */

#if PLATFORM_ARCH_SPARC

/* SPARC 
            +-----+----------------------+
    call    | 0 1 |  29-bit displacement |
            +-----+----------------------+

stub gateway

    ==> save %sp, -112, %sp     0x9de3bf90
        call real_stub          <call>
        nop                     0x01000000
        ret                     0x81c7e008
        restore                 0x91e80008
*/

void init_stub_procs( struct FASL_Header *hdr, jump_addr stub )
{
  static UINT_32 stub_ptr;
  UINT_32 *d = (UINT_32 *)hdr->stub_proc;
  UINT_32 addr = (UINT_32)stub;

  *d++ = 0x9de3bf90;
  *d = ((addr - (UINT_32)d) / 4) + 0x40000000;
  d++;
  *d++ = 0x01000000;
  *d++ = 0x81c7e008;
  *d++ = 0x91e80008;
}

#endif /* ARCH SPARC */

#if PLATFORM_ARCH_MIPS
/* courtesy of Chris <chrislee@gs157.sp.cs.cmu.edu> */

void init_stub_procs( struct FASL_Header *hdr, jump_addr stub )
{
  static UINT_32 stub_ptr, ptr_low, ptr_hi;
  unsigned base, offset;
  
  stub_ptr = (UINT_32)stub;
  ptr_low  = stub_ptr & 0xFFFF;
  ptr_hi   = (stub_ptr - ptr_low) >> 16;

  /* Load Upper Immediate
   * LUI(6)  0(5)  rt(5) imm(16)   (use rt = 25 = 11001 = "$jp" in gdb)
   * 001111  00000 11001 ptr_hi    (jp means "PIC jump register")
   * == 0011 1100 0001 1001 ptr_hi
   * == 0x3C19 ptr_hi
   *
   * Add Immediate Word Unsigned (note--this seems to do a _signed_ addition!)
   * ADDIU(6) rs(5) rt(5) imm(16)  (use rs = rt = 25 = 11001)
   * 001001   11001 11001 ptr_low
   * == 0010 0111 0011 1001 ptr_low
   * == 0x2739 ptr_low
   *
   * Jump register 
   * special(6) rs(5) 0(15) JR(6) (use rs = 25 = 11001)
   * 000000     11001 0(15) 001000
   * == 0000 0011 0010 0000 0000 0000 0000 1000
   * == 0x0320 0008
   *
   * NOP
   *  from gas source code it looks like it is
   * == 0x00000000.
   */

  if ( 0x8000 & ptr_low ) {
    /* _signed_ arithmetic of ADDIU will cause a _subtraction_ ! */
    ptr_hi += 0x1;   /* + 0x1000 because ptr_hi is shifted 16 bits */
    ptr_low = 0xFFFF & (unsigned)((int)ptr_low - 0x10000);
  }

  /* LW: GPR(24) <-- mem[addr]    */
  hdr->stub_proc[0] = 0x3C190000 | ptr_hi;
  hdr->stub_proc[1] = 0x27390000 | ptr_low;
  hdr->stub_proc[2] = 0x03200008;         /* JR : JR(GPR(25))  */
  hdr->stub_proc[3] = 0x00000000;         /* NOP */
}

#endif /* MIPS */
