
(define-syntax (julian-firsts leap?)
  (if leap?
      '#(1 1 32 61 92 122 153 183 214 245 275 306 336 367)
      '#(1 1 32 60 91 121 152 182 213 244 274 305 335 366)))


;;
;;  ymd->day
;;  convert a y/m/d date to it's calendar day number
;;
#|
146097  number of days in 400 years
{36524, 36524, 36524, 36525} number of days in each 100 years thereof
{1461, ..., 1460, ..., 
|#

;;
;;  this returns the same value as
;;    DateToNumber[{year,month,day},Gregorian]
;;

(define (ymd->day (year <fixnum>) (month <fixnum>) (day <fixnum>))
  (if (and (fixnum>? month 0)
	   (fixnum<=? month 12))
      (bind ((first-day leap? (year->first-day year))
	     (firsts-vec (julian-firsts leap?))
	     (jul (fixnum+ day (vector-ref firsts-vec month))))
	(if (and (fixnum>? day 0)
		 (fixnum<=? jul (vector-ref firsts-vec (add1 month))))
	    (fixnum+ jul (fixnum- first-day 2))
	    (error "day `~d' of month `~d' is out of range 1..~d"
		   day month (- (vector-ref firsts-vec (add1 month))
				(vector-ref firsts-vec month)))))
      (error "month `~d' is out of range 1..12" month)))
;;
;;  this returns the same value as DateToNumber[{year,1,1},Gregorian]
;;

(define (year->first-day (year <fixnum>))
  (bind ((four-centuries
	  century
	  four-years
	  year
	  leap? (year-parts year)))
    (values (+ (fixnum* 146097 four-centuries)
	       (fixnum* 36524 century)
	       (fixnum* 1461 four-years)
	       (fixnum* 365 year)
	       1)
	    leap?)))

;;
;;  This function returns the 
;;

(define (day->parts day)
  (digit-breakdown day (146097 36524 1461 365)))

;;

(define (day->ymd day)
  (bind ((c4
	  c
	  y4
	  y
	  m
	  d (list->values (my-digits day gregorian-calendar '()))))
    (values (fixnum+ (fixnum* (sub1 c4) 400) 
		     (fixnum+ (fixnum* (sub1 c) 100)
			      (fixnum+ (fixnum* (sub1 y4) 4) 
				       y)))
	    m
	    d)))
