#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/mlink/linkload.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.13
 | File mod date:    1997.11.29 23:10:31
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  mlink
 |
 | Purpose:          load and bind modules
 `------------------------------------------------------------------------|#

;;
;;  dynamically bind a module
;;

(define *boot-modules* '()) ;; filled in at boot image linkage time
(define *space* #f)

(define (installed-modules)
  (or *space* *boot-modules*))

(define (install-module! name module)
  (set! *space* (cons (cons name module) (installed-modules))))

;;
;;  `link-load-module' is only used to load modules for execution
;;  if you are doing different things (like the to-C-compiler), then
;;  you would use load-module directly, because you need to manage
;;  your own module namespace and not finalize/patch the loaded modules
;;

(define (link-load-module name path)
  (let ((m (load-module name path #t)))
    (link-into name m (installed-modules) #f)
    (for-each finalize-class (module-classes m))
    (for-each finalize-generic-function (module-generic-functions m))
    (for-each (lambda (method-set)
		(patch-implicit-methods (cdr method-set)
					(car method-set)))
	      (module-implicit-methods m))
    (install-module! name m)
    (for-each (lambda (thunk)
		(thunk))
	      (init-thunks m))
    (let ((startup-thunks (vector-ref (rscheme-global-ref 0) 3)))
      (append! startup-thunks (init-thunks m)))
    m))

;; most bindings issue a warning and use the new one

(define-method resolve-import-conflict ((self <binding>)
					(new-bdg <binding>)
					(name <symbol>)
					(tle <top-level-contour>))
  (format #t "warning: ~s already bound to ~s\n" name self)
  (table-insert! (table tle) name new-bdg))

(define-method resolve-import-conflict ((self <top-level-var>)
					(new-bdg <binding>)
					(name <symbol>)
					(tle <top-level-contour>))
  (if (instance? new-bdg <top-level-var>)
      (begin
	(if (not (or (eq? (value self) '#unbound)
		     (eq? (value self) (value new-bdg))))
	    (format #t "warning: TLV ~s already bound to ~s\n" 
		    name (value self)))
	(set-value! self (value new-bdg)))
      (begin
	(format #t "warning: ~s already bound to ~s = ~s\n" 
		name self (value self))
	(table-insert! (table tle) name new-bdg))))

;;

(define (use-module-in mname (m <module>) envt)
  (let ((t (table envt)))
    (set-dirty?! envt #t)
    (table-for-each
     (module-exports m)
     (lambda (h k v)
       (let ((b (table-lookup t k)))
	 (if b
	     (resolve-import-conflict b v k envt)
	     (begin
	       (table-install! t h k v)
	       (values))))))
    (for-each
     (lambda (hook)
       (hook envt))
     (usage-hooks m))
    (values)))

(define (use-in name envt)
  (if (eq? name 'all)
      (for-each (lambda (ent)
		  (use-module-in (car ent) (cdr ent) envt))
		(installed-modules))
      (use-module-in name (get-module name) envt)))
