#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/iolib/stdout.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.8
 | File mod date:    1997.11.29 23:10:41
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  iolib
 |
 | Purpose:          output through stdio, <std-output-port>
 `------------------------------------------------------------------------|#

;;
;;  an <output-port> using stdio
;;

(define-class <std-output-port> (<output-port>)
  file-stream)

(define-class <output-pipe-port> (<std-output-port>))

(define (open-output-file (path <string>))
  (let ((f (fopen path "w")))
    (if (not f)
	(error "open-output-file: open of `~a' failed" path))
    (make <std-output-port>
	  file-stream: f)))

(define (open-output-append-file (path <string>))
  (let ((f (fopen path "a")))
    (if (not f)
	(error "open-output-file: open of `~a' failed" path))
    (make <std-output-port>
	  file-stream: f)))


(define (open-output-process (str <string>))
  (let ((f (popen str "w")))
    (if (not f)
	(error "open-output-process: open of `~a' failed" str))
    (make <output-pipe-port>
	  file-stream: f)))

(define-syntax (an-open-stream method self)
  (let ((strm (file-stream self)))
    (if (eq? strm 0)
	(error "~s: output port is closed" (mquote method))
	strm)))

(define-method output-port-write-char ((self <std-output-port>)
				       (ch <ascii-char>))
  (fputc (an-open-stream output-port-write-char self) ch)
  (values))

(define-method write-string ((self <std-output-port>)
			     (str <string>))
  (let ((n (fwrite/str (an-open-stream write-string self) str)))
    (if (eq? n (string-length str))
	(values)
	(error "write-string: wrote only ~d out of ~d bytes"
	       n (string-length str)))))

;;

(define (flush-stdio-out self fs)
  (if (not (eq? (fflush fs) 0))
      (error "flush-output-port ~s: failed" self)))

(define-method close-output-port ((self <std-output-port>))
  (let ((fs (an-open-stream close-output-port self)))
    (flush-stdio-out self fs)
    (let ((rc (fclose fs)))
      (set-file-stream! self 0)
      (if (eq? rc 0)
	  (values)
	  (error "close-output-port ~s: failed" self)))))

(define-method close-output-port ((self <output-pipe-port>))
  (let ((fs (an-open-stream close-output-port self)))
    (flush-stdio-out self fs)
    (let ((rc (pclose fs)))
      (set-file-stream! self 0)
      (if (eq? rc 0)
	  (values)
	  (error "close-output-port ~s: failed" self)))))

(define-method flush-output-port ((self <std-output-port>))
  (flush-stdio-out self (an-open-stream flush-output-port self))
  (values))
