/*-----------------------------------------------------------------*-C-*---
 * File:    handc/cfg/gcadapt/irc/gcclient.c
 *
 *          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 *          as part of the RScheme project, licensed for free use.
 *          See <http://www.rscheme.org/> for the latest information.
 *
 * File version:     1.5
 * File mod date:    1997.11.29 23:10:44
 * System build:     v0.7.2, 97.12.21
 *
 * Purpose:          IRC GC adapater (scheme -> adapter -> gc)
 *------------------------------------------------------------------------*/

#include <rscheme/clientyp.h>
#include <rscheme/traverse.h>

#include <rscheme/vinsns.h>
#include <rscheme/gcserver.h>
#include <rscheme/linktype.h>
#include <rscheme/runtime.h>
#include <rscheme/smemory.h>
#include <rscheme/gcconfig.h>
#include <stdio.h>

IRC_Heap *gc_arena;
INT_32 gc_alloc_time;

#ifndef INLINES
#include "gcclient1.ci"
#include "gcclient2.ci"
#endif

void IRC_clientWriteViolation( IRC_Heap *heap, void *item, UINT_32 offset )
{
  scheme_error( "~s: write protected", 1, OBJ(((UINT_32)item)+POINTER_TAG) );
}

INT_32 left = 0;

void init_gc( int argc, const char **argv )
{
  gc_arena = IRC_newHeap();
  gc_alloc_time = 500000;
}

int gc_for_each( int (*fn)( void *info, void *heap_obj ), void *info )
{
  return IRC_forEachObject( gc_arena, fn, info );
}

void gc_now( void )
{
   IRC_fullCollect( gc_arena, NUM_GENERATIONS );
}
