/*-----------------------------------------------------------------*-C-*---
 * File:    handc/cfg/gc/irc/alloc.h
 *
 *          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 *          as part of the RScheme project, licensed for free use.
 *          See <http://www.rscheme.org/> for the latest information.
 *
 * File version:     1.6
 * File mod date:    1997.11.29 23:10:45
 * System build:     v0.7.2, 97.12.21
 *
 *------------------------------------------------------------------------*/

#ifndef _H_ALLOC
#define _H_ALLOC

#include <stdio.h>

#ifdef NDEBUG
#define atracef ((FILE *)0)
#else
extern FILE *atracef;
#endif

IRC_Header *IRC_growSizeClass( IRC_Heap *heap,
			       IRC_SizeClass *sc,
			       UINT_32 size );
/* aix: -Q+IRC_getBlock */

#ifdef __GNUC__
inline
#endif
static void *IRC_getBlock( IRC_Heap *heap, IRC_SizeClass *sc, UINT_32 size )
{
IRC_Header *p = sc->free;

    if (p == &sc->marker)
    {
	p = IRC_growSizeClass( heap, sc, size );
    }
    sc->free = p->next;
    p->sizeClass = sc;	/* may have died from an older size class */
    p->flagBits = sc->initFlagBits;
    return p+1;
}

#endif
