#|------------------------------------------------------------*-Scheme-*--|
 | File:    compiler/util/config-release.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.8
 | File mod date:    1997.11.29 23:10:28
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  (rsc)
 |
 `------------------------------------------------------------------------|#


;; exceptions to the rule that the file resulting from a 
;; subproject `make' has the same name as the subproject
;; directory

(define *alt-subproj-names*
   '(("loadboot" "ldboot")
     ("gc" "xgc")
     ("unstub" "unstb")))

(define (create-config-files component-modules)
  (let ((subprojects (apply append
			    *base-runtime-subprojects*
			    (map proj-names component-modules)))
	(link-units (apply append
			  *base-runtime-link-units*
			  (map link-names component-modules))))
    ;;
    ;; create the Makefile.in
    ;;
    (call-with-dest-output-file
     "Makefile.in"
     (lambda (port)
       (display "##\n" port)
       (display "## Makefile for RScheme @RSCHEME_BUILD@\n" port)
       (display "##\n" port)

       (display "SHELL=/bin/sh\n" port)
       (display "AR=ar ru\n" port)
       (display "RANLIB=@RANLIB@\n" port)
       (display "INSTALL_DIR=@prefix@\n" port)

       (display "@PREAMBLE@\n" port)
       (display "IFLAGS=-I. -I- -Iinstall/include\n" port)

       (format port "SUBPROJ=~a\n" 
	       (join " \\\n\t" 
		     (map (lambda (p)
			    ;; devil-spawn hack
			    (let ((alt (assoc p *alt-subproj-names*)))
			      (format #f "~a/~a.o" p (if alt (cadr alt) p))))
			  subprojects)))
       (format port "SUBPROJECTS=~a\n" (join " " subprojects))
       (display (file->string (pathname->string 
			       (locate-src-resource "buildenv/postambl.mak")))
		port)
       (for-each (lambda (p)
		   (let ((alt (assoc p *alt-subproj-names*)))
		     (format port "~a ~a/~a.o::\n" 
			     p p (if alt (cadr alt) p))
		     (format port "\tcd ~a ; $(MAKE)\n\n" p)))
		 subprojects)))
    ;;
    ;; create release.cfg
    ;;
    (call-with-dest-output-file
     "release.cfg"
     (lambda (port)
       (format port "RSCHEME_VERSION=~s\n" *rscheme-version*)
       (format port "RSCHEME_BUILD=~s\n" *rscheme-build*)))
    ;;
    ;; create rlseconf.h's template
    ;;
    (call-with-dest-output-header-file
     "install/include/rscheme/rlseconf.cfg"
     (lambda (port)
       (format port "#define RSCHEME_VERSION ~s\n" *rscheme-version*)
       (format port "#define RSCHEME_BUILD ~s\n" *rscheme-build*)))
    ;;
    ;; create stdmodul.h
    ;;
    (call-with-dest-output-header-file
     "install/include/rscheme/stdmodul.h"
     (lambda (port)
       (format port "#include <rscheme/linktype.h>\n")
       (for-each (lambda (n)
		   (format port "extern struct module_descr module_~a;\n" n))
		 link-units)
       (newline port)
       (format port "#define STD_MODULES_DECL ~a, (struct module_descr *)0\n"
	       (join ", \\\n\t" (map (lambda (i)
				       (format #f "&module_~a" i))
				     link-units)))))
    ;; 
    ;; create subproj.lst
    ;;
    (call-with-dest-output-file
     "subproj.lst"
     (lambda (port)
       (display (join " " subprojects) port)
       (newline port)))
    (values)))

(define (call-with-dest-output-header-file dest proc)
  (call-with-dest-output-file
   dest
   (lambda (port)
     (let ((guard (apply string (map char-upcase 
				     (string->list 
				      (filename (string->file dest)))))))
       (format port "#ifndef _H_RSCHEME_~a\n" guard)
       (format port "#define _H_RSCHEME_~a\n\n" guard)
       (proc port)
       (format port "#endif /* _H_RSCHEME_~a */\n\n" guard)))))

(define (call-with-dest-output-file dest proc)
  (call-with-output-path 
      (append-path *dist-path* (string->file dest))
    proc))

(define (join seperator list)
  (if (null? list)
      ""
      (let ((l (make-seq)))
	(seq-add! l (car list))
	(for-each (lambda (item)
		    (seq-add! l seperator)
		    (seq-add! l item))
		  (cdr list))
	(apply string-append (seq->list l)))))

