#|------------------------------------------------------------*-Scheme-*--|
 | File:    compiler/modules/defglue.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.6
 | File mod date:    1997.11.29 23:10:28
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  (rsc)
 |
 `------------------------------------------------------------------------|#


;; compile a "define-glue" construct

;; process the literal-special form "(& name)"
;; which evaluates to the <top-level-var> itself

(define (glue-literal expr envt)
  (if (and (pair? expr)
	   (eq? (car expr) '&))
      (if (and (eq? (length expr) 2)
	       (symbol? (cadr expr)))
	  (ensure-tlv (cadr expr) envt)
	  (error/syntax "bad `&' syntax: ~s" expr))
      (parse-const-expr expr envt envt)))

(define (compile-tl-define-glue tl-def tl-envt dyn-envt)
  (let ((body (cddr tl-def))
	(name (caadr tl-def))
	(args (cdadr tl-def))
	(literals '())
	(envt '())
	(template? #f))
    
    (if (eq? (car body) ':template)
	(begin
	  (set! template? #t)
	  (set! body (cdr body))))
    
    (if (eq? (car body) 'envt:)
	(begin
	  (if template?
	      (error/syntax 
	       "~a: `envt:' doesn't make sense for template"
	       name))
	  (set! envt
		(map
		 (lambda (l)
		   (glue-literal l tl-envt))
		 (cadr body)))
	  (set! body (cddr body))))

    (if (eq? (car body) 'literals:)
	(begin
	  (set! literals
		(map
		 (lambda (l)
		   (glue-literal l tl-envt))
		 (cadr body)))
	  (set! body (cddr body))))

    (if *tl-report*
	(format #t  "declaring raw glue: ~a ~a\n" 
		(if template? "template" "procedure")
		name))
    (let ((tmpl (glue-template name args literals body))
	  (tlv (ensure-writable-tlv name tl-envt)))
      (set-value! tlv
		  (if template? 
		      tmpl 
		      (make <target-closure>
			    environment: envt
			    template: tmpl)))
      (set-write-prot! tlv #t)
      ;; return #f => generate no initialization code
      #f)))

(define (glue-template name args literals body)
  (let ((tmpl (make-gvec* <template> 
			  0 0 '()
			  literals))
  	(bod (map (lambda (m)
		    (if (c-text? m)
			(c-text->string m)
			(if (pair? m)
			    (cons (car m) 
				    (c-text->string (cadr m)))
			    (error/syntax "bad glue body form: ~s" m))))
		    body)))
	(seq-add! (fluid-ref *code-descriptors*)
		    (make <code-descriptor>
			template: tmpl
			code-properties: (list (list 'function-scope
						     name))
			code: (vector args bod)
			strategy: 'literal-c))
	tmpl))

