.TH DTRSNA l "08 October 1994" "LAPACK version 2.0" "LAPACK routine (version 2.0)"
.TH DTRSNA l "08 October 1994" "BLAS routine" "BLAS routine"
.SH NAME
DTRSNA - estimate reciprocal condition numbers for specified eigenvalues and/or right eigenvectors of a real upper quasi-triangular matrix T (or of any matrix Q*T*Q**T with Q orthogonal)
.SH SYNOPSIS
.TP 19
SUBROUTINE DTRSNA(
JOB, HOWMNY, SELECT, N, T, LDT, VL, LDVL, VR,
LDVR, S, SEP, MM, M, WORK, LDWORK, IWORK,
INFO )
.TP 19
.ti +4
CHARACTER
HOWMNY, JOB
.TP 19
.ti +4
INTEGER
INFO, LDT, LDVL, LDVR, LDWORK, M, MM, N
.TP 19
.ti +4
LOGICAL
SELECT( * )
.TP 19
.ti +4
INTEGER
IWORK( * )
.TP 19
.ti +4
DOUBLE
PRECISION S( * ), SEP( * ), T( LDT, * ), VL( LDVL, * ),
VR( LDVR, * ), WORK( LDWORK, * )
.SH PURPOSE
DTRSNA estimates reciprocal condition numbers for specified
eigenvalues and/or right eigenvectors of a real upper
quasi-triangular matrix T (or of any matrix Q*T*Q**T with Q
orthogonal).

T must be in Schur canonical form (as returned by DHSEQR), that is,
block upper triangular with 1-by-1 and 2-by-2 diagonal blocks; each
2-by-2 diagonal block has its diagonal elements equal and its
off-diagonal elements of opposite sign.
.br

.SH ARGUMENTS
.TP 8
JOB     (input) CHARACTER*1
Specifies whether condition numbers are required for
eigenvalues (S) or eigenvectors (SEP):
.br
= 'E': for eigenvalues only (S);
.br
= 'V': for eigenvectors only (SEP);
.br
= 'B': for both eigenvalues and eigenvectors (S and SEP).
.TP 8
HOWMNY  (input) CHARACTER*1
.br
= 'A': compute condition numbers for all eigenpairs;
.br
= 'S': compute condition numbers for selected eigenpairs
specified by the array SELECT.
.TP 8
SELECT  (input) LOGICAL array, dimension (N)
If HOWMNY = 'S', SELECT specifies the eigenpairs for which
condition numbers are required. To select condition numbers
for the eigenpair corresponding to a real eigenvalue w(j),
SELECT(j) must be set to .TRUE.. To select condition numbers
corresponding to a complex conjugate pair of eigenvalues w(j)
and w(j+1), either SELECT(j) or SELECT(j+1) or both, must be
set to .TRUE..
If HOWMNY = 'A', SELECT is not referenced.
.TP 8
N       (input) INTEGER
The order of the matrix T. N >= 0.
.TP 8
T       (input) DOUBLE PRECISION array, dimension (LDT,N)
The upper quasi-triangular matrix T, in Schur canonical form.
.TP 8
LDT     (input) INTEGER
The leading dimension of the array T. LDT >= max(1,N).
.TP 8
VL      (input) DOUBLE PRECISION array, dimension (LDVL,M)
If JOB = 'E' or 'B', VL must contain left eigenvectors of T
(or of any Q*T*Q**T with Q orthogonal), corresponding to the
eigenpairs specified by HOWMNY and SELECT. The eigenvectors
must be stored in consecutive columns of VL, as returned by
DHSEIN or DTREVC.
If JOB = 'V', VL is not referenced.
.TP 8
LDVL    (input) INTEGER
The leading dimension of the array VL.
LDVL >= 1; and if JOB = 'E' or 'B', LDVL >= N.
.TP 8
VR      (input) DOUBLE PRECISION array, dimension (LDVR,M)
If JOB = 'E' or 'B', VR must contain right eigenvectors of T
(or of any Q*T*Q**T with Q orthogonal), corresponding to the
eigenpairs specified by HOWMNY and SELECT. The eigenvectors
must be stored in consecutive columns of VR, as returned by
DHSEIN or DTREVC.
If JOB = 'V', VR is not referenced.
.TP 8
LDVR    (input) INTEGER
The leading dimension of the array VR.
LDVR >= 1; and if JOB = 'E' or 'B', LDVR >= N.
.TP 8
S       (output) DOUBLE PRECISION array, dimension (MM)
If JOB = 'E' or 'B', the reciprocal condition numbers of the
selected eigenvalues, stored in consecutive elements of the
array. For a complex conjugate pair of eigenvalues two
consecutive elements of S are set to the same value. Thus
S(j), SEP(j), and the j-th columns of VL and VR all
correspond to the same eigenpair (but not in general the
j-th eigenpair, unless all eigenpairs are selected).
If JOB = 'V', S is not referenced.
.TP 8
SEP     (output) DOUBLE PRECISION array, dimension (MM)
If JOB = 'V' or 'B', the estimated reciprocal condition
numbers of the selected eigenvectors, stored in consecutive
elements of the array. For a complex eigenvector two
consecutive elements of SEP are set to the same value. If
the eigenvalues cannot be reordered to compute SEP(j), SEP(j)
is set to 0; this can only occur when the true value would be
very small anyway.
If JOB = 'E', SEP is not referenced.
.TP 8
MM      (input) INTEGER
The number of elements in the arrays S (if JOB = 'E' or 'B')
and/or SEP (if JOB = 'V' or 'B'). MM >= M.
.TP 8
M       (output) INTEGER
The number of elements of the arrays S and/or SEP actually
used to store the estimated condition numbers.
If HOWMNY = 'A', M is set to N.
.TP 8
WORK    (workspace) DOUBLE PRECISION array, dimension (LDWORK,N+1)
If JOB = 'E', WORK is not referenced.
.TP 8
LDWORK  (input) INTEGER
The leading dimension of the array WORK.
LDWORK >= 1; and if JOB = 'V' or 'B', LDWORK >= N.
.TP 8
IWORK   (workspace) INTEGER array, dimension (N)
If JOB = 'E', IWORK is not referenced.
.TP 8
INFO    (output) INTEGER
= 0: successful exit
.br
< 0: if INFO = -i, the i-th argument had an illegal value
.SH FURTHER DETAILS
The reciprocal of the condition number of an eigenvalue lambda is
defined as
.br

        S(lambda) = |v'*u| / (norm(u)*norm(v))
.br

where u and v are the right and left eigenvectors of T corresponding
to lambda; v' denotes the conjugate-transpose of v, and norm(u)
denotes the Euclidean norm. These reciprocal condition numbers always
lie between zero (very badly conditioned) and one (very well
conditioned). If n = 1, S(lambda) is defined to be 1.
.br

An approximate error bound for a computed eigenvalue W(i) is given by

                    EPS * norm(T) / S(i)
.br

where EPS is the machine precision.
.br

The reciprocal of the condition number of the right eigenvector u
corresponding to lambda is defined as follows. Suppose
.br

            T = ( lambda  c  )
.br
                (   0    T22 )
.br

Then the reciprocal condition number is
.br

        SEP( lambda, T22 ) = sigma-min( T22 - lambda*I )
.br

where sigma-min denotes the smallest singular value. We approximate
the smallest singular value by the reciprocal of an estimate of the
one-norm of the inverse of T22 - lambda*I. If n = 1, SEP(1) is
defined to be abs(T(1,1)).
.br

An approximate error bound for a computed right eigenvector VR(i)
is given by
.br

                    EPS * norm(T) / SEP(i)
.br

