#!/usr/local/bin/perl5
$| = 1;
# edit_pr.pl - Problem Report editor
# 
$pathinfo = $ENV{"PATH_INFO"};
@pathlist = split(/\//, $pathinfo);
$prog = shift(@pathlist);
$domain = shift(@pathlist);
$username = shift(@pathlist);
$eladdress = shift(@pathlist);
$domain =~ s/^/-/;
$path = join("/", @pathlist);
$path2 = join("/","",$username,$eladdress);
 
if ($path eq "") {
    $path = "";
} else {
    $path = ("/".$path);
}

require "/nnnn/nnn/www/cgi-bin/libgnats.pl";
require "/nnnn/nnn/www/cgi-bin/cgi-lib.pl";

$SCRIPT_NAME = "/gnats".$domain.$path2;
$EDITOR_FILE = "$GNATS_ADM/editors".$domain;
$ORIGIN_FILE = $EDITOR_FILE;
$LSPROG      = "/bin/ls";


print "Content-type: text/html\n\n";
print "<HTML>\n";
&read_originator;
&read_editor;
&ReadParse(*in);

# Gives the interface to change the PR


    # Display title
    print "<HEAD><TITLE>Problem Report editing</TITLE></HEAD><BODY>\n";
#    print &PrintHeader, &PrintVariables(%in);
#   print "<H3> elquery string es $QUERY_STRING</H3>\n";
    $pr = $in{'pr'};
    if ($pr eq "") {
	print "<H3>Sorry</H3>\n";
	print "You must specify the number of the problem report to edit.\n";
	return;
    }
    $err = &read_pr($pr, "");
    if ($err ne "") {
	print "$err\n";
	return;
    }
    local($oldsyn) = $fieldvalues{"Synopsis"};
    local($oldstate) = $fieldvalues{"State"};
    local($oldresp) = $fieldvalues{"Responsible"};
    local($oldcategory) = $fieldvalues{"Category"};
    local($oldstartdate) = $fieldvalues{"Start-Date"};
    local($oldenddate) = $fieldvalues{"End-Date"};
    local($oldfix);
    ($oldfix = $fieldvalues{"Response"}) =~ s/"/'/g;

    # Kludge to allow editing of Response and How-To-Repeat fields
    local($oldhowtorepeat) = $fieldvalues{"How-To-Repeat"};
    # end of kludge
    $oldresp =~ s/\s*\(.*$//; # Get rid of comment in responsible party name

    local($timestamp)=&timestamp($fullpr);


$catindom=0; # category in domain?
foreach $categ (@nCategory) {
    if ($categ eq $oldcategory) {
	$catindom=1;
    }
}
if ($catindom==0) {
    print "<p>The problem report doesn't belong to the domain $domain. You cannot modify it. </p>";
    print "\n</body></HTML>";
    exit(0);
}


    # The modification form
    print "
<H2>Modification form for Problem Report number $pr</H2>
Description: " . &html_escape($oldsyn) . " <BR>

<BR>
Click
<A HREF=\"$SCRIPT_NAME/full/$pr\">
here
</A>
to view the full text of Problem Report number $pr
<P>
<FORM METHOD=\"POST\" ACTION=\"$SCRIPT_NAME/handle_edit_pr/$pr&$oldstate&$timestamp\">
";

    # Maximize box dimensions
    local($width)= 80;
    local($height)= 4;

#    print "<dl>
#<dt>Editor (you):
#<dd><SELECT NAME=\"Editor\" SIZE=10>\n";
#    for (sort keys(%nEditor)) {
#	print "<OPTION> $_\n";
#    }
#   print "</SELECT><BR>\n";

 if ($username eq "1") {
	$username = ""
	}
if ($eladdress eq "1") {
	$eladdress = ""
	}

 print "<dl>
<dt><h2>Editor :  $username</h2>
<input   name=\"Editor\" value=$username >\n
<P>
<hr>
";


    print "<dt>Normally the problem report will change 
    <a href=\"/file/help.html#state\">state</a> each time it is modified. 
    Please select a new <a href=\"/file/help.html#state\">state</a> from 
    the following list:\n";
    print "<dd>";
    print "<SELECT NAME=\"State\">\n";
    foreach $option (@nState) {
	next if (!$option);
	print "<OPTION";
	if ($option eq $oldstate) { print " SELECTED"; }
	print "> $option\n";
    }
    print 
    "</SELECT><BR>
<dt>Please give the reason for the state change here:<dd><TEXTAREA NAME=\"StateReason\" COLS=$width ROWS=2></TEXTAREA>
<br>
";

   

    print "<dt>If the problem report has been re-assigned you will need to
    select the new responsible person from the following list:\n";
    print "<dd>";
    print "<SELECT NAME=\"Responsible\">\n";
    local($somebody_resp);

# Kludge to list only responsibles for that category

open(CATEG, "$GNATS_ADM/categories".$domain) ||
	die "Couldn't get categories file\n";
    while (<CATEG>) {
	if (!/^\s*#|^\s*\n$/) {
	    chop;
	    @nResp = split(/:/, $_);
	    $cat=shift(@nResp);
	    $descr=shift(@nResp);
	    $a=@nResp;
	    #print " responsibles @nResp length $a\n";
	    if ($cat eq $fieldvalues{"Category"} ) {
       		$save = shift(@nResp);
		@nResp = split(/,/, $nResp[0]);
		unshift(@nResp,$save);
		foreach $option (@nResp) {
		    next if (!$option);
		   
	print "<OPTION";
		   
	if ($option eq $oldresp) { print " SELECTED"; $somebody_resp = 1; }
	print "> $option\n";
		}
    print "</SELECT><BR>\n";
		print "<dt><hr>";
#    if (! $somebody_resp) {
#	print "Error!  No known person responsible for this bug!\n";
#
#	}    
#		print " Responsibles for $category $option\n";
	    }
	}
    }
          if (! $somebody_resp) {
	print "Error!  No known person responsible for this bug!\n";
    }
    close(CATEG);
# end Kludge

print "<dt><a href=\"/file/help.html#occurencetime\">Date and time of occurence</a>:";
print "<dd><input name=\"Start-Date\" value=\"$oldstartdate\"><br><br>\n";

print "<dt><a href=\"/file/help.html#enddatetime\">Date and time of end</a>:";
print "<dd><input name=\"End-Date\" value=\"$oldenddate\"><br><br>\n";

print "<dt><a href=\"/file/help.html#response\">Response</a>:";
print "<dd><textarea name=\"Response\" value=\"$oldfix\" rows=15 cols=$width></textarea><br>\n";

print "<dt><a href=\"/file/help.html#repeat\">How to repeat</a>:";
print "<dd><textarea name=\"How-To-Repeat\" value=\"$oldhowtorepeat\" rows=$height cols=$width></textarea>\n";

print "<dt><hr>";

#    foreach $option (@nResponsible) {
#	next if (!$option);
#	print "<OPTION";
#	if ($option eq $oldresp) { print " SELECTED"; $somebody_resp = 1; }
#	print "> $option\n";
#    }
#    print "</SELECT><BR>\n";
#    if (! $somebody_resp) {
#	print "Error!  No known person responsible for this bug!\n";
#       }
#    print "<dt>If responsible person changed, give the reason here:";
#    print "<dd><TEXTAREA NAME=\"ResponsibleReason\" COLS=$width ROWS=$height></TEXTAREA>\n";
            $dom=$domain;
	    $dom =~ s/^-//;
 #make sure that the list of categories will fit on the screen
 $mode = eval "\@nCategory" >30 ? "SIZE=5" : "";
#print @nCategory."\n";

print "<h3> Domain/Category Selection </h3>";

 print "<dt>If the problem report has been moved within the <b>$dom</b> domain
- please select the new category below:\n";
    print "<dd>";
    print "<SELECT $mode NAME=\"Category\">\n";
    foreach $option (@nCategory) {
	next if (!$option);
	print "<OPTION";
	if ($option eq $fieldvalues{"Category"}) { print " SELECTED"; }
	print "> $option\n";
    }
    print "</SELECT><BR>\n";

print "<dt><hr>";

print " If the problem report has been incorrectly filed to the <b>$dom</b> 
domain - please select the correct domain and category from the selection boxes below.<br>";

print "<br>";

#adding new buttons for different domains and its categories

open(DOMAIN, "$GNATS_ADM/domains") ||
	die "Couln't get domains file\n";
    while (<DOMAIN>) {
	if (!/^\s*#|^\s*\n$/) {
	    $_ =~ s/^/-/;
	    push(@nDomain, $_);
	}
    }
    close(DOMAIN);
    @nDomain = sort(@nDomain);
    
$i=1;


foreach $dom (@nDomain) {
 
    #Make sure that the list of categories for each domain will fit on the screen
    @nCat=&read_domain($dom);
    $mode = eval "\@nCat">10 ? "SIZE=5" : "";
    next if (!$dom);

# it seems that it appends a blank space at the end of the domain if it is not
# the first domain from the file. 
    if ($i>0) {chop($dom);}
    $i++;
 
    if ($dom ne $domain) {
    $dom =~ s/^-//;
    print "<dt>New category in the <b>$dom</b> domain\n";
    $dom =~ s/^/-/;
    print "<dd>";
    print "<select $mode name=\"Category$dom\">\n";

    foreach $option (@nCat) {       
        next if (!option);
	print "<option" ;
	# if ($option eq $fieldvalues{"Category"}) {print " selected";}
	# if we execute this line, then a pr with category "pending" will have
	# category pending in all the domains -> it will have a selected 
	# category in 
	# more than 1 domain -> it will be always an error!
	print "> $option\n";
    }   
    print "</select><br>\n";

}
}
    

#end adding new buttons
   


 print "</dl>\n";
    print "<INPUT TYPE=\"submit\" VALUE=\"Click here to submit the changes.\">\n";
print "<input type=\"reset\" value=\"Clear\">\n";
    print "</FORM>\n";
print "\n</body>\n";
print "</HTML>\n";
exit(0);






















