.TH "FTNCHEK 2.9" 1L "4 Apr 1996"
.\" ====================================================================
.\"  @Troff-man-file{
.\"     author          = "Robert K. Moniot",
.\"     version         = "2.9.4",
.\"     date            = "4 Apr 1996"
.\"     time            = "20:52:25 EST",
.\"     filename        = "ftnchek.man",
.\"     address         = "Fordham University
.\"                        New York, NY 10023
.\"                        USA",
.\"     telephone       = "+1 212 636 6311",
.\"     email           = "moniot@mary.fordham.edu",
.\"     codetable       = "ISO/ASCII",
.\"     keywords        = "Fortran 77, syntax check, type declarations",
.\"     supported       = "yes",
.\"     docstring       = "This file is the source for the UNIX manual
.\"                        page document (ftnchek.1), and is also used to
.\"                        generate the flat ASCII version of the
.\"                        documentation (ftnchek.doc), the PostScript
.\"                        version (ftnchek.ps), the blurb used for
.\"                        informational mailings (blurb.txt), and the
.\"                        VMS HELP document (ftnchek.hlp) used to make a
.\"                        HELP library file.  For the latter, define the
.\"                        number register ``h'' to be nonzero, and
.\"                        filter the output thru col (see the Makefile)."
.\"
.\"                        If the next line after these comments is not
.\"                        ``.ie \nh \{'' then the HELP and blurb
.\"                        materials have been removed and this file is
.\"                        ftnchek.1.  You should edit only ftnchek.man
.\"                        and remake ftnchek.1 et al from it.  The
.\"                        blurb is created by setting number register
.\"                        ``b'' nonzero.
.\"
.\"  }
.\" ====================================================================
.ie \nh \{
.po 0
.ll 70
.de PP
.in 1
.ti +5
..
.de IP
.in 1
.ti 5
.sp 1
..
.de TP
.in 8
.ti -4
..
.de RE
.in 1
..
.in 0
1 FTNCHEK
.PP
\}
.el \{
.SH "NAME"
\}
ftnchek \- Fortran 77 program checker
.if !\nh \{
.SH "SYNOPSIS"
.B ftnchek
[
.BR \-arguments [=\fInum\fP]
]
[
.BR \-array [=\fInum\fP]
]
.if n .ti +5
[
.BR \-calltree [=\fInum\fP]
]
[
.BR \- [ no ] check
]
[
.BR \-columns [=\fInum\fP]
]
.if n .ti +5
.if t .ti +.5i
[
.BR \-common [=\fInum\fP]
]
[
.BR \- [ no ] crossref
]
[
.BR \- [ no ] declare
]
.if n .ti +5
[
.BR \- [ no ] division
]
[
.BR \- [ no ] extern
]
.if t .ti +.5i
[
.BR \- [ no ] f77 [ = \fIstr\fP]
]
.if n .ti +5
[
.BR \- [ no ] help
]
[
.BI \-include= str
]
[
.BR \-intrinsic [=\fInum\fP]
]
.if n .ti +5
[
.BR \- [ no ] library
]
[
.BR \- [ no ] list
]
.if t .ti +.5i
[
.BR \-makedcls [=\fInum\fP]
]
.if n .ti +5
[
.BR \- [ no ] novice
]
[
.BI \-output= str
]
.if n .ti +5
[
.BR \- [ no ] portability [ = \fIstr\fP]
]
.if t .ti +.5i
[
.BR \- [ no ] pretty [ = \fIstr\fP]
]
.if n .ti +5
[
.BR \- [ no ] project
]
[
.BR \- [ no ] pure
]
[
.BR \- [ no ] quiet
]
.if n .ti +5
[
.BR \- [ no ] reference
]
.if t .ti +.5i
[
.BR \- [ no ] resources
]
.if n .ti +5
[
.BR \- [ no ] sixchar
]
[
.BR \- [ no ] sort
]
[
.BR \-source [=\fInum\fP]
]
.if n .ti +5
[
.BR \- [ no ] symtab
]
.if t .ti +.5i
[
.BR \- [ no ] truncation [ = \fIstr\fP]
]
.if n .ti +5
[
.BR \-usage [=\fInum\fP]
]
[
.BR \- [ no ] vcg
]
[
.BR \- [ no ] version
]
.if n .ti +5
[
.BR \- [ no ] volatile
]
.if t .ti +.5i
[
.BR \-wordsize [=\fInum\fP]
]
[
.BR \-wrap [=\fInum\fP]
]
.if n .ti +5
[
.I files ...
]
\}
.ie \nh \{
.in 0
2 Introduction
\}
.el \{
.SH "DESCRIPTION"
\}
.PP
\fBftnchek\fP (short for Fortran checker)
is designed to detect certain errors in a
Fortran program that a compiler usually does not.
\fBftnchek\fP is not primarily
intended to detect syntax errors.  Its purpose is to assist the user in finding
semantic errors.  Semantic errors are legal in the Fortran language but are
wasteful or may cause incorrect operation.  For example, variables which are
never used may indicate some omission in the program; uninitialized variables
contain garbage which may cause incorrect results to be calculated; and
variables which are not declared may not have the intended type.
\fBftnchek\fP is
intended to assist users in the debugging of their Fortran program.  It is not
intended to catch all syntax errors.  This is the function of the compiler.
Prior to using \fBftnchek\fP,
the user should verify that the program compiles
correctly.
.ie \nh \{
For more detailed information, consult the printed documentation.
\}
.el \{
.if !\nb \{
.PP
This document first summarizes how to invoke \fBftnchek\fP.
That section should be read before beginning to use \fBftnchek\fP.
Later sections describe \fBftnchek\fP's
options in more detail, give an example of its use, and explain
how to interpret the output.  The final sections mention the limitations
and known bugs in
\fBftnchek\fP.
\}
.SH "INVOKING FTNCHEK"
\}
.if \nh \{
.in 0
2 Invoking_Ftnchek
.PP
\}
\fBftnchek\fP is
invoked through a command of the form:
.sp 1
.ce 1
\fC$ ftnchek [-option -option ...] filename [filename ...]\fP
.PP
The brackets indicate something which is optional.  The brackets
themselves are not actually typed.  Here options are command-line
switches or settings, which control the operation of the program and the
amount of information that will be printed out.  If no option is
specified, the default action is to print error messages, warnings,
and informational messages, but not the program listing or symbol tables.
.PP
.ie \nh \{
Each option begins with the '/' character.
(\fBftnchek\fP also allows the '-' character to be used.)
\}
.el \{
Each option begins with the '\-' character.
(On VAX/VMS or MS-DOS systems you may use either '/' or '\-'.)
The options are described at greater length in the next section.
\}
.PP
\fBftnchek\fP options fall into two categories: switches, which are either
true or false, and settings, which have a numeric or string value.  The
name of a switch is prefixed by 'no' to turn it off:
e.g. \fB\-nopure\fP
would turn off the warnings about impure functions. The 'no' prefix
can also be used with numeric settings, having the effect of turning
off the corresponding warnings.
Settings that control lists of warnings have a special syntax discussed
below.
Only the first 3
characters of an option name (not counting
.ie \nh the '/')
.el     the '\-')
need be provided.
A colon may be used in place of an equals sign for numeric or string setting
assignments; however, we show only the equals sign form below.
.if !\nh \{
.PP
The switches and settings which \fBftnchek\fP currently recognizes are:
.TP
.BI \-arguments= num
Set level of strictness in checking subprogram
arguments.  Min is 0 (no checking).  Max is 3 (most checking).
Default = turn-on = 3.
.TP
.BI \-array= num
Set level of strictness in checking array arguments of
subprograms.  Min is 0 (least strict).  Max is 3 (most strict).
Default = turn-on = 3.
.TP
.BI \-calltree= num
Produce subprogram call hierarchy in one of 3 formats.
Default = 0, no tree.  Turn-on = 1, call-tree format.  Other values
are 2, who-calls-who and 3, VCG.
.TP
.B \-check
Perform checking.  Default = yes.
.TP
.BI \-columns= num
Set maximum line length to \fInum\fP columns. (Beyond
this is ignored.)  Turn-on = max = 132.  Default = 72.
.TP
.BI \-common= num
Set level of strictness in checking COMMON blocks.
Min is 0 (no checking).  Max is 3 (must be identical).  Default =
turn-on = 3.
.TP
.B \-crossref
Print cross-reference list of subprogram calls and
COMMON block use.  Default = no.
.TP
.B \-declare
Print a list of all identifiers whose datatype is not
explicitly declared.  Default = no.
.TP
.B \-division
Warn wherever division is done (except division by a
constant).  Default = no.
.TP
.B \-extern
Warn if external subprograms which are invoked
are never defined.  Default = yes.
.TP
.BI \-f77= list
Control specific warnings about supported extensions to the Fortran 77
Standard.  Default  = none.
.TP
.B \-help
Print command summary.  Default = no.
.TP
.BI \-include= path
Define a directory to search for INCLUDE files.
Cumulative.
.TP
.BI \-intrinsic= num
Control treatment of nonstandard intrinsic functions.  Three digits.
Max = 223.  Default = turn-on = 222 for Unix
version, 223 for VMS version, 221 for others.
.TP
.B \-library
Begin library mode: do not warn about subprograms
in file that are defined but never used.  Default = no.
.TP
.B \-list
Print source listing of program.  Default = no.
.TP
.BI \-makedcls= num
Prepare a file of declarations.  Min is 0 (no declaration
file).  Max is 1023.  Default = 0, turn-on = 1.
.TP
.B \-novice
Give output suitable for novice users.  Default = yes.
.TP
.BI \-output= filename
Send output to the given file.
Default is to send output to the screen. (Default filename extension
is \fI.\|lis\fP).
.TP
.BI \-portability= list
Warn about non-portable usages.  Default = none.
.TP
.BI \-pretty= list
Give warnings for possibly misleading appearance
of source code.    Default = all.
.TP
.B \-project
Create project file (see explanation below).  Default =
no.
.TP
.B \-pure
Assume functions are pure, i.e. have no side effects.
Default = yes.
.TP
.B \-quiet
Produce less verbose output.  Default = no.
.TP
.B \-reference
Print table of subprograms referenced by each subprogram.
Default = no.
.TP
.B \-resources
Print amount of resources used in analyzing the program.
Default = no.
.TP
.B \-sixchar
List any variable names which clash at 6 characters length.
Default = no.
.TP
.B \-sort
Print list of subprograms sorted in prerequisite order.
Default = no.
.TP
.BI \-source= num
Select source formatting options.  Sum of 1 for DEC Fortran
tab-formatted lines, 2 for VMS-style INCLUDE statement,
and 4 for UNIX-style backslash escape sequences.  Default = 0.
Turn-on = max = 7.
.TP
.B \-symtab
Print symbol table for each subprogram.  Default = no.
.TP
.BI \-truncation= list
Check for possible loss of accuracy by truncation.
Default = all.
.TP
.BI \-usage= num
Control warnings about unused variables, etc.  Three digits: 1st
digit = subprograms, 2nd digit = common, 3rd digit = local variables.
For each digit: min is 0
(no checking). Max is 3 (most checking).  Default = turn-on = 333.
.TP
.B \-vcg
Produce VCG format of call graph.
.TP
.B \-version
Print version number.  Default = no.
.TP
.B \-volatile
Assume COMMON blocks lose definition between
activations.  Default = no.
.TP
.BI \-wordsize= num
Set the default word size for numeric
quantities to \fInum\fP bytes.  Default = turn-on = 4 bytes.
.TP
.BI \-wrap= num
Set output column at which to wrap long error messages and
warnings to the next line.  If set to 0, turn off wrapping.  Default =
turn-on = 79.
\}
.PP
.ie \nh \{
When more than one option is used, they should be separated by a blank
space.
\}
.el \{
When more than one option is used, they should be separated by a blank
space, except on systems such as VMS where options begin with slash ( / ).
\}
No blank spaces may be placed around the equals sign ( = ) in a setting.
\fCftnchek "?"\fR
will produce a command summary listing all options and settings.
.PP
For settings that take a list of warnings, namely \fB\-f77\fP,
\fB\-pretty\fP, \fB\-portability\fP, and \fB\-truncation\fP,
the list consists of keywords
separated by commas or colons.  The list can be omitted, having the
effect of turning on all the corresponding warnings.  Also, if the
list is omitted, the setting name can be prefixed with \fBno\fP to
turn off all the warnings it controls.  For example, \fB\-f77\fP turns
on all warnings about nonstandard constructions, while
\fB\-nof77\fP turns them all off.    Three special keywords are:
.TP
.B help
Print out all the warning option keywords controlled by the setting,
with a brief explanation of their meanings.
This keyword cannot be given in a list with other keywords.
.TP
.B all
Set all warnings. This turns on all warnings controlled by the setting.
.TP
.B none
Clear all warnings.  This turns off all warnings controlled by the setting.
.PP
These special keywords must be given in full.  For all other warning
keywords, only as many letters of the keyword as are necessary to
identify it unambiguously need be given.  Including a keyword in the
list turns its warnings on.
For example, \fB\-f77=intrinsic\fP would
turn on only the warnings about use of nonstandard intrinsic functions.
Prefixing a keyword by \fBno\-\fP turns its warnings off.
For example,
\fB\-pretty=no\-long\-line\fP turns off warnings about lines
exceeding 72 columns in length while leaving all other warnings about
misleading appearance in effect.
If a setting has default \fBnone\fP, you can turn on all warnings
except one or two by using \fBall\fP first.
For example,
\fB\-f77=all,no\-include\fP enables warnings about all nonstandard
extensions except INCLUDE statements.
If a setting has default \fBall\fP, you can turn off all warnings
except one or two by using \fBnone\fP first.
For example,
\fB\-truncation=none,demotion\fP would turn off all precision related
warnings except about demotions.
.PP
When \fBftnchek\fP starts up, it looks for environment variables
and also for a preferences file.
Any options defined in the environment or in the preferences file are
used as defaults in place of the built-in defaults.  They are
over-ridden by any command line options.
See the section on changing the defaults for details about the
environment options and the preferences file.
.PP
.ie \nh \{
.in 0
2 Files
.PP
When giving a name of an input file, the extension is optional.  If no
extension is given, \fBftnchek\fP will first look for a project file
with extension \fI.\|prj\fP, and will use that if it exists.  If not, then
\fBftnchek\fP will look for a Fortran source file
with the extension \fI.\|for\fP.
\}
.el \{
When giving a name of an input file, the extension is optional.  If no
extension is given, \fBftnchek\fP will first look for a project file
with extension \fI.\|prj\fP, and will use that if it exists.  If not, then
\fBftnchek\fP will look for a Fortran source file
with the extension \fI.\|for\fP for VMS systems, \fI.\|f\fP for UNIX systems.
\}
More than one file name can be given to \fBftnchek\fP,
and it will process the
modules in all files as if they were in a single file.
.PP
.ie \nh \{
Wildcards are allowed in the specification of filenames on the command
line.
\}
.el \{
Wildcards are allowed in the specification of filenames on the command
line for the VMS and MS-DOS versions,
as also of course under UNIX and any other system that performs
wildcard expansion in the command processor.
\}
.PP
If no filename is given, \fBftnchek\fP will read input from the
standard input.
.if !\nb \{
.ie \nh \{
.in 0
2 Options
.PP
\fBftnchek\fP options fall into two categories: switches, which are either
true or false, and settings, which have a numeric or string value.  The
name of a switch or
numeric setting can be preceded by 'no' to turn it off: e.g. /nousage
would turn off the warnings about variable usage.  Only the first 3
characters of an option name (not counting the '/') need be provided.
Most options are positional: each option remains in
effect from the point it is
encountered until it is overridden by a later change.
\}
.el \{
.SH "OPTIONS"
This section provides a more detailed discussion of \fBftnchek\fP
command-line options.  Options and filenames may be interspersed on a
command line.  Most options are positional: each option remains in
effect from the point it is
encountered until it is overridden by a later change.  Thus for
example, the listing may be suppressed for some files and not for
others.  Exceptions are: the \fB\-wordsize\fP setting, which cannot be
changed once processing of input files has started;
the
\fB\-arguments\fP,
\fB\-array\fP,
\fB\-calltree\fP,
\fB\-common\fP,
\fB\-crossref\fP,
\fB\-extern\fP,
\fB\-reference\fP,
\fB\-resource\fP,
\fB\-sort\fP,
\fB\-vcg\fP,
and
\fB\-volatile\fP
options, where the action depends only on the value of
the option after the processing of input files is finished;
and the \fB\-include\fP setting, which is cumulative.
.PP
The option names in the following list are in alphabetical order.
\}

.ie \nh \{
.in 0
3 /arguments=num
.PP
\}
.el \{
.TP
.BI \-arguments= num
\}
Controls warnings about
mismatches between actual and dummy subprogram arguments.  (An actual
argument is an argument passed to the subprogram by the caller; a
dummy argument is an argument received by the subprogram.)
.IP
The meanings of the setting values are as follows:
.RS
.TP \w'1.'u+2n
0:
turn off all such warnings.
.TP \w'1.'u+2n
1:
warn only about different number of arguments.
.TP \w'1.'u+2n
2:
warn only about mismatch of data type of arguments and of
function itself.
.TP \w'1.'u+2n
3:
all warnings.
.RE
.IP
Default = turn-on = 3.
.IP
This setting does not apply to checking invocations
of intrinsic functions or statement functions.
.IP
See also: \fB\-array\fP, \fB\-library\fP, \fB\-usage\fP.

.ie \nh \{
.in 0
3 /array=num
.PP
\}
.el \{
.TP
.BI \-array= num
\}
Controls the degree of strictness in checking
agreement between actual and dummy subprogram arguments that are arrays.
The warnings controlled by this setting are for constructions that might
legitimately be used by a knowledgeable programmer, but that often
indicate programming errors.
.IP
The meanings of the setting values are as follows:
.RS
.TP \w'1.'u+2n
0:
only warn about cases that are seldom intentional (see note below).
.TP \w'1.'u+2n
1:
warn if the arguments differ in their number of dimensions,
or if the actual argument is an array element while the dummy argument
is a whole array.
.TP \w'1.'u+2n
2:
warn if both arguments are arrays, but they differ in number
of elements.
.TP \w'1.'u+2n
3:
give both types of warnings.
.RE
.IP
Default = turn-on = 3.
.IP
Note:
A warning is always given regardless of this setting if the actual
argument is an array while the dummy argument is a scalar variable, or
if the actual argument is a scalar variable or expression while the
dummy argument is an array.
No warning is ever given if the actual argument is an array
element while the dummy argument is a scalar variable.
Variable-dimensioned arrays and arrays dimensioned with 1 or asterisk match any
number of array elements.
There is no check of whether multi-dimensional arrays agree in the
size of each dimension separately.
.IP
See also: \fB\-arguments\fP, \fB\-library\fP, \fB\-usage\fP.

.ie \nh \{
.in 0
3 /calltree=num
.PP
\}
.el \{
.TP
.BI \-calltree= num
\}
Causes \fBftnchek\fP to print out the call structure of
the complete program.
The value of
.I num
is the sum of numbers selected from the following list:
.RS
.TP \w'1.'u+2n
0:
do not produce any call graph.
.TP \w'1.'u+2n
1:
produce the call graph in tree format.
.TP \w'1.'u+2n
2:
produce the call graph in who-calls-who format (same as
\fB\-reference\fP switch).
.TP \w'1.'u+2n
3:
produce the call graph in VCG format (same as \fB\-vcg\fP
switch).
.TP \w'1.'u+2n
4:
do not prune repeated subtrees (applicable only for format 1).
.TP \w'1.'u+2n
8:
do not sort children into alphabetical order.
.RE
.IP
Only one of the formats 1, 2, or 3 may be included in the sum.  If no
format is specified but one of the other options is given so that the
number is nonzero, call-tree format will be used.
.IP
Default = turn-on = 1.  See the discussion of the \fB\-reference\fP
and \fB\-vcg\fP flags for details about these formats.
.IP
For tree format, The tree is printed out
starting from the main program, which is listed on the first line at
the left margin.  Then on the following lines, each routine called by
the main program is listed, indented a few spaces, followed by the
subtree starting at that routine.
.IP
In the default mode,
if a routine is called by more than one other routine,
its call subtree is printed only the first time it is encountered
Later calls give only the routine name and the notice ``(see above)''.
To have the subtree printed for each occurrence of the routine,
include 4 (don't-prune) in \fInum\fP.
.IP
Note that the call tree will be incomplete if any of the input files
are project files containing more than one module
that were created in \fB\-library\fP mode.  See the
discussion of project files below.
.IP
Technical points: Each list of routines called by a given routine is
printed in alphabetical order.
If multiple main programs are found, the call tree of each is printed
separately.
If no main program is found, a report to that effect is printed out,
and the call trees of any top-level non-library routines are printed.
This flag only controls the printing of the call tree: \fBftnchek\fP
constructs the call tree in any case because it is used to determine
which library modules will be cross-checked.  See the discussion
of the \fB\-library\fP flag.
.IP
See also: \fB\-crossref\fP, \fB\-library\fP, \fB\-reference\fP,
\fB\-sort\fP, \fB\-symtab\fP, \fB\-vcg\fP.

.ie \nh \{
.in 0
3 /check
.PP
\}
.el \{
.TP
.BI \-check
\}
This switch is provided so that errors and warning messages can be
turned off when \fBftnchek\fP is used for purposes other than finding
bugs, such as making declarations or printing the call tree.  It is
positional, so after turning all checks off, selected checks can be
turned back on.  The effect of \fB\-nocheck\fP is to put all switches,
numeric settings, and settings controlling lists of warnings
to their turn-off values, as if they had all been
specified with the \-no prefix.  The only exceptions are
\fB\-quiet\fP, \fB\-source\fP, \fB\-wrap\fP
and \fB\-wordsize\fP, which are unaffected by this switch.  Default =
yes.
.IP
Parse errors (syntax errors due to unrecognized or malformed
statements) are not suppressed by this switch, since the results may
be incorrect if \fBftnchek\fP has not parsed the program correctly.
Note that \fB\-check\fP as an option has no effect: this flag can only
turn checking off, not turn it back on again.

.ie \nh \{
.in 0
3 /columns=num
.PP
\}
.el \{
.TP
.BI \-columns= num
\}
Set maximum statement length to \fInum\fP columns.
(Beyond this is ignored.)
This setting is provided to allow checking of programs which may
violate the Fortran standard limit of 72 columns for the length of a
statement.  According to
the standard, all characters past column 72 are ignored.
If this setting is used when the \fB\-f77=long\-line\fP option is in effect, a
warning will be given for any lines in which characters past column 72
are processed.
Turn-on = max = 132.  Default = 72.
.IP
This setting does not suppress warnings about the presence
of characters beyond column 72.
To process code with meaningful program text beyond column 72, use
this setting and be sure the \fB\-f77\fP \fBlong\-line\fP option is off.
To process code with sequence numbers in columns 73 to 80, leave the
the columns setting at the default value and use the
\fB\-pretty=no\-long\-line\fP flag.

.ie \nh \{
.in 0
3 /common=num
.PP
\}
.el \{
.TP
.BI \-common= num
\}
This setting varies the strictness of
checking of COMMON blocks.
.IP
The different levels are:
.RS
.TP \w'1.'u+2n
0:
no checking.
.TP \w'1.'u+2n
1:
in each declaration of a given COMMON block,
corresponding memory locations (words or bytes) must agree in data type.
.TP \w'1.'u+2n
2:
also warn if different declarations
of the same block are not equal in total length.
.TP \w'1.'u+2n
3:
corresponding variables in each declaration of a block must
agree in data type and (if arrays) in size and number of dimensions.
.RE
.IP
Default = turn-on = 3.
.IP
The Fortran 77 Standard requires each named common block, but not
blank common, to be
the same length in all modules of the program.
Level 3 provides an extra degree of checking to support
a frequent programming practice.
.IP
See also: \fB\-library\fP, \fB\-usage\fP, \fB\-volatile\fP.

.ie \nh \{
.in 0
3 /crossref
.PP
\}
.el \{
.TP
.B \-crossref
\}
Specifies that a cross-reference table be printed.
This table lists each
subprogram followed by a list of the routines that call it.  Also
prints a table listing each COMMON block followed by a list of the
routines that access it.  Default = no.
.IP
The cross-reference listing omits
library modules that are not in the call tree of the main program.
The list is alphabetized.
The routines listed as using a COMMON block are those in which some
variables in the block are accessed, not simply those routines that
declare the block.  (To find out what routines declare a COMMON block
but do not use it, see the \fB\-usage\fP flag.)
.IP
See also: \fB\-calltree\fP,
\fB\-reference\fP, \fB\-sort\fP, \fB\-symtab\fP, \fB\-vcg\fP.

.ie \nh \{
.in 0
3 /declare
.PP
\}
.el \{
.TP
.B \-declare
\}
If this flag is set, all identifiers whose datatype is
not declared in each module will be listed.  This flag is useful for
helping to find misspelled variable names, etc.  The same listing will
be given if the module contains an \fCIMPLICIT NONE\fR statement.
Default = no.
.IP
See also: \fB\-sixchar\fP, \fB\-usage\fP.

.ie \nh \{
.in 0
3 /division
.PP
\}
.el \{
.TP
.B \-division
\}
This switch is provided to help users spot potential
division by zero problems.  If this switch is selected, every division
except by a constant will be flagged.  (It is assumed that the user is
intelligent enough not to divide by a constant which is equal to zero!)
Default = no.
.IP
See also: \fB\-portability\fP, \fB\-truncation\fP.

.ie \nh \{
.in 0
3 /extern
.PP
\}
.el \{
.TP
.B \-extern
\}
Causes \fBftnchek\fP to report whether any subprograms
invoked by the program are never defined, or are multiply defined.
Ordinarily, if \fBftnchek\fP is being run on a complete program, each
subprogram other than the intrinsic functions should be defined once
and only once somewhere.  Turn off this switch if you just want to
check a subset of files which form part of a larger complete program,
or to check all at once a number of unrelated files which might each
contain an unnamed main program.  Subprogram arguments will still be
checked for correctness.  Default = yes.
.IP
The \fB\-extern\fP flag is now superseded by the Level 1 usage checking of
subprograms.  For the sake of compatibility with earlier versions of
ftnchek, the \fB\-extern\fP flag is retained, so that  \fB\-noextern\fP
is equivalent to a 0 or 2 in the hundreds place of the \fB\-usage\fP
setting.  However, to avoid anomalous behavior, you should not use
both \fB\-extern\fP and \fB\-usage\fP on the command line.  Probably
the \fB\-extern\fP switch will be retired eventually.
.IP
See also: \fB\-library\fP.

.ie \nh \{
.in 0
3 /f77=list
.PP
\}
.el \{
.TP
.BI \-f77= list
\}
Use this setting to catch language extensions which violate
the Fortran 77 Standard.  Such extensions may cause your program not
to be portable.  Examples include the use of underscores in variable
names; variable names longer than six characters; statement lines
longer than 72 characters; and nonstandard statements such as the
\fCDO\fR ... \fCENDDO\fR structure.  \fBftnchek\fP does not report on
the use of lowercase letters.
By default, all warnings are turned off.
.IP
This setting provides detailed control over the warnings about
supported extensions to the Fortran 77 Standard.  The \fIlist\fP
consists of keywords separated by commas or colons.
There are three special keywords: \fBall\fP to turn on all the
warnings about nonstandard extensions, \fBnone\fP to turn them all
off, and \fBhelp\fP to print the list of all the keywords with a brief
explanation of each.
If \fIlist\fP is omitted, \fB\-f77\fP is equivalent to
\fB\-f77=all\fP, and \fB\-nof77\fP is equivalent to
\fB\-f77=none\fP.
The warning keywords with their meanings are as follows.
.if !\nh \{
(Further details about the extensions themselves are given below in the
section on Extensions.)
\}
.RS
.TP \w'128:'u+2n
.B accept\-type:
\fCACCEPT\fP and \fCTYPE\fP I/O statements.
.TP
.B backslash:
Unix backslash escape in strings.  This warning will be given only if
the \fB\-source\fP setting value 4 (UNIX backslash) is specified to cause
the escape interpretation of backslash..
.TP
.B byte:
\fCBYTE\fP data type declaration.
.TP
.B common\-subprog\-name:
Common block and subprogram having the same name.
.TP
.B continuation:
More than 19 successive continuation lines.
.TP
.B cpp:
Unix C preprocessor directives in the source code.
.TP
.B d\-comment:
Debugging comments starting with \fCD\fP in the source code.
.TP
.B dec\-tab:
DEC Fortran style tab-formatted source code.  This warning will be
given only if the \fB\-source\fP setting value 1 is specified to cause
interpretation of tabs in this style.
.TP
.B do\-enddo:
\fCDO\fP loop extensions: terminal statement label omitted, \fCEND DO\fP,
and \fCWHILE\fP.
.TP
.B double\-complex:
Double precision complex datatype.
.TP
.B format\-dollarsign:
Dollar sign control code in \fCFORMAT\fP statements.
.TP
.B format\-edit\-descr:
Nonstandard edit descriptors in \fCFORMAT\fP statements.
.TP
.B function\-noparen:
Function definition without parentheses.
.TP
.B implicit\-none:
\fCIMPLICIT NONE\fP statement.
.TP
.B include:
\fCINCLUDE\fP statement.
.TP
.B inline\-comment:
Inline comments starting with an exclamation point.
.TP
.B internal\-list\-io:
List-directed I/O to or from an internal file.
.TP
.B intrinsic:
Nonstandard intrinsic functions.
.TP
.B long\-line:
Statements with meaningful code past 72 columns.  This warning is
given only if the \fB\-columns\fP setting has been used to increase
the statement field width.
.TP
.B long\-name:
Identifiers over 6 characters long.
.TP
.B mixed\-common:
Mixed character and noncharacter data in COMMON block.
.TP
.B mixed\-expr:
Nonstandard type combinations in expressions, for example \fCDOUBLE
PRECISION\fP with \fCCOMPLEX\fP, assigning hollerith to integer,
logical operations on integers.
.TP
.B name\-dollarsign:
Dollar sign used as a character in identifiers.
.TP
.B name\-underscore:
Underscore used as a character in identifiers.
.TP
.B namelist:
\fCNAMELIST\fP statement.
.TP
.B param\-intrinsic:
Intrinsic function or exponentiation by a real used to define the value
of a \fCPARAMETER\fP definition.
.TP
.B param\-noparen:
\fCPARAMETER\fP statement without parentheses.
.TP
.B pointer:
``Cray pointer'' syntax.
.TP
.B quad\-constant:
Quad precision real constants, e.g. of the form \fC1.23Q4\fP.
.TP
.B quotemark:
Strings delimited by quote marks rather than apostrophes.
.TP
.B statement\-order
Statements out of the sequence mandated by the Standard.  The allowed
sequence is illustrated in Table 1 in the section on Interpreting the
Output.
.TP
.B typeless\-constant:
Typeless constants, for example \fCZ'19AF\fP.
.TP
.B type\-size:
Type declarations specifying a size, for example \fCREAL*8\fP.
.TP
.B variable\-format:
Variable repeat specification or field size in FORMAT.  These
are of the form \fC<\fP \fIexpr\fP \fC>\fP.
.TP
.B vms\-io:
The following VMS Fortran keywords used in I/O statements:
.nf
\fC
NAME\fP (in \fCOPEN\fP; it is standard only in \fCINQUIRE\fP)\fC
BLOCKSIZE         EXTENDSIZE        READONLY
BUFFERCOUNT       INITIALSIZE       RECORDSIZE
CARRIAGECONTROL   MAXREC            RECORDTYPE
DEFAULTFILE       NOSPANBLOCK       SHARED
DISP              ORGANIZATION      TYPE
DISPOSE
\fP
.fi
.RE
.IP
See also: \fB\-portability\fP, \fB\-pretty\fP, \fB\-wordsize\fP.

.ie \nh \{
.in 0
3 /help
.PP
\}
.el \{
.TP
.B \-help
\}
Prints a list of all the command-line options with a
short description of each along with its default value.
This command is identical in function to
the \fB``?''\fP
argument, and is provided as a convenience for those systems in
which the question mark has special meaning to the command
interpreter.  Default = no.
.IP
The help listing also prints the version number and patch level of
\fBftnchek\fP and a copyright notice.
.IP
Note: the ``default'' values printed in square brackets in the help listing
are, strictly speaking, not the built-in defaults but the current
values after any environment options and any command-line
options preceding the \fB\-help\fP option have been processed.
.IP
See also: \fB\-version\fP, \fB\-f77=help\fP, \fB\-portability=help\fP,
\fB\-pretty=help\fP, \fB\-truncation=help\fP.

.ie \nh \{
.in 0
3 /include=path
.PP
\}
.el \{
.TP
.BI \-include= path
\}
Specifies a directory to be searched for files
specified by \fCINCLUDE\fR statements.  Unlike other command-line
options, this setting is cumulative; that is, if it is given more than
once on the command line, all the directories so specified are placed
on a list that will be searched in the same order as they are given.
The order in which \fBftnchek\fP searches for a file to be included is:
the current directory; the directory specified by
environment
variable \fCFTNCHEK_INCLUDE\fR
if any;
the directories specified by any \fB\-include\fP options;
the directory specified by environment variable \fCINCLUDE\fR;
and finally in
a standard systemwide directory
(\fC/usr/include\fR for UNIX, \fCSYS$LIBRARY\fR for VMS,
and \fC\\include\fR
for MSDOS).

.ie \nh \{
.in 0
3 /intrinsic=num
.PP
\}
.el \{
.TP
.BI \-intrinsic= num
\}
Controls treatment of nonstandard intrinsic functions.  The setting
consists of three digits.  The
ones digit selects the set of intrinsic functions to be supported.
Set 0 selects only Fortran 77 standard intrinsics plus those needed to
support the nonstandard extended precision data types.
These include intrinsics for the double complex data type:
.nf
\fC
    CDABS    CDSQRT   DREAL    ZLOG
    CDCOS    DCMPLX   IMAG     ZSIN
    CDEXP    DCONJG   ZABS     ZSQRT
    CDLOG    DIMAG    ZEXP     ZCOS
    CDSIN
\fP
.fi
and for the quad precision and quad complex types:
.nf
\fC
    CQABS    QARCOS   QEXT     QNINT   
    CQCOS    QARSIN   QEXTD    QPROD   
    CQEXP    QATAN    QFLOAT   QREAL   
    CQLOG    QATAN2   QIMAG    QSIGN   
    CQSIN    QCMPLX   QINT     QSIN    
    CQSQRT   QCONJG   QLOG     QSINH   
    DBLEQ    QCOS     QLOG10   QSQRT   
    IQINT    QCOSH    QMAX1    QTAN    
    IQNINT   QDIM     QMIN1    QTANH   
    QABS     QEXP     QMOD     SNGLQ   
\fP
.fi
Set 1 includes set 0 as well as the following commonly available
intrinsics  (all except \fCEXIT\fR and \fCLOC\fR are defined in
MIL-STD 1753):
.nf
\fC
    BTEST    IBCLR    IEOR     ISHFTC
    EXIT     IBITS    IOR      LOC
    IAND     IBSET    ISHFT    NOT
\fP
.fi
Set 2 includes set 1, plus these common Unix intrinsic functions:
.nf
\fC
    ABORT    GMTIME   LTIME    SRAND
    AND      IARGC    OR       SYSTEM
    GETARG   IRAND    RAND     TIME
    GETENV   LSHIFT   RSHIFT   XOR
\fP
.fi
Set 3 includes set 1, plus these common VMS functions:
.nf
\fC
    DATE     IDATE    SECNDS   TIME
    ERRSNS   RAN      SIZEOF
\fP
.fi
The tens digit of this setting controls the syntax of the \fCRAND\fP
intrinsic function.  Specify 0 to require invocation with no argument,
1 to require one argument, and 2 to allow either form.  The hundreds
digits controls the syntax of the \fCIARGC\fP function in the same
way.
.IP
Note that this setting does not control whether non-standard warnings
are issued about these functions.  It controls whether the
functions are assumed to be intrinsic or not, which determines how their
usage is checked.  When functions in any of these sets are
included, their invocations will be checked according to the rules
for the intrinsic functions; otherwise they will be checked as normal
(user-written) external functions.  The non-standard warnings
are controlled by the \fB\-f77=intrinsic\fP option.
.IP
Default setting = turn-on = 222 for the Unix version, 223 for the VMS version,
and 221 for all other versions of \fBftnchek\fP.  Turn-off = 0.

.ie \nh \{
.in 0
3 /library
.PP
\}
.el \{
.TP
.B \-library
\}
This switch is used when a number of subprograms are
contained in a file, but not all of them are used by the application.
Normally, \fBftnchek\fP warns you if any subprograms are defined but
never used.  This switch will suppress these warnings.  Default = no.
.IP
This switch also controls which subprogram calls and COMMON
block declarations are checked.  If a file
is read with the \fB\-library\fP flag in effect, the subprogram calls
and COMMON declarations contained in a routine in that file will
be checked only if that routine is in the main program's call tree.
On the other hand, if the \fB\-library\fP switch is
turned off, then \fBftnchek\fP checks the calls of every routine by
every other routine, regardless of whether those routines could ever
actually be invoked at run time, and likewise all COMMON block
declarations are compared for agreement.
.IP
The difference between this switch and the \fB\-usage\fP level 2
setting for subprograms is that the latter suppresses only the warning
about routines being declared but not used.  The \fB\-library\fP switch
goes further and excludes unused routines processed while it is in
effect from all cross-checking of arguments and COMMON block
declarations as well.
.IP
(If there is no main program anywhere in the set of files that
\fBftnchek\fP has read, so that there is no call tree, then
\fBftnchek\fP will look for any non-library routines that are not called
by any other routine, and use these as substitutes for the main
program in constructing the call tree and deciding what to check.
If no such top-level non-library routines are found, then
all inter-module calls and all COMMON declarations will be checked.)
.IP
See also: \fB\-arguments\fP, \fB\-calltree\fP, \fB\-common\fP,
\fB\-extern\fP, \fB\-usage\fP.

.ie \nh \{
.in 0
3 /list
.PP
\}
.el \{
.TP
.B \-list
\}
Specifies that a listing of the Fortran program is to be
printed out with line numbers.  If \fBftnchek\fP detects an error, the
error message follows the program line with a caret
( ^ )
specifying the location of the error.  If no source listing was
requested, \fBftnchek\fP will still print out any line containing an
error, to aid the user in determining where the error occurred.
Default = no.
.IP
See also: \fB\-symtab\fP, \fB\-quiet\fP.

.ie \nh \{
.in 0
3 /makedcls=num
.PP
\}
.el \{
.TP
.BI \-makedcls= num
\}
Prepare a neatly-formatted file of declarations of variables,
common blocks, and namelist lists, for possible
merging into the source code.  The declarations are stored in a file
of the same name as the source code, but with the extension changed to
.IR .dcl .
If no declarations are written to the file, it is deleted to reduce
clutter from empty files.
.IP
If input comes from standard input, instead of a named file, then
declarations are written to standard output.
.IP
Variables are declared in alphabetical order within each declaration
class and type, with integer variables first, because of their later
possible use in array dimensions.
.IP
\fCPARAMETER\fP statements are an exception to the alphabetical order
rule, because the Fortran 77 Standard requires that the expressions
defining parameter values refer only to constants and already-defined
parameter names.  This forces the original source file order of such
statements to be preserved in the declaration files.
.IP
Explicit declaration of
.I all
variables is considered good modern programming practice.  By using
compiler options to reject undeclared variables, misspelled variable
names (or names extending past column 72) can be caught at compile
time.  Explicit declarations also greatly facilitate changing
floating-point precision with filters such as
.BR dtoq (1L),
.BR dtos (1L),
.BR fd2s (1L),
.BR fs2d (1L),
.BR qtod (1L),
and
.BR stod (1L).
These programs are capable of changing types of explicit
floating-point type declarations, intrinsic functions, and constants,
but because they do not carry out rigorous lexical and grammatical
analysis of the Fortran source code, they cannot provide modified type
declarations for undeclared variables.
Default setting = 0, turn-on = 1.
.IP
The setting values are given by the
.I sum
of selected option values from the following list:
.RS
.TP \w'128:'u+2n
0:
Do not write a declaration file.
.TP
1:
Write a declaration file.
.TP
2:
Normally, all variables are included in the declaration file.  With
this option, include only
.I undeclared
variables.  This setting is useful if you want to check for undeclared
variables, since Fortran source files with all variables properly
declared will not result in a
.I .dcl
file.
With this option, common blocks and namelist lists will not be
included in the declaration file, since by their nature they cannot be
undeclared.
.TP
4:
The declarations are normally prettyprinted to line up neatly in
common columns, as in the declaration files output by the Extended
PFORT Verifier,
.BR pfort (1L).
This option value selects instead compact output, without column
alignment.
.TP
8:
Causes continuation lines to be used where permissible.
The default is to begin a new declaration on each line.  This option
is appropriate to use with the option for compact output.
.TP
16:
Output Fortran keywords in lowercase, instead of the default
uppercase.
.TP
32:
Output variables and constants in lowercase, instead of the default
uppercase.   Character string constants are not affected by this
option.
.TP
64:
Omit declarations of internal integer variables produced by the
SFTRAN3 preprocessor,
.BR xsf3 (1L),
as part of the translation of structured Fortran statements to
ordinary Fortran.  These variables have six-character names of the
form
.IR NPRddd ,
.IR NXdddd ,
.IR N2dddd ,
and
.IR N3dddd ,
where
.I d
is a decimal digit.  Because they are invisible in the SFTRAN3 source
code, and will change if the SFTRAN3 code is modified, such variables
should not be explicitly declared.  Instead, they should just assume
the default Fortran INTEGER data type based on their initial letter,
.IR N .
.TP
128:
Use an asterisk as the comment character; the default is otherwise 'C'.
.TP
256:
Use 'c' instead of 'C' or '*' as the comment character.
.TP
512:
Suppress dimensioning of arrays in the generated declarations.
This option is for use with code lacking type declarations, to allow
the declaration files to be inserted without change into the code.  Since
the code will have dimension statements already, dimensioning the
array variables in the type statements of the declaration file is redundant.
This option should be used only in conjunction with
option 2 = undeclared-only because otherwise any arrays that were
dimensioned in a type statement will lose their dimensioning.
.RE
.IP
If any non-zero value is specified, then declaration output is
selected, even if the value 1 was not included in the sum.
.IP
The declaration files contain distinctive comments that mark the start
and end of declarations for each program unit, to facilitate using
text editor macros for merging the declarations back into the source
code.
.IP
The \fBftnchek\fP distribution includes a program, \fBdcl2inc\fP,
which processes declaration files to produce files containing
declarations of all COMMON blocks, in a form suitable for use as
INCLUDE files.  See the \fBdcl2inc\fP man page for the details
of its use.

.ie \nh \{
.in 0
3 /novice
.PP
\}
.el \{
.TP
.B \-novice
\}
This flag is intended to provide more helpful
output for beginners.  It has two effects:
.RS
.TP \w'1.'u+2n
(a)
provides an extra message to the effect that a function
that is used but not defined anywhere might be an array which the user
forgot to declare in a \fCDIMENSION\fR statement (since the syntax of
an array reference is the same as that of a function reference).
.TP \w'1.'u+2n
(b)
modifies the form of the error messages and warnings.  If the
flag is turned off by \fB\-nonovice\fP, these messages are printed in a
style more resembling UNIX \fBlint\fP.
.RE
.IP
Default = yes.
.IP

.ie \nh \{
.in 0
3 /output=filename
.PP
\}
.el \{
.TP
.BI \-output= filename
\}
This setting is provided for convenience on
systems which do not allow easy redirection of output from programs.
When this setting is given, the output which normally appears on the
screen will be sent instead to the named file.  Note, however, that
operational errors of \fBftnchek\fP itself (e.g. out of space or cannot
open file) will still be sent to the screen.  The extension for the
filename is optional, and if no extension is given, the
extension \fI.\|lis\fP will be used.

.ie \nh \{
.in 0
3 /portability=list
.PP
\}
.el \{
.TP
.BI \-portability= list
\}
\fBftnchek\fP will give warnings for a variety of
non-portable usages.  Examples include the use of tabs except in comments
or inside strings, the use of Hollerith constants, and the
equivalencing of variables of different data types.  This option does
not produce warnings for supported extensions to the Fortran 77 Standard, which
may also cause portability problems.  To catch those, use
the \fB\-f77\fP setting.  
By default, all warnings are turned off.
.IP
This setting provides detailed control over the warnings about
possible portability problems.  The \fIlist\fP consists of keywords
separated by commas or colons.
There are three special keywords: \fBall\fP to turn on all the
warnings about nonportable usages, \fBnone\fP to turn them all
off, and \fBhelp\fP to print the list of all the keywords with a brief
explanation of each.
If \fIlist\fP is omitted, \fB\-portability\fP is equivalent to
\fB\-portability=all\fP, and \fB\-noportability\fP is equivalent to
\fB\-portability=none\fP.
The warning keywords with their meanings are as follows:
.RS
.TP \w'128:'u+2n
.B   backslash:
Backslash character in strings.  Since some compilers treat the
backslash as an escape character, its presence can cause problems even
though it is used in a standard-conforming way.
.TP
.B   common\-alignment:
COMMON block variables not in descending order of storage size.  Some
compilers require this ordering because of storage alignment requirements.
.TP
.B   hollerith:
Hollerith constants (other than within FORMAT
specifications).  The Hollerith data type is a feature of Fortran IV
that has been deleted in the Fortran 77 standard.  It is superseded
by the character data type.  Storing Hollerith data in variables of a
numeric or logical data type is nonportable due to differing word sizes.
.TP
.B   long\-string:
String constants, variables, or expressions over 255 chars long.
.TP
.B   mixed\-equivalence:
Variables of different data types equivalenced.
.TP
.B   mixed\-size:
Variables declared with default precision used with variables given
explicit precision, in expressions, assignments, or as arguments.  For
example, if a variable declared as \fCREAL*8\fR is treated as
equivalent to \fCDOUBLE PRECISION\fR.
.TP
.B   real\-do:
Non-integer DO loop index and bounds.  These can cause a program's
results to depend on the hardware characteristics of the particular
computer used.
.TP
.B   tab:
Tabs in source code.  Tabs are interpreted differently by different
compilers.  This warning will be given only once, at the end of the
file.
.RE
.IP
See also: \fB\-f77\fP, \fB\-hollerith\fP,
\fB\-pretty\fP, \fB\-wordsize\fP.

.ie \nh \{
.in 0
3 /pretty=list
.PP
\}
.el \{
.TP
.BI \-pretty= list
\}
Controls certain messages related to the appearance of
the source code.  These warn about things that might
make a program less readable or be deceptive to the reader.    
By default, all warnings are turned on.
.IP
This setting provides detailed control over the warnings about
appearance.  The \fIlist\fP consists of keywords
separated by commas or colons.
Since all warnings are on by default, include a keyword prefixed by
\fBno\-\fP to turn off a particular warning.
There are three special keywords: \fBall\fP to turn on all the
warnings about misleading appearances, \fBnone\fP to turn them all
off, and \fBhelp\fP to print the list of all the keywords with a brief
explanation of each.
If \fIlist\fP is omitted, \fB\-pretty\fP is equivalent to
\fB\-pretty=all\fP, and \fB\-nopretty\fP is equivalent to
\fB\-pretty=none\fP.
The warning keywords with their meanings are as follows:
.RS
.TP \w'128:'u+2n
.B  embedded\-space:
Space embedded in variable names.
.TP
.B  continuation:
Continuation mark following a comment line.
.TP
.B  long\-line:
Lines (except comments) over 72 columns in width (beyond 72 is
normally ignored by compiler).
.TP
.B  missing\-space:
Lack of space between variable and a preceding keyword.
.TP
.B  multiple\-common:
COMMON block declared in multiple statements.  No warning is given if the
statements are consecutive except for comment lines.
.TP
.B  multiple\-namelist:
NAMELIST declared in multiple statements.  No warning is given if the
statements are consecutive except for comment lines.
.TP
.B  parentheses:
Parentheses around a variable by itself.  As a subprogram argument,
this makes the argument an expression, not modifiable by the subprogram.
.RE
.IP
See also: \fB\-f77\fP, \fB\-portability\fP.

.ie \nh \{
.in 0
3 /project
.PP
\}
.el \{
.TP
.B \-project
\}
\fBftnchek\fP will create a project file from each
source file that is input while this flag is in effect.  The project
file will be given the same name as the input file, but with the
extension \fI.\|f\fP or \fI.\|for\fP replaced by \fI.\|prj\fP.
(If input is from standard input, the project file is named
.IR ftnchek.\|prj .)
Default = no.
.IP
A project file contains a summary of information from the source file,
for use in checking agreement
among \fCFUNCTION\fR, \fCSUBROUTINE\fR, and \fCCOMMON\fR
usages in other files.  It
allows incremental checking, which saves time whenever you have a
large set of files containing shared subroutines, most of which seldom
change.  You can run \fBftnchek\fP once on each file with the
\fB\-project\fP flag set, creating the project files.  Usually you
would also set the \fB\-library\fP and \fB\-noextern\fP flags at this
time, to suppress messages relating to consistency with other files.
Only error messages pertaining to each file by itself will be printed
at this time.  Thereafter, run \fBftnchek\fP without these flags on all
the project files together, to check consistency among the different
files.  All messages internal to the individual files will now be
omitted.  Only when a file is altered will a new project file need to
be made for it.
.IP
Naturally, when the \fB\-project\fP flag is set, \fBftnchek\fP will not
read project files as input.
.IP
Project files contain only information needed for checking
agreement between files.  This means that a project file is of no use if all
modules of the complete program are contained in a single file.
.IP
A more detailed discussion is given in the
section on Using Project Files.

.ie \nh \{
.in 0
3 /pure
.PP
\}
.el \{
.TP
.B \-pure
\}
Assume functions are ``pure'', i.e., they will not have
side effects by modifying their arguments or variables in a COMMON
block.  When this flag is in effect, \fBftnchek\fP will base its
determination of set and used status of the actual arguments on the
assumption that arguments passed to a function are not altered.  It
will also issue a warning if a function is found to modify any of its
arguments or any COMMON variables.
Default = yes.
.IP
When this flag is turned off, actual arguments passed to functions
will be handled the same way as actual arguments passed to
subroutines.  This means that \fBftnchek\fP will assume that arguments
may be modified by the functions.  No warnings will be given if a
function is found to have side effects.  Because stricter checking is
possible if functions are assumed to be pure, you should turn this flag
off only if your program actually uses functions with side effects.

.ie \nh \{
.in 0
3 /quiet
.PP
\}
.el \{
.TP
.B \-quiet
\}
This option reduces
the amount of output relating to normal operation, so that error
messages are more apparent.  This option is provided for the
convenience of users who are checking large suites of files.  The
eliminated output includes the names of project files, and the message
reporting that no syntax errors were found.  (Some of this output is
turned back on by the \fB\-list\fP and \fB\-symtab\fP options.)  Default
= no.

.ie \nh \{
.in 0
3 /reference
.PP
\}
.el \{
.TP
.B \-reference
\}
Specifies that a who-calls-who table be printed.
This table lists each subprogram followed by a list of the
routines it calls.  This switch is equivalent to \fB\-calltree=2\fP.
Default = no.
.IP
The reference list omits routines
called by unused library modules.  Thus it contains the same
information as for the call-tree format, namely the hierarchy of
subprogram calls, but printed in a different way.  This prints out
a breadth-first traversal of the call tree whereas \fB\-calltree\fP prints
out a depth-first traversal.  Only one format is printed.
If both \fB\-calltree\fP and
\fB\-reference\fP flags are given, the former will take precedence.
.IP
See also: \fB\-calltree\fP, \fB\-crossref\fP, \fB\-library\fP,
\fB\-sort\fP, \fB\-symtab\fP, \fB\-vcg\fP.

.ie \nh \{
.in 0
3 /resources
.PP
\}
.el \{
.TP
.B \-resources
\}
Prints the amount of resources used by \fBftnchek\fP in processing the
program.  This listing may be useful in analyzing the size and
complexity of a program.  It can also help in choosing larger
sizes for \fBftnchek\fP's internal tables if they are too small to
analyze a particular program.
Default = no.
.IP
In this listing, the term ``chunk size'' is the size of the blocks of
memory allocated to store the item in question, in units of the size
of one item, not necessarily in bytes.  When the initially allocated
space is filled up, more memory is allocated in chunks of this size.
The following is an explanation of the items printed:
.RS
.TP \w'1.'u+2n
.I "Source lines processed:"
Total number of lines of code, with separate totals for statement
lines and comment lines.  Comment lines include lines with 'C' or '*'
in column 1 as well as blank lines and lines containing only an inline
comment.  Statement lines are all other lines, including lines that
have an inline comment following some code.  Continuation lines are
counted as separate lines.  Lines in include files are counted each
time the file is included.
.TP \w'1.'u+2n
.I "Total executable statements:"
Number of statements in the program, other than specification, data,
statement-function, FORMAT, ENTRY, and END statements.
.TP \w'1.'u+2n
.I "Total number of modules:"
A module is any external subprogram, including the main program,
subroutines, functions, and block data units.  This count is of
modules defined within the source, not modules referenced.  Statement
functions are not included.  A subprogram with multiple entry points
is only counted once.
.TP \w'1.'u+2n
.I "Max identifier name chars:"
Number of characters used for storing identifier names.  An identifier
is a variable, subprogram, or common block name.  Local names are
those of local variables in a subprogram, whereas global names refer
to subprogram and common block names, as well as dummy argument names
and common variable names.  Actual argument text (up to 15 characters
for each argument) is also included here.  The space used for local
names is recovered at the end of each module, whereas the global space
grows until the whole program is analyzed.  Unfortunately, this figure
may include some common block names and arguments stored more than
once, although a heuristic is used that will avoid duplicates in many
cases.
.TP \w'1.'u+2n
.I "Max token text chars:"
A token is the smallest syntactic unit of the FORTRAN language above
the level of individual characters. For instance a token can be a
variable name, a numerical constant, a quoted text string, or a
punctuation character.  Token text is stored while a module is being
processed.  For technical reasons, single-character tokens are not
included in this total.  Items that are not represented in the
symbol table may be duplicated.  The space for token text is recovered
at the end of each module, so this figure represents the maximum for
any one module.
.TP \w'1.'u+2n
.I "Max local symbols:"
This is the largest number of entries in the local symbol table for
any module.  Local symbol table entries include all variables and
parameters, common block names, statement functions, external
subprograms and intrinsic functions referenced by the module.  Literal
constants are not stored in the local symbol table.
.TP \w'1.'u+2n
.I "Max global symbols:"
This is the number of entries in the global symbol table at the end of
processing.  Global symbol table entries include external subprogram
and common block names.  Intrinsic functions and statement functions
are not included.
.TP \w'1.'u+2n
.I "Max number of tokenlists:"
A token list is a sequence of tokens representing the actual or dummy
argument list of a subprogram, or the list of variables in a common
block or namelist.  Therefore this number represents the largest sum
of COMMON, CALL, NAMELIST and ENTRY statements and function invocations for any
one module.  The space is recovered at the end of each module.
.TP \w'1.'u+2n
.I "Max token list/tree space:"
This is the largest number of tokens in all the token lists and token
trees of any one module.  A token tree is formed when analyzing an
expression: each operand is a leaf of the tree, and the operators are
the nodes.  Therefore this number is a measure of the maximum
complexity of an individual module.  For instance a module with many
long arithmetic expressions will have a high number.  Note that unlike
token text described above, the number of tokens is independent of the
length of the variable names or literal constants in the expressions.
.TP \w'1.'u+2n
.I "Number of subprogram invocations:"
This is the sum over all modules of the number of
CALL statements and function invocations (except intrinsic functions
and statement functions).
.TP \w'1.'u+2n
.I "Number of common block decls:"
This is the sum over all modules of the number of common block
declarations.  That is, each declaration of a block in a different
module is counted separately.  (The standard allows multiple
declarations of a block within the same module; these are counted as
only one declaration since they are equivalent to a single long
declaration.)
.TP \w'1.'u+2n
.I "Number of array dim & param ptrs:"
This is the sum over all modules of the number of array dimension and
parameter definition text strings saved for use by the
\fB\-makedcls\fP option.  The length of the text strings is not
counted.  Each dimension of a multidimensional array is counted separately.
.RE
.IP
These numbers are obviously not the same when project files are used
in place of the original source code.  Even the numbers for global
entities may be different, since some redundant information is
eliminated in project files.

.ie \nh \{
.in 0
3 /sixchar
.PP
\}
.el \{
.TP
.B \-sixchar
\}
One of the goals of the \fBftnchek\fP program is to
help users to write portable Fortran programs.  One potential source
of nonportability is the use of variable names that are longer than
six characters.  Some compilers just ignore the extra characters.
This behavior could potentially lead to two different variables being
considered as the same.  For instance, variables named \fCAVERAGECOST\fR
and \fCAVERAGEPRICE\fR are the same in the first six characters.  If
you wish to catch such possible conflicts, use this flag.  Default =
no.
.IP
Use the \fB\-f77=long\-names\fP if you want to
list \fIall\fP
variables longer than six characters, not just those pairs that are the same in
the first six.
.IP
See also: \fB\-f77\fP, \fB\-portability\fP.

.ie \nh \{
.in 0
3 /sort
.PP
\}
.el \{
.TP
.B \-sort
\}
Specifies that a sorted list of all modules used in the
program be printed.  This list is in ``prerequisite'' order, i.e. each
module is printed only after all the modules from which it is called
have been printed.  This is also called a ``topological sort'' of the
call tree.  Each module is listed only once.  Routines that are not in
the call tree of the main program are omitted.  If there are any
cycles in the call graph (illegal in standard Fortran) they
will be detected and diagnosed.  Default = no.
.IP
See also: \fB\-calltree\fP,
\fB\-crossref\fP, \fB\-reference\fP, \fB\-symtab\fP, \fB\-vcg\fP.

.ie \nh \{
.in 0
3 /source=num
.PP
\}
.el \{
.TP
.BI \-source= num
\}
This setting controls certain options about the form of the Fortran
source code.  The setting value is the \fIsum\fP of numbers from the
following list:
.RS
.TP \w'128:'u+2n
1:
Accept DEC-style tab-formatted source.  A line beginning with an
initial tab will be treated as a new statement line unless the
character after the tab is a nonzero digit, in which case it is
treated as a continuation line.  The next column after the
tab or continuation mark is taken as column 7.  A warning will be
given in the case where the line is a continuation, if
\fB\-f77=dec\-tab\fP is in effect.
.TP
2:
Accept VMS-style \fCINCLUDE\fP statements.  These follow the normal
syntax, but with the following additional features: (1) the file
extension, if not given, defaults to the same as a normal source file
extension; and (2) the option \fC/LIST\fP or \fC/NOLIST\fP can be
appended to the include-file name, to control listing of its contents.
.TP
4:
Handle UNIX-style backslash escapes in character strings.
The escape sequence following the backslash will be evaluated
according to the ANSI standard for strings in C: up to three digits signify
an octal value, an x signifies the start of a hexadecimal constant,
any of the letters a b f n r t signify special control codes, and any
other character (including newline) signifies the character itself.
When this source code option is in effect,
a warning will be given if the \fB\-f77=backslash\fP
setting is specified.
.IP
The default behavior is to treat the backslash
like any other normal character, but a warning about
portability will be generated if the \fB\-portability\fP flag is set.
Because of the fact that some compilers treat the backslash in a
nonstandard way, it is possible for standard-conforming programs to be
non-portable if they use the backslash character in strings.
.IP
Since \fBftnchek\fP does not do much with the interpreted string, it
is seldom necessary to use this option.  It is needed in order to
avoid spurious warnings only if (a) the program being checked uses
backslash to embed an apostrophe or quote mark in a string
instead of using the standard mechanism of doubling the delimiter; (b)
the backslash is used to escape the end-of-line in order to continue
a string across multiple source lines; or (c) a \fCPARAMETER\fP
definition uses an intrinsic string function such as \fCLEN\fP with
such a string as argument, and that value is later used to define
array dimensions, etc.
.RE
.IP
Default setting = 0, turn-on = 7.

.ie \nh \{
.in 0
3 /symtab
.PP
\}
.el \{
.TP
.B \-symtab
\}
A symbol table will be printed out for each module,
listing all identifiers mentioned in the module.  This table gives the
name of each variable, its datatype, and the number of dimensions for
arrays.  An asterisk (*) indicates that the variable has been
implicitly typed, rather than being named in an explicit type
declaration statement.  The table also lists all subprograms invoked
by the module, all COMMON blocks declared, etc.  Default = no.
.IP
See also: \fB\-calltree\fP, \fB\-crossref\fP, \fB\-list\fP,
\fB\-reference\fP, \fB\-sort\fP, \fB\-vcg\fP.

.ie \nh \{
.in 0
3 /truncation=list
.PP
\}
.el \{
.TP
.BI \-truncation= list
\}
Warn about possible truncation (or roundoff) errors.  Most of these
are related to integer arithmetic.  By default, all warnings are
turned on.
.IP
This setting provides detailed control over the warnings about
possible truncation errors.  The \fIlist\fP consists of keywords
separated by commas or colons.
Since all warnings are on by default, include a keyword prefixed by
\fBno\-\fP to turn off a particular warning.
There are three special keywords: \fBall\fP to turn on all the
warnings about truncation, \fBnone\fP to turn them all
off, and \fBhelp\fP to print the list of all the keywords with a brief
explanation of each.
If \fIlist\fP is omitted, \fB\-truncation\fP is equivalent to
\fB\-truncation=all\fP, and \fB\-notruncation\fP is equivalent to
\fB\-truncation=none\fP.
The warning keywords with their meanings are as follows:
.RS
.TP \w'128:'u+2n
.B  int\-div\-exponent:
use of the result of integer division as an exponent.
This suggests that a real quotient is intended.
An example would be writing \fCX**(1/3)\fP to evaluate the cube root
of \fCX\fP. The correct expression is \fCX**(1./3.)\fP.
.TP
.B  int\-div\-real:
Conversion of an expression involving an integer division to real.
This suggests that a real quotient is intended.
.TP
.B  int\-div\-zero:
division in an integer constant expression that
yields a result of zero.
.TP
.B  int\-neg\-power:
exponentiation of an integer by a negative
integer (which yields zero unless the base integer is 1 in magnitude).
This suggests that a real base is intended.
.TP
.B  promotion:
automatic conversion of a lower precision quantity to one of higher
precision.  The loss of accuracy for real variables in this process is
comparable to the corresponding demotion.  No warning is given for
promotion of integer quantities to real since this is ordinarily
exact.
.TP
.B  real\-do\-index:
use of a non-integer DO index in a
loop with integer bounds.
An integer DO index with real bounds is always
warned about regardless of this setting.
.TP
.B  real\-subscript:
use of a non-integer array subscript.
.TP
.B  significant\-figures:
overspecifying a single precision constant.  This may indicate that a
double precision constant was intended.
.TP
.B  size\-demotion:
automatic conversion of a higher precision quantity to one of lower
precision of the same type.  This warning only occurs when an explicit
size is used in declaring the type of one or both operands in an
assignment.  For example, a warning wil be issued where a \fCREAL*8\fP
variable is assigned to a \fCREAL\fP variable, if the default wordsize
of 4 is in effect.
.B  type\-demotion:
automatic conversion of a higher precision quantity to one of lower
precision of different type.  This warning includes conversion of real
quantities to integer, double precision to single precision real, and
assignment of a longer character string to a shorter one.
.RE
.IP
The warnings about promotion and demotion also apply to complex
constants, considering the precision to be that of the real or
imaginary part.
Warnings about promotions and demotions are given only when
the conversion is done automatically, e.g. in expressions of mixed
precision or in an assignment statement.  If intrinsic
functions such as \fCINT\fR are used to perform the conversion, no warning
is given.
.IP
See also: \fB\-portability\fP, \fB\-wordsize\fP.

.ie \nh \{
.in 0
3 /usage=num
.PP
\}
.el \{
.TP
.BI \-usage= num
\}
Warn about unused or possible uninitialized variables,
unused common blocks, and unused or undefined subprograms.
.IP
This setting is composed of three digits.  The first digit (hundreds
place) controls warnings about subprograms (functions and
subroutines), the second digit (tens place) warnings about common
blocks and common variables,, and the third digit (ones place)
warnings about local variables.  Each digit controls warnings
according to the following scale:
.RS
.TP \w'1.'u+2n
0:
no warnings.
.TP \w'1.'u+2n
1:
warn about undefined items: subprograms that are used but never
defined, common block variables that are used but never set, or
local variables that are (or may be) used before they are set.
.TP \w'1.'u+2n
2:
warn about unused items: subprograms that are defined but never used
(unless taken in library mode), common blocks and common variables
that are unused, or local variables that are declared or set but never used.
.TP \w'1.'u+2n
3:
give both types of warnings.
.RE
.IP
Default = turn-on = 333.
.IP
Sometimes \fBftnchek\fP makes a mistake in the warnings about local
variable usage.  Usually it errs on the side of giving a warning where no
problem exists, but in rare cases it may fail to warn where the
problem does exist.  See the section on Bugs for examples.  If
variables are equivalenced, the rule used by \fBftnchek\fP is that a
reference to any variable implies the same reference to all variables
it is equivalenced to.  For arrays, the rule is that a reference to
any array element is treated as a reference to all elements of the array.
.IP
When checking
for used-before-set errors involving COMMON variables, \fBftnchek\fP does
not do a thorough enough analysis of the calling sequence to know
which routines are called before others.  So warnings about this type
of error will only be given for cases in which a variable is used in
some routine but not set in any other routine.   Checking of
individual COMMON variables is done only if the \fB\-common\fP
setting is 3 (variable by variable agreement).
.IP
The Level 1 value for subprogram usage checking controls warnings about
routines that are
invoked by the program but never defined, or are multiply defined.
Ordinarily, if \fBftnchek\fP is being run on a complete program, each
subprogram other than the intrinsic functions should be defined once
and only once somewhere.  Set this digit to 0 or 2 if you just want to
check a subset of files which form part of a larger complete program,
or to check all at once a number of unrelated files which might each
contain an unnamed main program.  Subprogram arguments will still be
checked for correctness.
.IP
See also: \fB\-common\fP, \fB\-declare\fP, \fB\-extern\fP,
\fB\-library\fP, \fB\-volatile\fP.

.ie \nh \{
.in 0
3 /vcg
.PP
\}
.el \{
.TP
.B \-vcg
\}
Produce the call graph in the form of a VCG graph description.  This
description is written to a separate file, with the same stem as the
file containing the main program, and suffix
.IR .vcg .
This file is able to be given directly to
.BR xvcg (1L)
to visualize the call graph.
(If input is from the standard input, then the graph description is
sent to standard output.)
This switch is equivalent to \fB\-calltree=3\fP.
Default = no.
.IP
The VCG description as created is more complex than it need be. VCG allows
graphs and nested subgraphs: each subroutine is created as a
subgraph nested inside its calling routines.  This allows you to
interactively display subgraphs or summarise them.
.IP
The
.B \-vcg
option for
.B ftnchek
was written by Dr. Philip Rubini (p.rubini@cranfield.ac.uk).
.IP
\fBxvcg\fP is a graph visualisation tool which runs under the X windows system.
It is freely available from ftp.cs.uni\-sb.de. It was written by G. Sander
of the University of Saarland, Germany.

.ie \nh \{
.in 0
3 /version
.PP
\}
.el \{
.TP
.B \-version
\}
This option causes \fBftnchek\fP to print a line giving the version
number, release date, and patch level of the program.
If no files are given, it then exits.  If files are given, the
effect of this option is to include the patch level (normally omitted)
in the version information printed at the start of processing.
Default = no.
.IP
See also: \fB\-help\fP.

.ie \nh \{
.in 0
3 /volatile
.PP
\}
.el \{
.TP
.B \-volatile
\}
Assume that COMMON blocks are volatile.
Default = no.
.IP
Many Fortran programmers assume that variables, whether
local or in COMMON, are static, i.e. that
once assigned a value, they retain that value permanently until
assigned a different value by the program.  However, in fact the
Fortran 77 Standard does not require this to be the case.
Local variables may
become undefined between activations of a module in which they are
declared.  Similarly, COMMON blocks may become undefined if no module
in which they are declared is active.  (The technical term for
entities with this behavior is ``automatic'',
but \fBftnchek\fP uses the word ``volatile'' since it
is clearer to the nonspecialist.)  Only COMMON blocks declared
in a SAVE statement, or
declared in the main program or in a block data subprogram remain
defined as long as the program is running.  Variables and COMMON
blocks that can become undefined at some point are called volatile.
.IP
If the \fB\-volatile\fP flag is turned on,
\fBftnchek\fP will warn you if it finds
a volatile COMMON block.  If, at the same time, the \fB\-usage\fP setting
is 1 or 3 (check used before set), \fBftnchek\fP will try to check whether
such a block can lose its defined status between activations of the
modules where it is declared.  \fBftnchek\fP does not do a very good job of
this: the rule used is to see whether the block is declared in two
separated subtrees of the call tree.  For instance, this would be the
case if two modules, both called from the main program, shared a
volatile COMMON block.  A block can also become undefined between two
successive calls of the same subprogram, but \fBftnchek\fP is not smart
enough to tell whether a subprogram can be called more than once, so
this case is not checked for.
.IP
The \fB\-volatile\fP flag does not affect the way \fBftnchek\fP
checks the usage of local variables.
.IP
See also: \fB\-common\fP, \fB\-usage\fP.

.ie \nh \{
.in 0
3 /wordsize=num
.PP
\}
.el \{
.TP
.BI \-wordsize= num
\}
Specifies the default word size to be \fInum\fP bytes.  This is the size of
logical and single-precision numeric variables that are not given
explicit precisions.  (Explicit precisions
for non-character variables are an extension to the Fortran 77
Standard, and are given by type declarations such as \fCREAL*8 X\fR.)
Double-precision and complex variables will be twice
this value, and double complex variables four times.
Quad-precision constants and intrinsic function results will be four
times this value.  Note that variables declared as \fCREAL*16\fR will
be regarded as quad precision only if the word size is 4 bytes.
Default = turn-on = 4 bytes.
.IP
The word size value does not matter for checking
standard-conforming programs that do not declare explicit precisions for
non-character variables or store Hollerith data in variables.  This
setting also does not affect the default size of character variables,
which is always 1 byte.  Hollerith constants also are assumed to
occupy 1 byte per character.
.IP
The word size is used to determine whether truncation occurs in
assignment statements, and to catch precision mismatches in subprogram
argument lists and common block lists.  The exact warnings that are
issued will depend on the status of other flags.  Under both the
\fB\-portability=mixed\-size\fP and the \fB\-nowordsize\fP flag, any mixing of
explicit with default precision objects (character
expressions not included) is warned about.  This applies to arithmetic
expressions containing both types of objects, and to
subprogram arguments and COMMON variables.
Under control of the \fB\-truncation=demotion\fP and
\fBpromotion\fP options, a warning 
is given for assignment of an expression to a shorter variable of the
same type, or for promotion of a lower precision value to higher
precision in an arithmetic expression or an assignment statement.
.IP
Giving a word size of 0, or equivalently, using \fB\-nowordsize\fP means that
no default value will be assumed.
This is equivalent to specifying
\fB\-portability=mixed\-size\fP.
Use it to find cases of mixing default and explicit
precision, for example to flag places where \fCREAL*8\fR is treated
as equivalent to \fCDOUBLE PRECISION\fR.
.IP
See also: \fB\-portability\fP, \fB\-truncation\fP.

.ie \nh \{
.in 0
3 /wrap=col
.PP
\}
.el \{
.TP
.BI \-wrap= col
\}
Controls the wrapping of error messages.  Long error
messages that would run past the specified column will be broken up into
separate lines between the words of the message for better
readability.  If turned off with \fB\-nowrap\fP, each separate error
message will be printed on one line, leaving it up to the display to
wrap the message or truncate it.  Default = turn-on = 79.

.ie \nh \{
.in 0
2 Changing_the_defaults
.PP
\}
.el \{
.SH "CHANGING THE DEFAULTS"
\}
\fBftnchek\fP includes two mechanisms for changing the
default values of all options:
by defining environment variables
or by creating a preferences file.
When \fBftnchek\fP starts up,
it looks in its environment for any variables whose names are composed by
prefixing the string
\fCFTNCHEK_\fR
onto the uppercased version of the option
name.  If such a
variable is found, its value is used to specify the default for the
corresponding switch or setting.  In the case of settings (for example,
the \fB\-common\fP strictness setting)
the value of the environment variable is read as the
default setting value.  In the case of switches, the default switch will
be taken as true or yes unless the environment variable has the value
\fC0\fR or \fCNO\fR.
.PP
Note that the environment variable name must be constructed with the
full-length option name, which must be in uppercase.  For example, to
make
\fBftnchek\fP print a source listing by default, set the environment
variable
\fCFTNCHEK_LIST\fR
to \fC1\fR or \fCYES\fR or anything other than \fC0\fR or \fCNO\fR.
The names
\fCFTNCHEK_LIS\fR
(not the full option name) or
\fCftnchek_list\fR
(lower case) would not be recognized.
.ie \nh \{
The way to set the environment variables on the VMS system is by
using the DEFINE command.  For example, to set the default /list
switch to YES, give the command
.sp 1
.ti 5
     $ DEFINE FTNCHEK_LIST 1
\}
.el \{
.PP
Here are some examples of how to set environment variables on various
systems.  For simplicity, all the examples set the default \fB\-list\fP
switch to \fCYES\fR.
.PP
.\" groff gives bad alignment on case 1 and I haven't found a workaround
.fc > @
.if n .ta 30 +30
.if t .ta 2i +3i
>1. UNIX, Bourne shell:  >\fC$ FTNCHEK_LIST=YES\fP
.\" groff gives bad alignment here and I haven't found a workaround
.br
>                        >\fC$ export FTNCHEK_LIST\fP

>2. UNIX, C shell:       >\fC% setenv FTNCHEK_LIST YES\fP

>3. VAX/VMS:             >\fC$ DEFINE FTNCHEK_LIST YES\fP

>4. MSDOS:               >\fC$ SET FTNCHEK_LIST=YES\fP
.fc
\}
.PP
After processing any environment variables, ftnchek looks for a
preferences file containing options and settings.
It will search in the following order, using only the
first file found: (1) \fI.\|ftnchekrc\fP in the current directory, (2)
\fIftnchek.\|ini\fP in the current directory, (3) \fI.\|ftnchekrc\fP in
the user's home directory, (4) \fIftnchek.\|ini\fP in the home
directory.  If such a file is found, the options defined in it are
used as defaults in place of the built-in defaults and overriding any
defaults set in the environment..
.PP
Each option or setting in the preferences file must be on a separate
line.  They are given in the same form as on the command line, except
without the initial
.ie \nh slash.
.el dash.
The preferences file can contain blank lines and comments.  Comments
are introduced at any point in a line by a space character (blank or
tab) or the '#' character, and are terminated by the end of the line.
.PP
Command-line options override the defaults set in the environment
or in the preferences file, in  the same way as they
override the built-in defaults.

.ie \nh \{
.in 0
2 Project_files
.PP
\}
.el \{
.SH "USING PROJECT FILES"
\}
This section contains detailed information on how to use project files
most effectively, and how to avoid some pitfalls.
.PP
Ordinarily, project files should be created with the \fB\-library\fP
flag in effect.  In this mode,
the information saved in the project file consists of all subprogram
declarations, all subprogram invocations not resolved by declarations in the
same file, and one instance of each COMMON
block declaration.  This is the minimum amount of information needed
to check agreement between files.
.PP
If the file contains more than one routine, there are some
possible problems that can arise from creating the project file in
library mode, because the calling
hierarchy among routines defined within the file is lost.  Also,
if the routines in the file make use of COMMON
blocks that are shared with routines in other files, there will not be
enough information saved for the correct checking of set and used
status of COMMON blocks and COMMON variables according to the
\fB\-usage\fP setting.  Therefore if
you plan to use project files when the \fB\-usage\fP
setting is nonzero (which is the default situation), and if
multiple routines in one
project file share COMMON blocks with routines in other files,
the project files
should be created with the \fB\-library\fP flag turned off.
In this mode, \fBftnchek\fP saves, besides
the information listed above, one invocation of each subprogram by
any other subprogram in the same file, and all COMMON block
declarations.  This means that the project file will be larger than
necessary, and that when it is read in, \fBftnchek\fP may repeat some
inter-module checks that it already did when the project file was
created.  If each project file contains only one
module, there is no loss of information in creating the project
files in library mode.
.PP
Because of the possible loss of information entailed by creating a project file
with the \fB\-library\fP flag in effect, whenever that project file is read
in later, it will be treated as a library file regardless of the
current setting of the \fB\-library\fP flag.  On the other hand, a project
file created with library mode turned off can be read in later in either
mode.
.if !\nh \{
.PP
Here is an example of how to use the UNIX \fBmake\fP utility to
automatically create a new project file each time the corresponding
source file is altered, and to check the set of files for consistency.
The example assumes that a macro \fCOBJS\fR has been defined which
lists all the names of object files to be linked together to form the
complete executable program.
.nf
\fC
    # tell make what a project file suffix is
    .SUFFIXES: .prj

    # tell make how to create a .prj file from a .f file
    .f.prj:
            ftnchek -project -noextern -library $<

    # set up macro PRJS containing project filenames
    PRJS= $(OBJS:.o=.prj)

    # "make check" will check everything that has been changed.
    check: $(PRJS)
            ftnchek $(PRJS)
\fP
.fi
\}
.if \nh \{
.\" ---End of section used in VMS HELP documentation---
.ex
\}
.SH "AN EXAMPLE"
The following simple Fortran program illustrates the messages given by
\fBftnchek\fP.
The program is intended to accept an array of test scores
and then compute the average for the series.
.PP
.nf
\fC
.so average.f
\fP
.fi
.PP
The compiler gives no error messages when this program is compiled.
Yet here is what happens when it is run:
.PP
.nf
\fC
$ run average
70
90
85
<EOF>
$
\fP
.fi
.PP
What happened?  Why didn't the program do anything?
The following is the output from
\fBftnchek\fP when it is used to debug the above
program:

.PP
.nf
\fC

$ ftnchek -list -symtab average
.so average.out
\fP
.fi
.PP
According to \fBftnchek\fP,
the program contains variables which may be
used before they are assigned an initial value, and variables which
are not needed.  \fBftnchek\fP also warns the user that an integer
quotient has been converted to a real. This may assist the user in
catching an unintended roundoff error.  Since the \fB\-symtab\fP flag
was given, \fBftnchek\fP prints out a table containing identifiers from
the local module and their corresponding datatype and number of
dimensions.  Finally, \fBftnchek\fP warns that the function
\fCCOMPAV\fR is not used
with the proper type of arguments.
.PP
With \fBftnchek\fP's
help, we can debug the program.  We can see that there
were the following errors:
.TP \w'1.'u+2n
1.
\fCSUM\fR and \fCCOUNT\fR
should have been converted to real before doing the division.
.TP \w'1.'u+2n
2.
\fCSUM\fR should have been initialized to 0 before entering the loop.
.TP \w'1.'u+2n
3.
\fCAVG\fR was never printed out after being calculated.
.TP \w'1.'u+2n
4.
\fCNUMS\fR should have been declared \fCINTEGER\fR
instead of \fCREAL\fR.
.PP
We also see that \fCI\fR, not \fCJ\fR, should have been declared
\fCINTEGER\fR in function \fCCOMPAV\fR. Also, \fCMAXNOS\fR was not
declared as \fCINTEGER\fR, nor \fCCOMPAV\fR as \fCREAL\fR, in
program \fCAVENUM\fR.  These are not errors, but they may indicate
carelessness.  As it happened, the default type of these variables
coincided with the intended type.
.PP
Here is the corrected program, and its output when run:
.PP
.nf
\fC
.so correct.f
$ run average
70
90
85
<EOF>
AVERAGE =   81.66666
$
\fP
.fi
.PP
With \fBftnchek\fP's
help, our program is a success!

.SH "INTERPRETING THE OUTPUT"
The messages given by
\fBftnchek\fP include not only
syntax errors but also warnings and informational messages
about things that are legal Fortran but that may indicate errors or
carelessness.
Most of these messages can be turned off by
command-line options.  Which option controls each message
depends on
the nature of the condition being warned about.  See the
descriptions of the command-line flags in the previous sections,
and of individual messages below.
Each message is prefixed with a word or phrase indicating the nature
of the condition and its severity.
.PP
``Error'' means a syntax error.  The simplest
kind of syntax errors are typographical errors, for example unbalanced
parentheses or misspelling of a keyword.  This type of error is caught
by the parser and appears with the description ``parse error'' or
``syntax error'' (depending on whether the parser was built using GNU
\fBbison\fP or UNIX \fByacc\fP respectively).
This type of error message cannot be
suppressed.  Be aware that this type of error often means
that \fBftnchek\fP has not properly interpreted the statement where the
error occurs, so that its subsequent checking operations will be
compromised.  You should eliminate all syntax errors before proceeding to
interpret the other messages \fBftnchek\fP gives.
.PP
``Warning: Nonstandard syntax'' indicates an extension to Fortran that
\fBftnchek\fP supports but that is not according to the Fortran 77 Standard.
The extensions that \fBftnchek\fP accepts
are described in the section on Extensions below.
One example is the \fCDO\fR ... \fCENDDO\fR construction.
If a program uses these extensions, warnings will be
given according to specifications under the \fB\-f77\fP setting.
The default behavior is to give no warnings.
.PP
``Warning'' in other cases
means a condition that is suspicious but that may or may not
be a programming error.  Frequently these conditions are legal under
the standard.  Some are illegal but do not fall under the heading
of syntax errors.
Usage errors are one example.
These refer to the possibility that a variable may be used before
it has been assigned a value (generally an error),
or that a variable is declared but never used (harmless but may
indicate carelessness).
The amount of checking for usage errors is controlled by
the \fB\-usage\fP flag, which
is set for the maximum amount of checking by default.
.PP
Truncation warnings cover situations in which accuracy may be lost
unintentionally, for example when a double precision value is assigned
to a real variable.  These warnings are controlled by the
\fB\-truncation\fP setting, which is on by default.
.PP
``Nonportable usage'' warns about some feature that may not be
accepted by some compilers even though it is not contrary
to the Fortran 77 Standard, or that may cause the program to perform
differently on different platforms.
For example, equivalencing real
and integer variables is usually a non-portable practice.
The use of extensions to the standard language is, of course, another
source of non-portability, but this is handled as a separate case.  To
check a program for true portability, both the \fB\-portability\fP and
the \fB\-f77\fP flags should be used.  They are both turned off by
default.  The \fB\-wordsize\fP setting is provided to check only those
nonportable usages that depend on a particular machine wordsize.
.PP
``Possibly misleading appearance'' is used for legal constructions that may not
mean what they appear to mean at first glance.  For example, Fortran is
insensitive to blank space, so extraneous space within variable names
or the lack of space between a keyword and a variable can convey the wrong
impression to the reader.
These messages can be suppressed by turning off the \fB\-pretty\fP
flag, which is on by default.
.PP
Other messages that are given after all the files are processed,
and having to do with agreement between modules, do not use the word
``warning'' but generally fall into that category.
Examples include type mismatches between corresponding variables in
different COMMON
block declarations, or between dummy and actual arguments of a
subprogram.
These warnings are controlled by the \fB\-common\fP and
\fB\-arguments\fP settings respectively.  By default both are set for
maximum strictness of checking.
.PP
Another group of warnings about conditions that are often harmless
refer to cases where the array properties of a variable
passed as a subprogram argument differ between the two routines.
For instance, an array element might be passed to a subroutine that
expects a whole array.  This is a commonly-used technique for
processing single rows or columns of two-dimensional arrays.
However, it could also indicate a programming error.  The
\fB\-array\fP setting allows the user to adjust the degree of
strictness to be used in checking this kind of agreement between
actual and dummy array arguments.  By default
the strictness is maximum.
.PP
``Oops'' indicates a technical
problem, meaning either a bug in \fBftnchek\fP or that its resources have
been exceeded.
.PP
The syntax error messages and warnings include
the filename along with the line number and column
number.  \fBftnchek\fP has two different options for the
appearance of these error messages.  If \fB\-novice\fP is in effect,
which is the default,
the messages are in a style approximating
normal English.  (In default style, the filename is
not printed in messages within the body of the program if \fB\-list\fP is in
effect.)  The other style of error messages is selected by the
\fB\-nonovice\fP option.  In this
style, the appearance of the messages is similar to that of the
UNIX \fBlint\fP program.
.PP
\fBftnchek\fP is still blind to some kinds of syntax errors.
The two most important ones are detailed checking of \fCFORMAT\fR statements,
and almost anything to do with control of execution
flow by means of \fCIF\fR, \fCDO\fR,
and \fCGOTO\fR statements: namely correct nesting of control structures,
matching of opening statements such as \fCIF\fR ... \fCTHEN\fR with
closing statements such as \fCENDIF\fR, and the proper use of
statement labels (numbers).  Most compilers will catch these errors.
See the section on Limitations for a more detailed discussion.
.PP
If \fBftnchek\fP gives you a syntax error message when the compiler does
not, it may be because your program contains an extension to
standard Fortran which is accepted by the compiler but not by
\fBftnchek\fP.  (See the section on Extensions.)
On a VAX/VMS system, you can use the compiler option \fC/STANDARD\fR
to cause the compiler to accept only standard Fortran.
On most UNIX or UNIX-like systems, this can be accomplished by
setting the flag \fB\-ansi.\fP
.PP
Many of the messages given by \fBftnchek\fP are self-explanatory.
Those that need some additional explanation are listed below in
alphabetical order.
.TP
.I "Common block NAME: data type mismatch at position n"
The \fIn\fP-th variable in the COMMON block differs in data type
in two different declarations of the COMMON block.  By default
(\fB\-common\fP strictness level 3), \fBftnchek\fP is very picky about
COMMON blocks: the variables listed in them must match exactly
by data type and array dimensions.  That is, the legal pair of
declarations in different modules:
.nf
\fC     COMMON /COM1/ A,B\fP
and
\fC     COMMON /COM1/ A(2)\fP
.fi
.IP
will cause \fBftnchek\fP to give warnings at strictness level 3.  These
two declarations are legal in Fortran since they both declare two real
variables.  At strictness level 1 or 2, no warning would be given in
this example, but the warning would
be given if there were a data type mismatch, for instance, if \fCB\fR
were declared \fCINTEGER\fR.
Controlled by \fB\-common\fP setting.

.TP
.I "Common block NAME has long data type following short data type"
Some compilers require alignment of multi-byte items so that each item
begins at an address that is a multiple of the item size.  Thus if a
short (e.g. single-precision real) item is followed by a long (e.g.
double precision real) item, the latter may not be aligned correctly.
Controlled by \fB\-portability=common\-alignment\fP option.

.TP
.I "Common block NAME has mixed character and non-character variables"
The ANSI standard requires that if any variable in a COMMON
block is of type \fCCHARACTER\fR, then all other variables in the
same COMMON block must also be of type \fCCHARACTER\fR.
Controlled by \fB\-f77=mixed\-common\fP option.

.TP
.I "Common block NAME: varying length"
For \fB\-common\fP setting level 2, this message means that
a COMMON block is declared to have different numbers of words in two
different subprograms.  A word is the amount of storage occupied by
one integer or real variable.
For \fB\-common\fP setting level 3, it means that the two declarations
have different numbers of variables, where an array of any size is
considered one variable.
This is not
necessarily an error, but it may indicate that a variable is missing
from one of the lists.  Note that according to the Fortran 77 Standard,
it is an error for named COMMON blocks (but not blank COMMON) to differ
in number of words in declarations in different modules.
Given for \fB\-common\fP setting 2 or 3.

.TP
.I "Error: Badly formed logical/relational operator or constant"
.TP
.I "Error: Badly formed real constant"
The syntax analyzer has found the start of
one of the special words that begin and
end with a period (e.g. \fC.EQ.\fR), or the start of a numeric constant,
but did not succeed in finding a complete item of that kind.

.TP
.I "Error: cannot be adjustable size in module NAME"
A character variable cannot be declared with a size that is an
asterisk in parentheses unless it is a dummy argument, a parameter, or
the name of the function defined in the module.

.TP
.I "Error: cannot be declared in SAVE statement in module NAME"
Only local variables and common blocks can be declared in a
\fCSAVE\fR statement.

.TP
.I "Error: No path to this statement"
\fBftnchek\fP will detect statements which are ignored or by-passed because
there is no foreseeable route to the statement.  For example, an
unnumbered statement (a statement without a statement label), occurring
immediately after a \fCGOTO\fR
statement, cannot possibly be executed.

.TP
.I "Error: Parse error"
This means that the parser, which analyzes the Fortran
program into expressions,
statements, etc., has been unable to find a valid interpretation for some
portion of a statement in the program.  If your compiler does not report a
syntax error at the same place, the most common explanations are: (1) use of an
extension to ANSI standard Fortran that is not recognized by
\fBftnchek\fP, or (2) the statement requires more lookahead than
\fBftnchek\fP uses (see section on Bugs).
.IP
NOTE: This message means that the affected statement is not interpreted.
Therefore, it is possible that \fBftnchek\fP's
subsequent processing will be in error, if it depends on any matters
affected by this statement (type declarations, etc.).

.TP
.I "Error: Syntax error"
This is the same as ``Error: Parse error'' (see above).  It is generated
if your version of \fBftnchek\fP was built using the UNIX \fByacc\fP
parser generator rather than GNU \fBbison\fP.

.TP
.I "Identifiers which are not unique in first six chars"
Warns that two identifiers which are longer than 6 characters do not
differ in the first 6 characters.  This is for portability: they may not
be considered distinct by some compilers.
Controlled by \fB\-sixchar\fP option.

.TP
.I "Nonportable usage: argument precision may not be correct for intrinsic function"
The precision of an argument passed to an intrinsic function may be
incorrect on some computers.  Issued when a numeric variable declared
with explicit precision (e.g.  \fCREAL*8 X\fR) is passed to a
specific intrinsic function (e.g. \fCDSQRT(X)\fR).
Controlled by \fB\-portability=mixed\-size\fP and \fB\-wordsize\fP.

.TP
.I "Nonportable usage: character constant/variable length exceeds 255"
Some compilers do not support character strings more than 255
characters in length.
Controlled by \fB\-portability=long\-string\fP.

.TP
.I "Nonportable usage: File contains tabs"
\fBftnchek\fP expands tabs to be equivalent to spaces up to the next column
which is a multiple of 8.  Some compilers treat tabs differently, and
also it is possible that files sent by electronic mail will have the tabs
converted to blanks in some way.  Therefore files containing tabs may not
be compiled correctly after being transferred.  \fBftnchek\fP does not give
this message if tabs only occur within comments or character constants.
Controlled by \fB\-portability=tab\fP.

.TP
.I "Nonportable usage: non-integer DO loop bounds"
This warning is only given when the \fCDO\fR index and bounds are
non-integer.
Use of non-integer quantities in a \fCDO\fR statement may cause
unexpected errors, or different results on different machines, due to
roundoff effects.
Controlled by \fB\-portability=real\-do\fP.

.TP
.I "Possibly it is an array which was not declared"
This message is appended to warnings related to
a function invocation or to an argument type
mismatch, for which the possibility exists that what appears to be a
function is actually meant to be an array.  If the programmer forgot to
dimension an array, references to the array will be interpreted as
function invocations.  This message will be suppressed if the name in
question appears in an \fCEXTERNAL\fR or \fCINTRINSIC\fR statement.
Controlled by the \fB\-novice\fP option.

.TP
.I "Possibly misleading appearance: characters past 72 columns"
The program is being processed with the statement field width at its
standard value of 72, and some nonblank characters have been found
past column 72.  In this case,
\fBftnchek\fP is not processing the characters past column 72, and is
notifying the user that the statement may not have the meaning that it
appears to have.  These characters might be intended by the programmer to be
significant, but they will be ignored by the compiler.  Controlled by
\fB\-pretty=long\-line\fP.

.TP
.I "Possibly misleading appearance: Common block declared in more than one statement"
Such multiple declarations are legal and have the same effect as
a continuation of the original declaration of the block.
This warning is only given if the two declarations are separated by
one or more intervening statements.
Controlled by \fB\-pretty=multiple\-common\fP.

.TP
.I "Possibly misleading appearance: Continuation follows comment or blank line"
\fBftnchek\fP issues this warning message to alert the user that a
continuation of a statement is interspersed with comments, making it easy
to overlook.
Controlled by \fB\-pretty=continuation\fP.

.TP
.I "Possibly misleading appearance: Extraneous parentheses"
Warns about parentheses surrounding a variable by itself in an
expression.  When a parenthesized variable is passed as an argument to
a subprogram, it is treated as an expression, not as a variable whose
value can be modified by the called routine.
Controlled by \fB\-pretty=parentheses\fP.

.TP
.I "Subprogram NAME: argument data type mismatch at position n"
The subprogram's
\fIn\fP-th actual argument (in the \fCCALL\fR or the
usage of a function) differs in datatype or precision from the \fIn\fP-th dummy
argument (in the \fCSUBROUTINE\fR or \fCFUNCTION\fR
declaration).  For instance, if the user defines a
subprogram by
.nf
\fC     SUBROUTINE SUBA(X)\fP
\fC     REAL X\fP
and elsewhere invokes \fCSUBA\fP by
\fC     CALL SUBA(2)\fP
.fi
.IP
\fBftnchek\fP will detect the error.  The reason here
is that the number 2 is integer, not real.  The user should have written
.nf
\fC     CALL SUBA(2.0)\fP
.fi
.IP
When checking an argument which is a subprogram, \fBftnchek\fP must be
able to determine whether it is a function or a subroutine.  The rules
used by \fBftnchek\fP to do this are as follows: If the subprogram,
besides being passed as an actual argument, is also invoked directly
elsewhere in the same module, then its type is determined by that
usage.  If not, then if the name of the subprogram does not appear in
an explicit type declaration, it is assumed to be a subroutine; if it
is explicitly typed it is taken as a function.  Therefore, subroutines
passed as actual arguments need only be declared by an \fCEXTERNAL\fR
statement in the calling module, whereas functions must also be
explicitly typed in order to avoid generating this error message.
Controlled by \fB\-arguments\fP setting.

.TP
.I "Subprogram NAME: argument arrayness mismatch at position n"
Similar to the preceding situation, but
the subprogram dummy argument differs from the corresponding actual
argument in its number of dimensions or number of elements.
Controlled by \fB\-array\fP together with \fB\-arguments\fP settings.

.TP
.I "Subprogram NAME: argument mismatch at position n"
A character dummy argument is larger than the corresponding actual
argument, or a Hollerith dummy argument is larger than the
corresponding actual argument.  Controlled by \fB\-arguments\fP setting.

.TP
.I "Subprogram NAME: argument usage mismatch"
\fBftnchek\fP detects a possible conflict between the way a subprogram uses
an argument and the way in which the argument is supplied to the
subprogram.  The conflict can be one of two types, as outlined below.

.TP
.if n .ti +3
.if t .ti +.3i
.I "Dummy arg is modified, Actual arg is const or expr"
A dummy argument is an argument as named in a \fCSUBROUTINE\fR or
\fCFUNCTION\fR statement and used within the subprogram.  An actual
argument is an argument as passed to a subroutine or function by the
caller.  \fBftnchek\fP is saying that a dummy argument is modified by
the subprogram, implying that its value is changed in the calling module.
The corresponding actual argument should not be a constant or
expression, but rather a variable or array element which can be
legitimately assigned to.
Given for \fB\-usage\fP setting (one's digit) 1 or 3.

.TP
.if n .ti +3
.if t .ti +.3i
.I "Dummy arg used before set, Actual arg not set"
Here a dummy argument may be used in the subprogram
before having a value assigned to it by the subprogram.  The
corresponding actual argument should have a value assigned to it by the
caller prior to invoking the subprogram.
Given for \fB\-usage\fP setting (one's digit) 1 or 3.
.IP
These warnings are not affected by the \fB\-arguments\fP setting.

.TP
.I "Subprogram NAME invoked inconsistently"
Here the mismatch is between the datatype of the subprogram itself as
used and as defined. For instance, if the user declares
.nf
\fC     INTEGER FUNCTION COUNT(A)\fP
and invokes \fCCOUNT\fR in another module as
\fC     N = COUNT(A)\fP
.fi
.IP
without declaring its datatype, it will default to real type, based on
the first letter of its name.  The calling module should have included
the declaration
.nf
\fC     INTEGER COUNT\fP
.fi
.IP
Given for \fB\-arguments\fP setting 2 or 3.

.TP
.I "Subprogram NAME:  varying length argument lists:"
An inconsistency has been found between the number of dummy arguments
(parameters) a subprogram has and the number of actual arguments given it
in an invocation.
\fBftnchek\fP keeps track of all invocations of subprograms
(\fCCALL\fR
statements and expressions using functions) and compares them with
the definitions of the subprograms elsewhere in the source code.  The
Fortran compiler normally does not catch this type of error.
Given for \fB\-arguments\fP setting 1 or 3.

.TP
.I "Variable not declared.  Type has been implicitly defined"
When printing the symbol table for a module,
\fBftnchek\fP will flag with an asterisk
all identifiers that are not explicitly typed
and will show the datatype that was assigned through implicit typing.
This provides support for users who wish to declare all variables as
is required in Pascal or some other languages.
This message appears only when the \fB\-symtab\fP option is in effect.
Alternatively, use the \fB\-declare\fP flag if you want to get a list of all
undeclared variables.

.TP
.I "Variables declared but never referenced"
Detects any identifiers that were declared in your program but were
never used, either to be assigned a value or to have their value
accessed.  Variables in COMMON are excluded.
Given for \fB\-usage\fP setting (one's digit) 2 or 3.

.TP
.I "Variables set but never used"
\fBftnchek\fP will notify the user when a variable has been assigned a
value, but the variable is not otherwise used in the program.  Usually
this results from an oversight.
Given for \fB\-usage\fP setting (one's digit) 2 or 3.

.TP
.I "Variables used before set"
This message indicates that an identifier is used to compute a value
prior to its initialization.  Such usage may lead to an incorrect value
being computed, since its initial value is not controlled.
Given for \fB\-usage\fP setting (one's digit) 1 or 3.

.TP
.I "Variables may be used before set"
Similar to used before set except that \fBftnchek\fP is not able to
determine its status with certainty.  \fBftnchek\fP assumes a variable
may be used before set if the first usage of the variable occurs prior
in the program text to its assignment.
Given for \fB\-usage\fP setting (one's digit) 1 or 3.

.TP
.I "Warning: DO index is not integer"
This warning is only given when the \fCDO\fR bounds are integer, but
the \fCDO\fR index is not.  It may indicate a failure to declare the
index to be an integer.
Controlled by \fB\-truncation=real\-do\fP option.

.TP
.I "Warning: integer quotient expr converted to real"
The quotient of two integers results in an integer type result, in
which the fractional part is dropped.  If such an integer expression
involving division is later converted to a real datatype, it may be that
a real type division had been intended.
Controlled by \fB\-truncation=int\-div\-real\fP option.

.TP
.I "Warning: Integer quotient expr used in exponent"
The quotient of two integers results in an integer type result, in
which the fractional part is dropped.  If such an integer expression
is used as an exponent, it is quite likely that a real type division was
intended.
Controlled by \fB\-truncation=int\-div\-exponent\fP option.

.TP
.I "Warning: NAME not set when RETURN encountered"
The way that functions in Fortran return a value is by assigning the
value to the name of the function.  This message indicates that the
function was not assigned a value before the point where a
\fCRETURN\fR statement was found.  Therefore it is possible that the
function could return an undefined value.

.TP
.I "Warning: Nonstandard syntax: adjustable size cannot be concatenated here"
The Fortran 77 Standard forbids concatenating character variables
whose size is an asterisk in parentheses, except in an assignment
statement.   Controlled by \fB\-f77=mixed\-expr\fP.

.TP
.I "Warning: Nonstandard syntax : significant characters past 72 columns"
This warning is given under the \fB\-f77=long\-line\fP setting if the
\fB\-columns\fP setting has been used to increase the statement field width,
and a statement has meaningful program text beyond column 72.
Standard Fortran ignores all text in those columns, but some compilers
do not.  Thus the program may be treated differently by different
compilers.

.TP
.I "Warning: Nonstandard syntax : Statement out of order."
\fBftnchek\fP will detect statements that are out of the
sequence specified for ANSI standard Fortran 77.  Table 1 illustrates the
allowed sequence of statements in the Fortran language.  Statements which are
out of order are nonetheless interpreted by
\fBftnchek\fP,
to prevent ``cascades'' of error messages.
The sequence counter is also rolled back to prevent
repetition of the error message for a block of similar statements.
Controlled by the \fB\-f77=statement\-order\fP option.

.IP
.nf
.if n .ne 11
.if t .ne 1.75i
\fC
--------------------------------------------------------
                  |               | implicit
                  |  parameter    |---------------------
                  |               | other specification
        format    |---------------|---------------------
         and      |               | statement-function
        entry     |  data         |---------------------
                  |               | executable
--------------------------------------------------------

                      \fRTable 1\fP
\fP
.fi
.TP
.I "Warning: Possible division by zero"
This message is printed out wherever division is done (except division
by a constant).  Use it to
help locate a runtime division by zero problem.
Controlled by \fB\-division\fP option.

.TP
.I "Warning: real truncated to intg"
\fBftnchek\fP has detected an assignment statement which has a real
expression on the right, but an integer variable on the left.  The
fractional part of the real value will be lost.  If you explicitly
convert the real expression to integer using the \fCINT\fR or
\fCNINT\fR intrinsic function, no warning will be printed.  A similar
message is printed if a double precision expression is assigned to a
single precision variable, etc.
Controlled by \fB\-truncation=demotion\fP option.

.TP
.I "Warning: subscript is not integer"
Since array subscripts are normally integer quantities, the use of a
non-integer expression here may signal an error.
Controlled by \fB\-truncation=real\-subscript\fP option.

.TP
.I "Warning: Unknown intrinsic function"
This message warns the user that a name declared in an
\fCINTRINSIC\fR statement is unknown to \fBftnchek\fP.  Probably it is
a nonstandard intrinsic function, and so the program will not be
portable.  The function will be treated by \fBftnchek\fP as a
user-defined function.  This warning is not suppressed by any
option, since it affects \fBftnchek\fP's analysis of
the program.  However, if the intrinsic function is in one of the
supported sets of nonstandard intrinsics, you can use the
\fB-intrinsic\fP setting to cause \fBftnchek\fP to recognize it.

.SH "LIMITATIONS AND EXTENSIONS"

\fBftnchek\fP accepts ANSI standard Fortran-77 programs with some minor
limitations and numerous common extensions.
.TP
.B Limitations:
.IP
\fBftnchek\fP uses only one line of lookahead when
analyzing a program into its basic syntactic elements.  If a
particular statement is difficult to identify, it may be handled
improperly if the ambiguity is not resolved on a single line.  This
limitation applies to complex constants except in \fCDATA\fR
statements, and to situations in which a variable name might be
confused with a keyword.  For example, if the variable name
\fCWRITE\fR is used for an array, then a very long
statement assigning a value
to some element of this array could be mistaken as a \fCWRITE\fR
statement if the equals sign is not on the same line as the word
\fCWRITE\fR.
.IP
The dummy arguments in statement functions are treated like ordinary
variables of the program.  That is, their scope is the entire module, not
just the statement function definition.
.IP
The checking of FORMAT statements is lax, tolerating missing separators
(comma, etc.) between format descriptors in places where the Standard
requires them, and allowing \fI.\|d\fP fields on descriptors that should
not have them.  It does warn under \fB\-f77=format\-edit\-descr\fP
about nonstandard descriptor types (like
\fCO\fR), and supported extensions.
.IP
The only checking related to control of execution
flow is a warning about statements that cannot be reached because they
do not have a label and they follow an unconditional transfer.
There is no checking for correct nesting of \fCDO\fR loops or
matching of opening statements such as \fCIF\fR ... \fCTHEN\fR with
closing statements such as \fCENDIF\fR, nor the proper definition and use of
statement labels.  Fortunately, most compilers will catch these errors.
.IP
If a user-supplied subprogram has the same name as one of the
nonstandard intrinsic functions recognized by \fBftnchek\fP, it must
be declared in an \fCEXTERNAL\fR statement in any routine that invokes
it.  Otherwise it will be subject to the checking normally given to
the intrinsic function.  Since the nonstandard intrinsics are not
standard, this \fCEXTERNAL\fR statement is not required by the Fortran
77 Standard.  Using the \fB\-intrinsic=0\fP setting, recognition of most
nonstandard intrinsics (excepting only those needed to support the
double complex data type) can be turned off.  See the lists of
supported nonstandard intrinsic functions under the discussion of the
\fB\-intrinsic\fP setting above.
.TP
.B Extensions:
All of these extensions (except lower-case characters) will generate
warnings if the relevant \fB\-f77\fP
option is set.
Some of the extensions listed below are part of the Fortran-90
Standard.  These are indicated by the notation (F90).
.IP
Tabs are permitted, and translated into equivalent blanks which correspond
to tab stops every 8 columns.  The standard does not recognize tabs.
Note that some compilers allow tabs, but treat them differently.  The
treatment defined for DEC FORTRAN can be achieved using \fB\-source\fP
setting value 1.
.IP
Strings may be delimited by either quote marks or apostrophes.  A
sequence of two delimiter characters is interpreted as a single
embedded delimiter character.  (F90)
.IP
Strings may contain UNIX-style backslash escape sequences.  They will
be interpreted as such if the \fB\-source\fP value 4 (backslash) is given.
Otherwise the backslash character will be treated as a normal
printing character.
.IP
Lower case characters are permitted, and are converted internally to
uppercase except in character strings.  The standard specifies upper case only,
except in comments and strings.  (F90)
.IP
Hollerith constants are permitted, in accordance with the Fortran 77
Standard, appendix C.  They should not be used in expressions, or confused
with datatype CHARACTER.
.IP
The letter 'D' (upper or lower case) in column 1 is treated as
the beginning of a comment.  There is no option to treat such lines as
statements instead of comments.
.IP
Statements may be longer than 72 columns provided that the setting
\fB\-column\fP
was used to increase the limit.  According to the standard, all
text from columns 73 through 80 is ignored, and no line may be longer
than 80 columns.
.IP
Variable names may be longer than six characters.  The standard specifies
six as the maximum.  \fBftnchek\fP permits names up to 31 characters
long (F90).
.IP
Variable names may contain underscores and dollar signs,
which are treated the same as alphabetic letters.  The default type
for variables beginning with these characters is REAL.
In IMPLICIT type statements specifying a range of characters,
the dollar sign follows Z and is followed by underscore.
Fortran 90 permits underscores in variable names.
.IP
The UNIX version tolerates the presence of preprocessor directives,
namely lines beginning with the pound sign
(#).
These are treated as comments, except for
\fC#line\fR
directives, which are interpreted, and are used to set the line number
and source file name for warnings and error messages.  Note that
\fC#include\fR
directives are not processed by \fBftnchek\fP.  Programs that use them for
including source files should be passed through the preprocessor
before being input to \fBftnchek\fP.
As noted below, \fBftnchek\fP does process
\fCINCLUDE\fR statements, which have a different syntax.
.IP
The \fCDO\fR ...  \fCENDDO\fR control structure is permitted.  The
syntax which is recognized is according to either of the following two
forms:
.in +5
\fCDO\fP [\fIlabel\fP [\fC,\fP]] \fIvar\fP \fC=\fP
\fIexpr\fP \fC,\fP \fIexpr\fP [\fC,\fP \fIexpr\fP]
.br
 ...
.br
\fCEND DO\fP
.in -5
or
.in +5
\fCDO\fP [\fIlabel\fP [\fC,\fP]] \fCWHILE (\fP \fIexpr\fP \fC)\fP
.br
 ...
.br
\fCEND DO\fP
.in -5
where square brackets indicate optional elements.
This is a subset of the Fortran 90 do-loop syntax.
.IP
The \fCACCEPT\fP and \fCTYPE\fP statements (for terminal I/O) are
permitted, with the same syntax as \fCPRINT\fP.
.IP
The so-called ``Cray pointer'' syntax is tolerated. It is not the same as the
Fortran 90 \fCPOINTER\fP statement.  There is no real checking
of the statement other than basic syntax.
The form of this statement is
.in +3
\fCPOINTER (\fP\fIpointer\fP\fC, \fP\fIpointee\fP\fC)\fP
[\fC,(\fP\fIpointer\fP\fC, \fP\fIpointee\fP\fC)\fP]
.in -3
The pointer variables are assigned a data type of \fCINTEGER *4\fP.
Usage checking of the pointee variables is suppressed, since in
practice they are accessed indirectly via the pointers.
.IP
Statements may have any number of continuation lines.  The standard
allows a maximum of 19.
.IP
Inline comments, beginning with an exclamation mark, are
permitted.  (F90)
.IP
NAMELIST I/O is supported.  The syntax is the same as in Fortran 90.
.IP
FORMAT statements can contain a dollar sign to indicate suppression of
carriage-return.
An integer expression enclosed in angle brackets can be used anywhere in a
FORMAT statement where
the Fortran 77 Standard allows an integer constant (except for the length of a
Hollerith constant),
to provide a run-time value for a repeat specification or field width.
.IP
Nonstandard keywords are allowed in I/O statements,
corresponding to those in VMS Fortran.
.IP
The \fCIMPLICIT NONE\fR statement is supported.  The meaning of this
statement is that all variables must have their data types explicitly
declared.  Rather than flag the occurrences of such variables with
syntax error messages, \fBftnchek\fP waits till the end of the module,
and then prints out a list of all undeclared variables,
as it does for the \fB\-declare\fP option.  (F90)
.IP
Data types \fCINTEGER\fR, \fCREAL\fR, \fCCOMPLEX\fR, and
\fCLOGICAL\fR are allowed to have an optional precision specification in
type declarations.  For instance, \fCREAL*8\fR means an 8-byte
floating point data type.  The \fCREAL*8\fR datatype is not
necessarily considered equivalent to \fCDOUBLE PRECISION\fR,
depending on the \fB\-wordsize\fP setting.
The Fortran 77 Standard allows
a length specification only for \fCCHARACTER\fR data.
.IP
\fBftnchek\fP supports the \fCDOUBLE\fR \fCCOMPLEX\fR type
specification for a complex quantity whose real and imaginary parts
are double precision.  Mixed-mode arithmetic involving
single-precision complex with double-precision real data,
prohibited under the Standard, yields a double complex result.
.IP
Many commonly found nonstandard intrinsic functions are provided.  See
the discussion of \fB\-intrinsic\fP for a list of functions and how to
control which ones are recognized..
.IP
Argument checking is not tight for those nonstandard intrinsics
that take arrays or mixed argument types.
.IP
\fBftnchek\fP permits the \fCINCLUDE\fR statement, which causes
inclusion of the text of the given file.  The syntax is
.in +5
\fCINCLUDE '\fP\fIfilename\fP\fC'\fP
.in -5
.IP
This is compatible with Fortran 90.
If the \fB\-source\fP setting value 2 is given, \fBftnchek\fP follows
VMS conventions with respect to this statement: it assumes a default
extension of \fI.\|for\fP if no filename extension is given, and
allows the qualifier \fC/[NO]LIST\fR following the filename, to
control the listing of the included file.  There is no support for
including VMS text modules.
.IP
In diagnostic output relating to items contained in include
files, the location of the error is specified by both
its location in the include file and the location in the parent file
where the file was included.
.IP
\fBftnchek\fP accepts \fCPARAMETER\fR definitions that involve
intrinsic functions
and exponentiation by a non-integer exponent.  Both of these cases are
prohibited by the Fortran 77
Standard, and will be warned about if the \fB\-f77=param\-intrinsic\fP
flag is given.  If an intrinsic function value
is a compile-time integer constant,
\fBftnchek\fP will evaluate it.  This allows better checking if the
parameter is used in declaring array sizes.  Fortran 90 allows
intrinsic functions in \fCPARAMETER\fR definitions.
.IP
The intrinsic functions that are evaluated are:
.nf
\fC    ABS       IABS      DIM       IDIM      MAX\fP
\fC    MAX0      MIN       MIN0      MOD       SIGN\fP
\fC    ISIGN     LEN       ICHAR     INDEX\fP
.fi
.IP
The functions of integer arguments are evaluated only if the arguments
are integer constant expressions.  (These may involve integer
constants, parameters, and evaluated intrinsic functions.)  The
function \fCLEN\fR is evaluated if its argument is an expression
involving only character constants and variables whose length is not
adjustable.  The functions \fCICHAR\fR and \fCINDEX\fR are evaluated
only if the arguments are character constants.  \fBftnchek\fP gives a
warning if it needs the value of some intrinsic function that is not
evaluated.
.SH "NEW FEATURES"
Here are the changes from Version 2.8 to Version 2.9:
.TP \w'1.'u+2n
1.
The \fB\-usage\fP flag is now a 3-digit number, for separate
control of checking of subprograms, common variables, and
local variables.
.TP \w'1.'u+2n
2.
New command-line options: \fB\-nocheck\fP, \fB\-intrinsic\fP,
\fB\-source\fP, \fB\-version\fP .  Changed \fB\-f77\fP,
\fB\-portability\fP, \fB\-pretty\fP and \fB\-truncation\fP from switches
to string settings that allow detailed control of warnings.
Eliminated \fB\-backslash\fP, \fB\-hollerith\fP and
\fB\-tab\fP switches which are now handled by \fB\-source\fP
and \fB\-portability\fP settings.
Changed name of \fB\-noverbose\fP option to \fB\-quiet\fP.
.TP \w'1.'u+2n
3.
Ftnchek now reads a startup file named \fI.\|ftnchekrc\fP or
\fIftnchek.ini\fP located in the current directory or in the home
directory.
.TP \w'1.'u+2n
4.
Added a new \fB\-makedcls\fP value: 512=no-array-dimensions.
.TP \w'1.'u+2n
5.
Command-line numeric settings can omit the number, giving
them default turn-on values.
.TP \w'1.'u+2n
6.
The \fB\-calltree\fP option now takes various numeric settings to
specify options for the form of the output.
.TP \w'1.'u+2n
7.
The non-parenthesis \fCPARAMETER\fP statement variant,
and the Cray \fCPOINTER\fP statement are now part of
the distribution, i.e. no longer as patches accompanying the
source.
.TP \w'1.'u+2n
8.
Two new warnings: common block and subprogram having the
same name, controlled by the \fB\-f77\fP flag;
and statement function defined but not used, controlled by the
\fB\-usage\fP setting.
.TP \w'1.'u+2n
9.
The support for VCG output has been improved so that \fBftnchek\fP now
sends output to a file that is suitable for direct input
to \fBxvcg\fP.  The script \fIfcl2vcg\fP is now obsolete.  Support for
VCG is now standard.
.TP \w'1.'u+2n
10.
Various minor bugs were fixed, and some improvements
were made to help in maintaining and distributing
the program: the source code has been augmented with function
prototypes, and a configure script is used to handle
variations among systems automatically.
.TP \w'1.'u+2n
11.
Support for VMS I/O keywords is now standard.  Previously it was only
enabled in VMS version.
.TP \w'1.'u+2n
12.
Recognition of nonstandard intrinsic functions is now controlled by
command-line option \fB\-intrinsic\fP.  Previously the choice was set
when building \fBftnchek\fP.
.TP \w'1.'u+2n
13.
Support for quad precision constants (such as \fC1.23Q4\fP) and
intrinsic functions was added.
.PP
Here are the changes from Version 2.7 to Version 2.8:
.TP \w'1.'u+2n
1.
Improvements in handling command-line settings:
add support for colon as assignment operator, and
extend setting switch support to include a default value to replace
out-of-range values, instead of just choosing the nearer endpoint of
the valid range.
.TP
2.
New options:
.BI \-makedcls= num
to generate variable declarations;
.B \-backslash
to handle UNIX-style backslash escapes in character strings;
.B \-resource
to print out internal resource usage;
.B \-tab
to accept DEC-style tab-formatted source.
.TP
3.
New extensions to syntax:
Accept quote marks as an alternative to apostrophes for delimiting strings.
Accept 'D' as equivalent to 'C' in column 1 for comments.
A patch is supplied to allow ``Cray pointer'' syntax to be tolerated.
(This patch does not include checking proper use of pointers.)
.TP
4.
Provide variable names and not just position numbers in warnings about
mismatches in common block declarations and subprogram argument lists.
.TP
5.
Add installation validation suite to check for correct functioning
after a new installation, or a new compilation with a different
compiler or compiler options.  The validation suite also serves to
record input cases that exhibited bugs in older versions of the
program, providing regression testing to ensure that changes do not
introduce new bugs, or restore old ones.  This test suite uncovered
compiler optimizer errors on at least one system, errors which did not
appear in older versions of \fBftnchek\fP.
.TP
6.
Improve memory management to avoid running out of space.
.TP
7.
Update the UNIX Makefile with new targets following the Free Software
Foundation standards, and create the
.I CHECKLIST
file to record systems for which this version of \fBftnchek\fP has
been successfully built and has passed the validation suite tests.
.TP
8.
Add the
.I man2ps
script, and a target in the UNIX
.I Makefile
to use it for converting the manual pages file to PostScript.
.TP
9.
Correct several small typographical irregularities in these manual
pages.
.B troff
preserves all input spaces, so great care is needed in preparing troff
input to avoid introducing spurious space into the typeset output.
.PP
Grateful acknowledgement is given to Nelson H. F. Beebe of the
University of Utah for providing most of these improvements, and
especially for writing most of the new code to produce
variable declarations, which represents a very substantial effort.
.SH "BUGS"
\fBftnchek\fP still has much room for improvement.
Your feedback is appreciated.  We want to know about any bugs you notice.
Bugs include not only cases in which \fBftnchek\fP issues an error message
where no error exists, but also if \fBftnchek\fP fails to issue a warning when
it ought to.  Note, however, that \fBftnchek\fP is not intended to catch all
syntax errors (see section on Limitations).
Also, it is not considered a bug for a variable to be
reported as used before set, if the reason is that the usage of the
variable occurs prior in the text to where the variable is set.  For
instance, this could occur when a \fCGOTO\fR causes execution to loop backward
to some previously skipped statements.  \fBftnchek\fP does not analyze the
program flow, but assumes that statements occurring earlier in the text
are executed before the following ones.
.PP
We especially want to know if \fBftnchek\fP crashes for any reason.  It is
not supposed to crash, even on programs with syntax errors.  Suggestions
are welcomed for additional features which you would find useful.  Tell
us if any of \fBftnchek\fP's
messages are incomprehensible.  Comments on the
readability and accuracy of this document are also welcome.
.PP
You may also suggest support for additional extensions to the
Fortran language.  These will be included only if it is felt that the
extensions are sufficiently widely accepted by compilers.
.PP
If you find a bug in \fBftnchek\fP,
first consult the list of known bugs
below to see if it has already been reported.  Also check the section
entitled ``Limitations and Extensions'' above for restrictions
that could be causing the problem.  If you do not find the problem
documented in either place, then send a report including
.TP \w'1.'u+2n
1.
The operating system and CPU type on which \fBftnchek\fP is running.
.TP
2.
The version of \fBftnchek\fP and values of any environment options or
settings defined in startup file.  (Capturing the output of \fCftnchek
-help\fP is useful for this.)
.TP
3.
A brief description of the bug.
.TP
4.
If possible, a small sample program showing the bug.
.PP
.br
The report should be sent to the following address:
.in +5
\fC      moniot@mary.fordham.edu\fP
.PP
Highest priority will be given to bugs which cause \fBftnchek\fP to crash.
.PP
Certain problems that arise when checking large programs can be fixed
by increasing the sizes of the data areas in \fBftnchek\fP.  (These
problems are generally signaled by error messages beginning with ``Oops''.)
The simplest way to increase the table sizes is by
recompiling \fBftnchek\fP with the \fCLARGE_MACHINE\fR macro name
defined.  Consult the \fCmakefile\fR and \fCREADME\fR file for the
method of doing this.
.PP
The following is a list of known bugs.
.TP \w'1.'u+2n
1.
Bug: Used-before-set message is suppressed for any variable which
is used as the loop index in an implied-do loop, even if it was in
fact used before being set in some earlier statement.
For example, consider \fCJ\fR in the statement
.IP
.nf
\fC      WRITE(5,*) (A(J), J=1,10)\fP
.fi
.IP
Here \fBftnchek\fP parses the I/O expression,
\fCA(J)\fR, where \fCJ\fR is used, before it parses the implied loop
where \fCJ\fR is set.  Normally this would cause
\fBftnchek\fP to report a spurious used-before-set warning for \fCJ\fR.
Since this report is usually in error and occurs fairly commonly,
\fBftnchek\fP suppresses the warning for \fCJ\fR altogether.
.IP
Prognosis: A future version of  \fBftnchek\fP is planned which will handle
implied-do loops correctly.
.TP
2.
Bug: Variables used (not as arguments) in statement-function
subprograms do not have their usage status updated when the statement
function is invoked.
.IP
Prognosis: To be fixed in a future version of \fBftnchek\fP.
.TP
3.
Bug: VAX version does not expand wildcards in filenames on the
command line if they are followed without space by an option, e.g.
\fCftnchek *.f/calltree\fR would not expand the \fC*.f\fR.
This is because VMS-style options without intervening
space are not supported by the GNU \fCshell_mung\fR routine that is used
to expand wildcards.
.IP
Prognosis: unlikely to be fixed.

.SH "ACKNOWLEDGEMENTS"
\fBftnchek\fP is a public-domain program.  It
was designed by Dr. Robert Moniot, professor at Fordham
University.  During the academic year of
1988-1989, Michael Myers and Lucia Spagnuolo developed the program to
perform the variable usage checks.  During the following year it was
augmented by Lois Bigbie to check subprogram arguments and
COMMON block declarations.
Brian Downing assisted with the implementation of the \fCINCLUDE\fR
statement.
John Quinn wrote the common block usage checks.
Nelson H. F. Beebe of the University of Utah added most of the new code
to implement the \fB\-makedcls\fP feature.
The \fB\-reference\fP feature was contributed by Gerome Emmanuel,
Ecole des mines, U. Nancy (slightly modified).
The support for Cray pointer syntax was provided by John Dannenhoffer of
United Technologies Research Center.
Additional features will be added as time permits.
With Version 2.5, the name was changed from \fBforchek\fP to \fBftnchek\fP,
to avoid confusion with a
similar program named \fBforcheck\fP,
developed earlier at Leiden University.
.PP
We would like to thank
John Amor of the University of British Columbia,
Reg Clemens of the Air Force Phillips Lab in Albuquerque,
Markus Draxler of the University of Stuttgart,
Victor Eijkhout of the University of Tennessee at Knoxville,
Greg Flint of Purdue University,
Daniel P. Giesy of NASA Langley Research Center,
Fritz Keinert of Iowa State University,
Judah Milgram of the University of Maryland College Park,
Hugh Nicholas of the Pittsburgh Supercomputing Center,
Dan Severance of Yale University,
Phil Sterne of Lawrence Livermore National Laboratory,
Larry Weissman of the University of Washington,
Warren J. Wiscombe of NASA Goddard,
and especially
Nelson H. F. Beebe of the University of Utah,
for pointing out bugs and suggesting some improvements.
We also thank Jack Dongarra for putting
\fBftnchek\fP into the \fCnetlib\fR
library of publicly available software.
\}
\" The above brace is the end of the .if !\nb at section "OPTIONS"
.SH "INSTALLATION AND SUPPORT"
The
\fBftnchek\fP program can be obtained
by anonymous ftp from many software servers, including host
\fCnetlib.org\fR
(128.169.92.17) where it is located in directory
\fC/fortran\fR.
You should download it in binary mode.
If the file extension is \fI.\|Z\fP, uncompress with the Unix
.BR uncompress (1)
utility.  If the file extension is \fI.\|gz\fP, uncompress with the
GNU
.BR gunzip (1L)
program.  Then use
.BR tar (1)
to unpack the files into a subdirectory.
.PP
Installation requires a C compiler for your computer.
See the \fCINSTALL\fR file provided with the distribution for
instructions on installing \fBftnchek\fP on your system.
Executable binary for particular systems such as IBM PC or
Macintosh, as available, can be obtained by anonymous ftp from
\fCftp.dsm.fordham.edu\fP (150.108.64.2), located in directory
\fC/pub/ftnchek2.9\fP.
Assistance in preparing such executable binary forms is welcome.
.if !\nb \{
.PP
The \fBnroff\fP version of this document is named
.IR ftnchek.\|man .
On UNIX systems, this file can be used as the man page,
but actually it is a multi-purpose source file which is used to produce
the other forms of the documentation.  The cleaned-up man page
document, created during installation of \fBftnchek\fP, is named
.IR ftnchek.\|1 .
You can print it using the command
.nf
\fC      nroff -man ftnchek.1 | lpr\fR.
.fi
The distribution also includes a plain ASCII version named
.IR ftnchek.\|doc ,
a PostScript version named
.IR ftnchek.\|ps ,
and a VMS HELP version named
.IR ftnchek.\|hlp .
\}
.PP
Information about the latest version and the status of the project can be
obtained by the Internet command ``\fCfinger ftnchek@mary.fordham.edu\fR''.
For further information and to report bugs, you may contact Dr. Robert Moniot
at the following network address:
.PP
.in +5
\fC      moniot@mary.fordham.edu\fP
..in -5
.if !\nb \{
.SH "SEE ALSO"
.BR dcl2inc (1L),
.BR dtoq (1L),
.BR dtos (1L),
.BR f77 (1),
.BR fd2s (1L),
.BR fs2d (1L),
.BR pfort (1L),
.BR qtod (1L),
.BR sf3 (1L),
.BR stod (1L).
.BR xsf3 (1L),
.BR xvcg (1L).
\}
.\"==============================[The End]==============================
