//   -*- mode: c++; -*-
#include <map.h>
#include <multimap.h>
#include <vector.h>
#include "adstring.h"
#include "common.h"

//Exception classes:

class unknown_cond_package:public parseerror{
public:
  unknown_cond_package(parsestream *p):parseerror(p){};
  const char *errormsg(){
    return "unknown install condition (currently, only \"package\" is supported)"; }
};  
class def_error:public parseerror{
public:
  def_error(parsestream *p):parseerror(p){};
  const char *errormsg(){
    return "Error in definition"; }
};  

class cond_inst_false{};//conditional install returns false

class ferror_read{
public:
  char name[MAX_LINE];
  ferror_read(String s){
    strcpy(name,s.chrstr());
  };
};  //file open for reading failed
class pipeerror_read{
public:
  char name[MAX_LINE];
  pipeerror_read(String s){
    strcpy(name,s.chrstr());
  };
};  //pipe open for reading failed

class dir_error_read{
public:
  char name[MAX_LINE];
  dir_error_read(String s){
    strcpy(name,s.chrstr());
  };
};  //dir open for reading failed

class informed_fatal{}; //something BAD happened, we told user, now die.


#define DPKG_STATUSFILE "/var/lib/dpkg/status"
#define MENUMETHODS     "/etc/menu-methods/"
#define CONFIGMENUS     "/etc/menu/"
#define PACKAGEMENUS    "/usr/lib/menu/"
#define MENUMENUS       "/usr/lib/menu/default/"
#define USERMENUS       ".menu/"
#define USERMETHODS     ".menu-methods/"

#define MENU1_INSTALLER "#!/usr/sbin/install-menu"

#define UPMEN_LOCKFILE  "/var/run/update-menus.pid"
#define DPKG_LOCKFILE   "/var/lib/dpkg/lock"
#define TRANSLATE_FILE  "/etc/menu-methods/translate_menus"
#define USERTRANSLATE   ".menu-methods/translate_menus"
#define CONFIG_FILE     "/etc/menu-methods/menu.config"
#define USERCONFIG      ".menu-methods/menu.config"


#define TRANSLATE_TRANS    "translate"
#define SUBSTITUTE_TRANS   "substitute"
#define SUBTRANSLATE_TRANS "subtranslate"
#define ENDTRANSLATE_TRANS "endtranslate"
class menuentry {
private:
  bool test_installed(String filename);
  bool check_install(parsestream &i);
  void  menuentry_constr_gccbug(parsestream &i);
public:
  map <String, String, less<String> > data;
  menuentry(parsestream &i, const String &);
  void output(vector<String> &s);
  void output_compat(vector<String> &s);
  ostream &debugoutput(ostream &o);
};



class trans_class{
protected:
  String match, replace, replace_var;
public:
  bool check(String &s);
  trans_class(const String &m,
	      const String &r,
	      const String &rv);
  
  virtual void process(menuentry &m,
		       const String &v)=NULL;
  String debuginfo();
};
class translate: public trans_class{
public:
  translate(const String &m,
	    const String &r,
	    const String &rv):trans_class(m,r,rv){};
  
  void process(menuentry &m,
	       const String &v);
};
class substitute: public trans_class{
public:
  substitute(const String &m,
	    const String &r,
	    const String &rv):trans_class(m,r,rv){};

  void process(menuentry &m,
	       const String &v);
};
class subtranslate: public trans_class{
public:
  subtranslate( String &m,
	    const String &r,
	    const String &rv):trans_class(m,r,rv){};

  void process(menuentry &m,
	       const String &v);
};

class translateinfo{
  typedef multimap<String, trans_class*, less<String> > trans_map;
  map<String, trans_map, less<String> > trans;
  //  map<String, multimap<String, trans_class*, less<String> >, less<String> > trans;
  void init(parsestream &i);
public:
  translateinfo(parsestream &i);
  translateinfo(const String &filename);
  void process(menuentry &m);
  void debuginfo();
};

class configinfo{
public:
  typedef enum {report_quiet,report_normal,report_verbose,report_debug} 
  verbosity_type;
private:
  class def_error{};
  typedef enum {method_stdout,method_stderr,method_syslog}
  method_type;

  
private:
  verbosity_type verbosity;
  method_type method;
  int syslog_facility, syslog_priority;
  void parse_def(const String &var, parsestream &p);
public:

  configinfo();
  void update(String filename);
  void report(const String &message,verbosity_type v);
  void set_verbosity(verbosity_type v){verbosity=v;};
  
};




