#include <stdio.h>
#include <newt.h>
#include <sys/sysmacros.h>
#include "dinstall.h"
#include "../busybox/internal.h"
#include "lang.h"

extern int configure_timezone(void);

static int require_swap (void) {
  if ( (swapon_partitions == NULL) &&
       (fdisk_partitions_by_type[FSTYPE_SWAP] == NULL) &&
       (noSwap == 0) ) {
    problemBox(MSG_NO_SWAP_PARTITION_L,MSG_NO_SWAP_PARTITION);
    return 1;
  }
  return 0;
}

static int update_cdrom_symlink (void) {
  struct stat statbuf;
  int pos;
  
  if ( (! stat(T_FILE("/dev/cdrom"),&statbuf) ) &&
       S_ISLNK((&statbuf)->st_mode) && 
       NAME_ISDIR(T_FILE("/target/dev"),&statbuf) ) {
    pos=readlink("/dev/cdrom",prtbuf,20);
    prtbuf[pos]='\0';
    symlink (prtbuf,"/target/dev/cdrom");
  }
  return 0;
}

#if #cpu (m68k)
static int update_fdisk_symlink (void) {
  char *target;

  /* determine target of symlink */
  if (strcmp(Arch2, "Atari") == 0)
	  target = "atari-fdisk";
  else if (strcmp(Arch2, "Amiga") == 0)
	  target = "amiga-fdisk";
  else if (strcmp(Arch2, "Macintosh") == 0)
	  target = "mac-fdisk";
  else
	  return -1;

  /* remove an existing /sbin/fdisk (ignore if not existed) */
  unlink(T_FILE("/target/sbin/fdisk"));
  symlink(T_FILE(target), T_FILE("/target/sbin/fdisk"));
  return 0;
}
#endif

#ifdef SERIAL_CONSOLE
static int
update_console_info (void)
{
  char *tty;
  int ttyline;
  int err = 0;
  FILE *F;
  /* serial console setup:
   *  1/ relink /dev/console to /dev/ttyS<n>
   *  2/ edit /target/etc/inittab to enable a T<n> line
   *  2b/ do the same thing with /target/etc/inittab.real
   *  3/ add ttyS<n> to /target/etc/securetty
   */
  tty = ttyname(0);
  if (tty && !strncmp(tty,"/dev/ttyS",9)) {
    ttyline = tty[9] - '0';
    /* 1 */
    unlink(T_FILE("/target/dev/console"));
    symlink(T_FILE(tty), T_FILE("/target/dev/console"));
    /* 2 */
    sprintf(prtbuf, "sed -e 's/^#T%d:/T%d:/' -e 's/^\\([1-6]\\):/#\\1:/' < %s > %s",
	ttyline, ttyline,
	T_FILE("/target/etc/inittab"),
	T_FILE("/target/etc/inittab.tmp"));
    if (system(prtbuf) ||
	rename(T_FILE("/target/etc/inittab.tmp"),T_FILE("/target/etc/inittab")))
    {
      problemBox("Error writing /target/etc/inittab ","Write error");
      return 1;
    }
    /* 2b */
    sprintf(prtbuf, "sed -e 's/^#T%d:/T%d:/' -e 's/^\\([1-6]\\):/#\\1:/' < %s > %s",
	ttyline, ttyline,
	T_FILE("/target/etc/inittab.real"),
	T_FILE("/target/etc/inittab.real.tmp"));
    if (system(prtbuf) ||
	rename(T_FILE("/target/etc/inittab.real.tmp"),T_FILE("/target/etc/inittab.real")))
    {
      problemBox("Error writing /target/etc/inittab.real ","Write error");
      return 1;
    }
    /* 3 */
    F=fopen(T_FILE("/target/etc/securetty"),"a");
    if (F) {
      err = fprintf(F,"%s\n",tty+5) <= 0;
      fclose(F);
    }
    else
      err = 1;
    if (err) {
      problemBox("Error writing /target/etc/securetty ","Write error");
      return 1;
    }
  }
  return 0;
}
#endif

static int write_fstab (void) {
  FILE *fstab;
  struct fdisk_partition *p;

  if (NULL==(fstab=fopen("/target/etc/fstab","w"))){
    problemBox(MSG_CANT_OPEN_FSTAB,MSG_WRITE_ERROR);
    return 1;
  }

  fprintf(fstab,
"# /etc/fstab: static file system information.
#
# <file system>	<mount point>	<type>	<options>		<dump>	<pass>
%s	/		ext2	defaults,errors=remount-ro   0      1\n",
  Root->name);

  if (swapon_partitions != NULL) {
    p = swapon_partitions;
    while (p) {
      fprintf(fstab,
        "%s               none            swap    sw          0       0\n",
        p->name);
      p=p->next_in_use;
    }
  }

  fprintf(fstab,
    "proc                /proc           proc    defaults    0       0\n");

  fclose(fstab);

  sprintf(prtbuf,
" < /etc/mtab sed -n '/target\\//p' | sed -e 's/target\\///' \
  -e 's/ 0 0/ 0 2/' -e 's/ rw / defaults /' >> /target/etc/fstab \
  2>/dev/null");
  if (system(prtbuf)) {
    problemBox(MSG_ERROR_WRITING_FSTAB,MSG_WRITE_ERROR);
    return 1;
  }
  return 0;
}

static int copy_default_keymap (void) {
  struct stat statbuf;
  char buff[30];
  FILE *kbdconf;
  if (! NAME_ISREG(T_FILE("/tmp/kbdconf"),&statbuf)) {
    problemBox(MSG_KBDCONF_DOESNT_EXIST,MSG_READ_ERROR);
    return 1;
  }
  if (NULL==(kbdconf=fopen("/tmp/kbdconf","r"))){
    problemBox(MSG_CANT_OPEN_KBDCONF,MSG_READ_ERROR);
    return 1;
  }
  if (NULL==fgets(buff,30,kbdconf)){
    problemBox(MSG_PROBLEMS_READING_KBDCONF,MSG_READ_ERROR);
    return 1;
  }
  fclose(kbdconf);
  if (! NAME_ISDIR(T_FILE("/target/etc/kbd"),&statbuf)) {
    struct FileInfo finfo;
    finfo.source = T_FILE("/target/etc/kbd");
    finfo.orWithMode = strtol("755", 0, 010);
    finfo.makeParentDirectories = 1;
    mkdir_fn(&finfo);
  }
  sprintf(prtbuf,"cp %s/%s.map.gz %s",T_FILE("/target/usr/share/keytables"),buff,
    T_FILE("/target/etc/kbd/default.map.gz")); 
  system(prtbuf);
  return 0;
}

int configure_base (void) {
  struct stat statbuf;

  if ( require_swap() ) return 1;

  if (! NAME_ISREG( T_FILE("/target/sbin/init"), &statbuf) ) {
    problemBox(MSG_BASE_NOT_INSTALLED_L,MSG_BASE_NOT_INSTALLED);
    return 1;
  }

  if ( write_fstab() ) return 1;

  if ( copy_default_keymap() ) return 1;

  configure_timezone();

  update_cdrom_symlink();

#if #cpu (m68k)
  update_fdisk_symlink();
#endif
	
#ifdef SERIAL_CONSOLE
  update_console_info();
#endif

  unlink(T_FILE("/target/sbin/unconfigured.sh"));

  return 0;
}

int configure_drivers (void) {
  struct stat statbuf;
#if #cpu (m68k)    
  char *arch2name;
#endif
  
  if (NAME_ISDIR(T_FILE("/lib/modules"),&statbuf) ) {
    rename(T_FILE("/lib/modules"),T_FILE("/lib/modules.old"));
  }
  unlink(T_FILE("/lib/modules"));
  chdir(T_FILE("/lib"));
  symlink("/target/lib/modules","modules");

  newtSuspend();
  system("depmod -a ; /target/usr/sbin/modconf "
	" --libdir /target/usr/lib/module_help --exclude-section pcmcia"
	" --run-shell cdromsymlink");
  newtResume();

  update_cdrom_symlink();

  /*
   * luisgh: if ran several times, this used to fail.
   *         I have changed this so that it always runs but only
   *         creates the dirs once.
   */
  if (! NAME_ISDIR(T_FILE("/target/etc/modutils"),&statbuf) ) {
    struct FileInfo finfo;
    finfo.source = T_FILE("/target/etc/modutils");
    finfo.orWithMode = strtol("755", 0, 010);
    finfo.makeParentDirectories = 1;
    mkdir_fn(&finfo);
  }
  
  chdir(T_FILE("/target/etc"));
  sprintf(prtbuf,"cp %s %s",T_FILE("/etc/modules"),T_FILE("modules"));
  system(prtbuf);
  unlink("conf.modules");
#if #cpu (m68k)    
  arch2name=strdup(Arch2);
  arch2name[0]|=32;
  if ( arch2name[0]=='m' ) arch2name[3]='\0';
  sprintf(prtbuf,"modutils/conf.m68k.%s",arch2name);
  symlink(prtbuf,"conf.modules");
  sprintf(prtbuf,"cp %s %s.%s",T_FILE("/etc/conf.modules"),
	  T_FILE("modutils/conf.m68k"),arch2name);
  free(arch2name);
#elif #cpu (i386)
  symlink("modutils/conf.i386","conf.modules");
  sprintf(prtbuf,"cp %s %s",
      T_FILE("/etc/conf.modules"),T_FILE("modutils/conf.i386"));
#else    
  symlink("modutils/conf.generic","conf.modules");
  sprintf(prtbuf,"cp %s %s",
      T_FILE("/etc/conf.modules"),T_FILE("modutils/conf.generic"));
#endif
  system(prtbuf);

  chdir(T_FILE("/"));
  return 0;
}
