#! /bin/bash

# Verbose shell execution.
# set -x
set -e

# Print a usage message and exit if the argument count is wrong.
if [ $# != 1 ]; then
echo "Usage: "$0" kbd-package" 1>&2
        cat 1>&2 << EOF

        kbd-package: the Debian package containing the keymaps.
EOF
        exit -1
fi

package=$1

export arch="`dpkg --print-architecture`"

case "$arch" in
m68k)
        export keymaps="atari-de.map.gz atari-se.map.gz atari-uk-falcon.map.gz atari-us.map.gz amiga-de.map.gz amiga-us.map.gz mac-us-std.map.gz mac-us-ext.map.gz"
	;;
sparc)
	export keymaps="sunkeymap.map.gz sunt4-es.map.gz sunt5-de-latin1.map.gz sunt5-es.map.gz sunt5-fi-latin1.map.gz sunt5-fr-latin1.map.gz sunt5-ru.map.gz"
	;;
*)
        export keymaps="azerty.map.gz be-latin1.map.gz bg.map.gz cf.map.gz cz-lat2.map.gz de-latin1-nodeadkeys.map.gz dk-latin1.map.gz dvorak.map.gz es.map.gz fi-latin1.map.gz fr-latin1.map.gz gr.map.gz hebrew.map.gz hu.map.gz is-latin1.map.gz it.map.gz jp106.map.gz no-latin1.map.gz pl.map.gz ru.map.gz se-latin1.map.gz slovene.map.gz tr_f-latin5.map.gz uk.map.gz us.map.gz"
	;;
esac

extractdir=/var/tmp/extract-tmp-$$
tmpdir=/var/tmp/tmp-$$
scriptdir=`pwd`/utilities/writemaps

rm -rf $extractdir
mkdir $extractdir

if [ ! -f $package ]; then
	echo "Unable to find kbd package: $package"
	return 1;
fi
dpkg-deb --extract $package $extractdir; \

if [ "$arch" = "m68k" ]; then
# The mac keytables aren't in kbd yet:
	cp ../mac-us* $extractdir/usr/share/keytables/
fi

# creating binary keymaps

rm -rf $tmpdir
mkdir $tmpdir

(cd $extractdir;
    for i in $keymaps; do
        j=`basename $i .map.gz`;
	echo $i;
	zcat usr/share/keytables/$i | $scriptdir/loadkeys -b > $tmpdir/$j\.bmap;
    done
)

rm -rf $extractdir

# creating keymaps.tgz

(cd $tmpdir;tar cf - *|gzip -9 ) > keymaps.tgz

rm -rf $tmpdir

ls -l keymaps.tgz
