#ifndef __VARS_H__
#define __VARS_H__

/*
 * vi:ts=4:sw=4:
 *
 * Project : "Linux Explorer"
 * Copyright 1996. All Rights Reserved.
 * 
 * $RCSfile: vars.h,v $
 *
 * $Revision: 1.4 $
 * 
 * $Author: ruben $ 
 * 
 * $Locker:  $
 * 
 * $State: Exp $
 * 
 * 
 * COPYRIGHT
 * =========
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * OVERVIEW
 * ========
 * 
 * $Log: vars.h,v $
 * Revision 1.4  1997/06/09 12:59:23  ruben
 * switched rcs commands again I think...
 * compiled with -Wall -Werror, fixed bugs and potential bugs
 * fixed Mister Data bugs
 *
 * Revision 1.3  1997/05/27  09:02:10  ruben
 * bumped array size for a new icon
 *
 * Revision 1.3  1997/05/27  09:02:10  ruben
 * bumped array size for a new icon
 *
 * Revision 1.2  1997/04/06 21:34:09  ruben
 * Added define for scan interval for new files in directories
 * it's called SCAN_INTERVAL and is set to 1 second
 *
 * Revision 1.1  1997/03/28 17:48:16  ruben
 * Initial revision
 *
 */

#include <qwindow.h>
#include <qpixmap.h>
#include <qpainter.h>
#include <qapp.h>
#include <qfont.h>

#ifndef PATH_MAX
#ifdef HAVE_LONG_FILE_NAMES
#  define PATH_MAX 1024
# else
#  define PATH_MAX 14
# endif	 /* HAVE_LONG_FILE_NAMES */
#endif	/* PATH_MAX */

#define NR_ICONS 34
#define LEFT      0
#define RIGHT     1

#define KERNEL_OK    0
#define KERNEL_PANIC 1

#define SCAN_INTERVAL	(1 * 1000)

extern QPixmap *pm[];

extern QPixmap *logo;

extern int font_size;

extern int pane;

extern QFont *adj_font;

extern char *home_dir;

extern int nr_objects;

extern unsigned long total_size;
extern unsigned long total_files;

extern char *home_path;
extern char *explore_path;

extern int x_wide;
extern int y_wide;

extern char target_directory [];
extern char source_directory [];

#endif	 // __VARS_H__
