/*
 * vi:ts=4:sw=4:
 *
 * Project : "Linux Explorer"
 * Copyright 1996. All Rights Reserved.
 * 
 * $RCSfile: dialogs.cpp,v $
 *
 * $Revision: 1.3 $
 * 
 * $Author: ruben $ 
 * 
 * $Locker:  $
 * 
 * $State: Exp $
 * 
 * 
 * COPYRIGHT
 * =========
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * OVERVIEW
 * ========
 * 
 * $Log: dialogs.cpp,v $
 * Revision 1.3  1997/06/09 12:59:23  ruben
 * switched rcs commands again I think...
 * compiled with -Wall -Werror, fixed bugs and potential bugs
 * fixed Mister Data bugs
 *
// Revision 1.2  1997/05/27  09:10:46  ruben
// As FPropDlg is modal, add a this pointer to its argument
//
// Revision 1.2  1997/05/27  09:10:46  ruben
// As FPropDlg is modal, add a this pointer to its argument
//
 * Revision 1.1  1997/03/28 17:04:14  ruben
 * Initial revision
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif	 // HAVE_CONFIG_H

#ifdef USE_RCS_ID
static const char rcs_id[] = "$Id: dialogs.cpp,v 1.3 1997/06/09 12:59:23 ruben Exp $";

#endif	 /* USE_RCS_ID */

#include <qlayout.h>
#include <qmlined.h>
#include <qbttngrp.h>
#include <qlistbox.h>
#include <qlabel.h>

#include <sys/stat.h>

#ifdef HAVE_SYS_PARAM_H
#include <sys/param.h>
#endif	 /* HAVE_SYS_PARAM_H */

#ifdef HAVE_SYS_MOUNT_H
#include <sys/mount.h>
#endif	 /* HAVE_SYS_MOUNT_H */

#include "diagnostic.h"
#include "dialogs.h"
#include "file_tool.h"

char    temp_file_path[512];

/*---------------------------------------------------------------------------*/
ConfigDialog::ConfigDialog(QWidget * parent,
			 const char *name):QTabDialog(parent,
										  name)
{
	QWidget *view_widget = new QWidget(this, 0);
	QWidget *type_widget = new QWidget(this, 0);
	QWidget *operation_widget = new QWidget(this, 0);
	QWidget *plugin_widget = new QWidget(this, 0);

	view_widget->setMinimumSize(320, 320);
	view_widget->setMaximumSize(320, 320);

	type_widget->setMinimumSize(320, 320);
	type_widget->setMaximumSize(320, 320);

	operation_widget->setMinimumSize(320, 320);
	operation_widget->setMaximumSize(320, 320);

	plugin_widget->setMinimumSize(320, 320);
	plugin_widget->setMaximumSize(320, 320);

//>--------------------------------------------------------

	QGroupBox *vis_box = new QGroupBox(view_widget, 0);

	vis_box->setTitle("Hidden files:");
	vis_box->setGeometry(10, 10, 300, 160);

	QButtonGroup *hidden_box = new QButtonGroup;

	QRadioButton *b1 = new QRadioButton(view_widget, 0);

	b1->setText("Show all files");
	b1->setGeometry(20, 30, 200, 20);

	b1->setChecked(TRUE);

	QRadioButton *b2 = new QRadioButton(view_widget, 0);

	b2->setText("Hide files of these types");
	b2->setGeometry(20, 50, 200, 20);

	hidden_box->insert(b1, -1);
	hidden_box->insert(b2, -1);

	QListBox *lb = new QListBox(view_widget, "listBox");

	lb->setGeometry(40, 80, 250, 80);
	QString str;

	str.sprintf("Hidden Files:");
	lb->insertItem(str);
	str.sprintf("config files (.*)");
	lb->insertItem(str);
	str.sprintf("symbolic links");
	lb->insertItem(str);
	str.sprintf("block devices");
	lb->insertItem(str);
	str.sprintf("charakter devices");
	lb->insertItem(str);
	str.sprintf("sockets");
	lb->insertItem(str);

	QCheckBox *display_path = new QCheckBox("Display full path in title bar",
											view_widget,
											"dummy");

	display_path->setGeometry(10, 180, 320, 20);
	display_path->setChecked(TRUE);

	QCheckBox *toolb = new QCheckBox("Show Toolbar",
									 view_widget,
									 "dummy");

	toolb->setGeometry(10, 210, 320, 20);

	QCheckBox *fileb = new QCheckBox("Show File/Directory info",
									 view_widget,
									 "dummy");

	fileb->setGeometry(10, 240, 320, 20);

	QCheckBox *statusb = new QCheckBox("Show Status Bar",
									   view_widget,
									   "dummy");

	statusb->setGeometry(10, 270, 320, 20);

	QCheckBox *plugin_fr = new QCheckBox("Show Plugin Frame/Console",
										 view_widget,
										 "dummy");

	plugin_fr->setGeometry(10, 300, 320, 20);

//>--------------------------------------------------------

	QListBox *lb2 = new QListBox(type_widget, "listBox");

	lb2->setGeometry(10, 20, 200, 160);
	str.sprintf("Text files (.txt)");
	lb2->insertItem(str);
	str.sprintf("Netscape (.htm / .html)");
	lb2->insertItem(str);
	str.sprintf("Vrml (.wrl)");
	lb2->insertItem(str);

	QPushButton *new_type = new QPushButton(type_widget, "new1");

	new_type->setText("New Type");
	new_type->setGeometry(225, 20, 85, 25);

	QPushButton *remove = new QPushButton(type_widget, "new1");

	remove->setText("Remove");
	remove->setGeometry(225, 50, 85, 25);

	QPushButton *edit = new QPushButton(type_widget, "new1");

	edit->setText("Edit");
	edit->setGeometry(225, 80, 85, 25);

	QGroupBox *mime_box = new QGroupBox(type_widget, 0);

	mime_box->setTitle("File type details");
	mime_box->setGeometry(10, 190, 300, 140);

//>--------------------------------------------------------

	QCheckBox *joop = new QCheckBox("Enable 'Joop Manouevre' (don't ask just do it)", operation_widget, 0);

	joop->setGeometry(10, 10, 300, 20);

	QCheckBox *select = new QCheckBox("Remove files from source selection automaticly", operation_widget, 0);

	select->setGeometry(10, 35, 300, 20);

//>--------------------------------------------------------

	setCancelButton();
	setApplyButton();

	addTab(view_widget, "View");
	addTab(type_widget, "File Types");
	addTab(operation_widget, "Operations");
	addTab(plugin_widget, "Plugins");
}
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
HelpFrame::HelpFrame(QWidget * parent = 0,
		  const char *name = 0):QMultiLineEdit(parent,
											   name)
{
	FILE   *help_file;
	char    letter;
	int     i;

	setText("Until the help file is complete, \nthe README file will be displayed\n\n");
	setReadOnly(TRUE);

	sprintf(temp_file_path, "%s/README", explore_path);

	help_file = fopen(temp_file_path, "r");
	if (help_file == NULL)
	{
		printf("Unable to open Help file [%s]\n", temp_file_path);
	}

	i = 0;
	letter = fgetc(help_file);
	while (!feof(help_file))
	{

		if ((letter != '\n') /* &&  (letter != EOF) always true */)
		{
			temp_file_path[i] = letter;
			i++;
		}
		else
		{
			temp_file_path[i] = 0;
			insertLine(temp_file_path);
			i = 0;
		}

		letter = fgetc(help_file);
	}

	fclose(help_file);
}
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
DfDialog::DfDialog(QWidget * parent = 0,
		 const char *name = 0):QDialog(parent, name)
{
	setMinimumSize(200, 200);
	setMaximumSize(200, 200);
}
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
AboutFrame::AboutFrame(QWidget * parent = 0,
		   const char *name = 0):QFrame(parent,
										name)
{
	setMaximumSize(logo->width(), logo->height());
	setMinimumSize(logo->width(), logo->height());

	setBackgroundPixmap(*logo);

	QPushButton *ok_button = new QPushButton("OK", this, "dummy_name");

	ok_button->setGeometry(190,
						   150,
						   105,
						   25);

	connect(ok_button, SIGNAL(clicked()), this, SLOT(close_dialog()));

	setCaption("About " EXPLORER_MACHNAME " Explorer");
}
/*---------------------------------------------------------------------------*/
void    AboutFrame::close_dialog()
{
//	delete(this);
}
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
LinkFrame::LinkFrame(QWidget * parent = 0,
		  const char *name = 0,
		  char *temp_name = 0):QFrame(parent,
									  name)
{

	source_name = temp_name;

	// first remove trailing slashes :)
	if (source_name[strlen(source_name) - 1] == '/')
		source_name[strlen(source_name) - 1] = 0;

	setMaximumSize(320, 170);
	setMinimumSize(320, 170);

	// create se contreuls :) , had to recreate these from delete sources :(

	QLabel *source_label1 = new QLabel("Create a Link from:", this, NULL);

	source_label1->move(10, 8);
	source_label1->resize(300, 17);

	QLabel *source_label2 = new QLabel(temp_name, this, NULL);

	source_label2->setFrameStyle(QFrame::WinPanel|QFrame::Sunken);
	source_label2->move(10, 27);
	source_label2->resize(300, 17);

	QLabel *target_label1 = new QLabel("To:", this, NULL);

	target_label1->move(10, 46);
	target_label1->resize(300, 17);

	target_label2 = new QLineEdit(this, NULL);
	target_label2->move(10, 65);
	target_label2->resize(300, 17);

	connect(target_label2,
			SIGNAL(returnPressed()),
			this,
			SLOT(do_link()));

	// >------ choose a link type

	QGroupBox *link_type = new QGroupBox(this, 0);

	link_type->setTitle("Link Type:");
	link_type->setGeometry(10, 90, 300, 40);

	QButtonGroup *hidden_box = new QButtonGroup;

	softlink = new QRadioButton(this, "dummy");
	softlink->setChecked(TRUE);
	softlink->setText("Create a softlink");
	softlink->setGeometry(45, 105, 120, 20);

	hardlink = new QRadioButton(this, "dummy");
	hardlink->setText("Create a hardlink");
	hardlink->setGeometry(180, 105, 120, 20);

	// >------ just some buttons

	hidden_box->insert(softlink, -1);
	hidden_box->insert(hardlink, -1);

	QPushButton *ok = new QPushButton(this, "ok");

	ok->setText("Ok");
	ok->setGeometry(70, 135, 85, 25);

	QPushButton *cancel = new QPushButton(this, "cancel");

	cancel->setText("Cancel");
	cancel->setGeometry(180, 135, 85, 25);

	connect(ok,
			SIGNAL(clicked()),
			this,
			SLOT(do_link()));

	connect(cancel,
			SIGNAL(clicked()),
			this,
			SLOT(close_dialog()));
}
/*---------------------------------------------------------------------------*/
void    LinkFrame::close_dialog()
{
	// delete(this);
}
/*---------------------------------------------------------------------------*/
void    LinkFrame::do_link()
{
	int     return_val;

	if (target_label2->text() == NULL)
	{
		QMessageBox::message("Link Error:",
				"You have to specify a name !!",
				"Ok");
		return;
	}

	if (softlink->isChecked() == TRUE)
		return_val = symlink(source_name, target_label2->text());
	else
		return_val = link(source_name, target_label2->text());

	if (return_val != 0)
		validate_sys_error();

	close_dialog();
}
/*---------------------------------------------------------------------------*/

							  // Info Labels \\

/*---------------------------------------------------------------------------*/
ObjectFrame::ObjectFrame(QWidget * parent, const char *name):QFrame(parent, name)
{
	frame_text = NULL;
	old_frame_text = NULL;

	frame_text = new char[512];
	old_frame_text = new char[512];

	strcpy(frame_text, "0 Object(s)");
	strcpy(old_frame_text, " ");

	setFrameStyle(QFrame::Panel|QFrame::Sunken);
	setMinimumSize( 200, 18);
	setMaximumSize(4200, 18);
}
/*---------------------------------------------------------------------------*/
ObjectFrame::~ObjectFrame()
{
	if (frame_text != NULL)
		delete  frame_text;

	if (old_frame_text != NULL)
		delete  old_frame_text;
}
/*---------------------------------------------------------------------------*/
void    ObjectFrame::paintEvent(QPaintEvent * e)
{
	QPainter paint;
	QPen    paint_text(QColor(0, 0, 0), 0, SolidLine);
	QPalette *system_pal = qApp->palette();

	e = e;

	paint.begin(this);

	paint.setPen(paint_text);
	paint.drawText(5, 14,
				   frame_text, strlen(frame_text));

	qDrawShadePanel(&paint, 0, 0,
					width(), height(),
					system_pal->normal(), TRUE, 1, NULL);
	paint.end();
}
/*---------------------------------------------------------------------------*/
void    ObjectFrame::set_objects(int nr_objects)
{
	sprintf(frame_text, "%d Object(s)", nr_objects);
	if (strcmp(frame_text, old_frame_text) != 0)
	{
		strcpy(old_frame_text, frame_text);
		update();
	}
}
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
DirectoryFrame::DirectoryFrame(QWidget * parent, const char *name):QFrame(parent, name)
{
	frame_text = NULL;
	old_frame_text = NULL;

	frame_text = new char[512];
	old_frame_text = new char[512];

	strcpy(frame_text, "Contents of '/'");
	strcpy(old_frame_text, " ");

	setFrameStyle(QFrame::Panel|QFrame::Sunken);
	setMinimumSize(200, 20);
	setMaximumSize(4200, 20);
}
/*---------------------------------------------------------------------------*/
DirectoryFrame::~DirectoryFrame()
{
	if (frame_text != NULL)
		delete  frame_text;

	if (old_frame_text != NULL)
		delete  old_frame_text;
}
/*---------------------------------------------------------------------------*/
void    DirectoryFrame::paintEvent(QPaintEvent * e)
{
	QPainter paint;
	QPen    paint_text(QColor(0, 0, 0), 0, SolidLine);
	QPalette *system_pal = qApp->palette();

	e = e;

	paint.begin(this);

	paint.setPen(paint_text);
	paint.drawText(5, 14,
				   frame_text, strlen(frame_text));

	qDrawShadePanel(&paint, 0, 0,
					width(), height(),
					system_pal->normal(), TRUE, 1, NULL);
	paint.end();
}
/*---------------------------------------------------------------------------*/
void    DirectoryFrame::set_text(const char *new_text)
{
	sprintf(frame_text, "Contents of '%s'", new_text);
	if (strcmp(frame_text, old_frame_text) != 0)
	{
		strcpy(old_frame_text, frame_text);
		update();
	}
}
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
FileFrame::FileFrame(QWidget * parent, const char *name):QFrame(parent, name)
{
	frame_text = NULL;
	old_frame_text = NULL;

	frame_text = new char[512];
	old_frame_text = new char[512];

	strcpy(frame_text, "0 File(s) Bytes");
	strcpy(old_frame_text, " ");

	setFrameStyle(QFrame::Panel|QFrame::Sunken);
	setMinimumSize(200, 18);
	setMaximumSize(4200, 18);
}
/*---------------------------------------------------------------------------*/
FileFrame::~FileFrame()
{
	if (frame_text != NULL)
		delete  frame_text;

	if (old_frame_text != NULL)
		delete  old_frame_text;
}
/*---------------------------------------------------------------------------*/
void    FileFrame::paintEvent(QPaintEvent * e)
{
	QPainter paint;
	QPen    paint_text(QColor(0, 0, 0), 0, SolidLine);
	QPalette *system_pal = qApp->palette();

	e = e;

	paint.begin(this);

	paint.setPen(paint_text);
	paint.drawText(5, 14,
				   frame_text, strlen(frame_text));

	qDrawShadePanel(&paint, 0, 0,
					width(), height(),
					system_pal->normal(), TRUE, 1, NULL);
	paint.end();
}
/*---------------------------------------------------------------------------*/
void    FileFrame::set_info(int nr_objects, unsigned long total_size)
{
	/* 
	 * float temp_size; 
	 * 
	 * if (total_size>(1024*1024)) { temp_size=total_size/(1024*1024); sprintf (frame_text, "%d File(s) %fM", nr_objects,
	 * temp_size); } else { if (total_size>1024) { temp_size=total_size/1024; sprintf (frame_text, "%d File(s) %fK", nr_objects,
	 * temp_size); } else sprintf (frame_text, "%d File(s) %ld Bytes", nr_objects, total_size); } */

	sprintf(frame_text,
			"%d File(s) %ld Bytes",
			nr_objects,
			total_size);

	if (strcmp(frame_text, old_frame_text) != 0)
	{
		strcpy(old_frame_text, frame_text);
		update();
	}
}
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
OptionsPopup::OptionsPopup(QWidget * parent,
			 char *name):QPopupMenu(parent,
									name)
{
	insertItem("New Directory", this, SLOT(new_dir()));
	insertSeparator();
	insertItem("Create link", this, SLOT(create_link()));
	insertItem("Delete", this, SLOT(delete_entry()));
	insertSeparator();
	insertItem("Properties", this, SLOT(properties()));

	node_used = NULL;
	multiple_entries = FALSE;
}
/*---------------------------------------------------------------------------*/
void    OptionsPopup::set_multiple_entries(char new_selection)
{
	multiple_entries = new_selection;
}
/*---------------------------------------------------------------------------*/
void    OptionsPopup::new_dir()
{

}
/*---------------------------------------------------------------------------*/
void    OptionsPopup::create_link()
{
	emit    emit_link(path_to_node);
}
/*---------------------------------------------------------------------------*/
void    OptionsPopup::delete_entry()
{
	if (multiple_entries == FALSE)
	{
		emit    emit_delete(path_to_node, node_used);
	}
	else
	{
		emit    emit_delete_nodes();
	}
}
/*---------------------------------------------------------------------------*/
void    OptionsPopup::change_properties(const char *old_pth,
										const char *new_pth)
{
	if (old_pth)
		emit    emit_prop_change(old_pth, new_pth, node_used);
}
/*---------------------------------------------------------------------------*/
void    OptionsPopup::properties()
{
	// >------ remove trailing slashes :)

	// TODO: track them all!
	// class PropertiesTracker will do this
	// PropertiesTracker should be member of the main explorer widget :)
	// PropertiesTracker is an instance of a QList<FPropdlg>

	if (multiple_entries == TRUE)
	{
		QMessageBox::message("Question:",
				"You can not change the properties of multiple entries.\n" \
				"Do you want to change the properties of the entry\n" \
				"you clicked on?\n",
				"Ok");
	}

	path_to_node[strlen(path_to_node) - 1] = 0;

	FPropdlg *temp_dialog = new FPropdlg(path_to_node,this);

	connect(temp_dialog,
			SIGNAL(propertiesChanged(const char *, const char *)),
			this,
			SLOT    (change_properties(const char *, const char *)));

	temp_dialog->show();
}
/*---------------------------------------------------------------------------*/
void    OptionsPopup::assign_node(FileTreeNode * use_node,
								  char *temp_path)
{
	node_used = use_node;
	path_to_node = new char[strlen(temp_path) + 1];

	strcpy(path_to_node, temp_path);
}
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
OperationPopup::OperationPopup(QWidget * parent,
			   char *name):QPopupMenu(parent,
									  name)
{
	insertItem("Cancel ", this, SLOT(cancel()));
	insertSeparator();
	insertItem("move ", this, SLOT(move_files()));
	insertItem("copy ", this, SLOT(copy_files()));

	node_used = NULL;
}
/*---------------------------------------------------------------------------*/
void    OperationPopup::cancel()
{
	emit    op_cancel(FALSE);
}
/*---------------------------------------------------------------------------*/
void    OperationPopup::move_files()
{
	emit    op_move(FALSE);
}
/*---------------------------------------------------------------------------*/
void    OperationPopup::copy_files()
{
	emit    op_copy(FALSE);
}
/*---------------------------------------------------------------------------*/
void    OperationPopup::assign_node(FileTreeNode * use_node,
									char *temp_path)
{
	node_used = use_node;
	path_to_node = new char[strlen(temp_path) + 1];

	strcpy(path_to_node, temp_path);
}
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
MountEntry::MountEntry(const char *visualentry, const char *device, const char *mountpoint)
{
	if (visualentry && device && mountpoint)
	{
		szTotal_path = new QString(visualentry);
		szMount_device = new QString(device);
		szMount_point = new QString(mountpoint);
	}
}
/*---------------------------------------------------------------------------*/
MountEntry::MountEntry(const MountEntry & entry)
{
	if (this != &entry)
	{
		szTotal_path = new QString(*entry.szTotal_path);
		szMount_device = new QString(*entry.szMount_device);
		szMount_point = new QString(*entry.szMount_point);
	}
}
/*---------------------------------------------------------------------------*/
MountEntry::~MountEntry()
{
	delete  szTotal_path;
	delete  szMount_device;
	delete  szMount_point;
}
/*---------------------------------------------------------------------------*/
MountList::MountList()
{
	setAutoDelete(TRUE);
}
/*---------------------------------------------------------------------------*/
int     MountList::compareItems(GCI item1, GCI item2)
{
	return strcmp(*(((MountEntry *) item1)->szMount_point), *(((MountEntry *) item2)->szMount_point));
}
/*---------------------------------------------------------------------------*/
GCI     MountList::newItem(GCI item)
{
	MountEntry *copy = NULL,
	       *entry = (MountEntry *) item;

	if (entry)
		copy = new MountEntry(*entry);

	return copy;
}
/*---------------------------------------------------------------------------*/
void    MountList::deleteItem(GCI item)
{
	MountEntry *entry = (MountEntry *) item;
	delete  entry;
}
/*---------------------------------------------------------------------------*/
MountBox::MountBox(QWidget * parent,
		 const char *name):QComboBox(parent,
									 name)
{
	connect(this,
			SIGNAL(activated(int)),
			SLOT    (choose_item(int)));
}
/*---------------------------------------------------------------------------*/
void    MountBox::choose_item(int the_chosen_one)
{
	if (!spMountList.isEmpty())
		emit    goto_mount_point(*(spMountList.at(the_chosen_one)->szMount_point));
}
/*---------------------------------------------------------------------------*/

void    MountBox::getMountedfss()
{
	// to flicker or not to flicker ????
	// We'll see.. RvS
	clear();
	spMountList.clear();
	show_mount(this);
}

bool    MountBox::remove_item(const char* /* *szMountpoint (not used) */ )		// give mountpoint, not device
{
	return TRUE;
}
/*---------------------------------------------------------------------------*/
void    MountBox::unmount()
{
	// first find out what to unmount

	// 97032.9 Rvs note: BSD 4.4 allows anyone (who has write permissions)
	// to do a (un)mount. hoppefully linux (SVr4) works that way too :)
	// I'll change this to reflect that behaviour

	if (currentItem() == 0)
	{
		QMessageBox::message("unmount error", "Can't unmount root filesystem!\n", "Sorry!");
	}
	else
	{
		// well let's give it a try

//		printf("current item: %d\n", currentItem());
//		printf("Unmounting: [%s]\n", (const char *) *(spMountList.at(currentItem())->szMount_point));

#ifdef HAVE_UNMOUNT
	  if (::unmount(*(spMountList.at(currentItem())->szMount_point), MNT_FORCE) != -1)
		{
			spMountList.remove(currentItem());
			removeItem(currentItem());
			setCurrentItem(0);
			emit    goto_mount_point(*(spMountList.at(0)->szMount_point));
		}
		else
		{
			QMessageBox::message("unmount", strerror(errno), "Ok");
		}
#elif defined(HAVE_UMOUNT)
	  if (::umount(*(spMountList.at(currentItem())->szMount_point)) != -1)
		{
			spMountList.remove(currentItem());
			removeItem(currentItem());
			setCurrentItem(0);
			emit    goto_mount_point(*(spMountList.at(0)->szMount_point));
		}
		else
		{
			QMessageBox::message("umount", strerror(errno), "Ok");
		}
#else
		QMessageBox::message("unmount", "No unmount call on this system!\nCall techsupport\nstaveren@ronix.ptf.hro.nl", "Ok");
#endif	 /* HAVE_UNMOUNT */
	}
}
/*---------------------------------------------------------------------------*/
void    MountBox::add_item(char *total_string,
						   char *device_temp,
						   char *mount_point_temp)
{
	MountEntry spMountEntry(total_string, device_temp, mount_point_temp);

	insertItem(total_string, -1);	// first update the real combobox

	spMountList.append(&spMountEntry);

}
/*---------------------------------------------------------------------------*/
