#ifndef _RVS_QT_CPD_H_
#define _RVS_QT_CPD_H_

#include <qwidget.h>
#include <qlabel.h>
#include <qfile.h>
#include <qdialog.h>
#include <qstrlist.h>
class QTimer;
class QProgressCtrl;
class QString;
class QStrList;
class CopyProgressWidget;

class CopyProgressDlg: public QDialog
{
	Q_OBJECT

	QTimer * spTimer;
	QStrList *szSources,
	       *szDestinations;
	QStrListIterator *Sources,
	       *Destinations;
	CopyProgressWidget *widget;

	private slots:

	void    tryStart();
	void    doStuff();

	public:

	CopyProgressDlg(const QStrList & szSources_arg, const QString & szDestination_arg, QWidget * parent = 0, const char *name = 0);
	~CopyProgressDlg();

};

class CopyProgressWidget: public QLabel
{
	Q_OBJECT

	QFile	in, 
			out;

	QTimer			*spTimer;
	QProgressCtrl	*spProgress;
	QLabel 			*spBusyText;
	
	QString	szInname,
			szOutname;
	
	unsigned int uiMyBuffersize;
	char *cBuffer;
	bool bBusy;
	
	void setup_gui();

	public:

	CopyProgressWidget(QWidget *parent=0, const char *name=0);

	QString getSource();
	QString getDestination();

	int setBuffersize(unsigned int uiBuffersize);

	public slots:
	
	void abort();
	void start();
	void setSource(const char* szSource);
	void setDestination(const char*szDestination);
	
	private slots:
	
	void copyfile();
	
	signals:
	
	void completed();
	void failed(int);
	void sourceChanged(const char *);
	void destinationChanged(const char *);
};
#endif // _RVS_QT_CPD_H_
