// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifndef _StyleSheetManager_h_
#define _StyleSheetManager_h_

#include <qlist.h>
#include <qobject.h>
#include <qstring.h>
#include "StyleSheet.h"

class Request;

class StyleSheetReceiver {
public:
    virtual void styleSheet( StyleSheet* styleSheet ) = 0;
};

class StyleSheetManager : public QObject {
    Q_OBJECT

    struct Receiver {
        StyleSheetReceiver* receiver;
        QString             soi;
        StyleSheet*         styleSheet;
        Receiver( StyleSheetReceiver* _receiver, QString _soi )
                : receiver( _receiver ), soi( _soi ), styleSheet( 0 ) {}
    };

    struct StyleSheetRequest {
        Request*    request;
        StyleSheet* styleSheet;
        QString     soi;
        StyleSheetRequest( Request* _request, StyleSheet* _styleSheet, QString _soi )
                : request( _request ), styleSheet( _styleSheet ), soi ( _soi ) {}
    };

    StyleSheet* findStyleSheet( const QString& soi );
    
    QList<StyleSheet>        _styleSheets;
    QList<Receiver>          _receivers;
    QList<StyleSheetRequest> _requests;
public:
    StyleSheetManager();

    ~StyleSheetManager();

    void request( StyleSheetReceiver* receiver, QString doctype, QString id );

    void requestBySOI( StyleSheetReceiver* receiver, QString soi );

    void clear();

    StyleSheet* find( QString styleSheetName );
public slots:
    void done( StyleSheet* styleSheet );
signals:
    void styleSheetReady( StyleSheet* styleSheet );
};

extern StyleSheetManager* styleSheetManager;

#endif
