// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifndef _ListBoxRenderer_h_
#define _ListBoxRenderer_h_

#include <qstrlist.h>
#include "FormObjectRenderer.h"

class QListBox;

//: The ListBoxRenderer class provides a QListBox that can be embedded in an HTML form.
class ListBoxRenderer : public FormObjectRenderer {
    Q_OBJECT
    QListBox* _listBox;
    QStrList  _values;
    int       _selected;
public:
    ListBoxRenderer( int         size,
                     Canvas*     canvas,
                     int         clipWidth=0,
                     QObject*    parent=0,
                     const char* name=0 );

    //. Add an item to the list box.  If no value is given then the text will
    //. be used as the item's value.
    void addItem( const char* text, bool selected, const char* value );

    //. A value is returned only if the list box has a name.  Otherwise, an
    //. empty string is returned.
    QString value();

    void reset();

    //. Resize the list box to fit its contents.
    bool redraw();
public slots:
    //. Do nothing.
    void endOfData();
};

#endif
