// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifndef _FileConn_h_
#define _fileConn_h_

#include "Connection.h"

//: The FileConn class provides a connection type for reading data from local files.
class FileConn : public Connection {
    Q_OBJECT
    bool _firstRead;
public:
    //. Create a new file connection.
    FileConn( const Url& url );

    //. Open the named file for reading.
    virtual bool open();
public slots:
    //. Process notification from the Poller that the file is readable.  Read
    //. some data and forward it with the data() signal.
    virtual void readable();
signals:
    //. Emitted as data is read from the file.
    virtual void data( const char* bytes, int length );

    //. Emitted when the end of file is reached.
    virtual void endOfData();

    //. Emit a signal with the Internet media type and total size of the data
    //. stream.
    virtual void startOfData( QString mediaType, QString mediaSubtype, int totalSize );
};

#endif
