// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifndef _BrowserList_h_
#define _BrowserList_h_

extern "C"
{
#include <stdlib.h>
}
#include <qlist.h>
#include <qobject.h>

class Browser;

//: The BrowserList class keeps track of all the open browser windows.
//. The BrowserList maintains a list of all open browser windows.  This list is
//. used to determine whether a browser is allowed to be closed.  Any browser
//. can exit the application, but a browser can only close itself if there is
//. at least one other open browser.  Otherwise, the last browser could close
//. itself, and the application would continue to run (but not do anything
//. interesting ;)
class BrowserList : public QObject {
    Q_OBJECT
    QList<QObject> _browsers;
public:
    //. Make g++ happy.
    ~BrowserList();
    
    //. When a new browser is created, it registers itself with this function
    //. call.
    void browserOpened( Browser* browser );
public slots:
    //. Process a close signal from a browser.  The browser is determined by
    //. looking at the sender of the signal.
    void browserClosed();
signals:
    //. This signal is emitted whenever a browser is added to or removed from
    //. the list of open browsers.  "b" is TRUE if there are at least 2 browsers
    //. in the list.
    void canClose( bool b );
};

extern BrowserList* browserList;

#endif
