/* This file is part of
 * ======================================================
 * 
 *           LyX, The Document Processor
 * 	 
 *	    Copyright (C) 1995 Matthias Ettrich
 *          Copyright (C) 1995-1998 The LyX Team.
 *
 *======================================================*/

#include <config.h>
#include FORMS_H_LOCATION
#include "lyx_main.h"
#include "gettext.h"
#include "LString.h"
#include "filetools.h"

// 	$Id: main.C,v 1.19 1998/02/03 18:53:22 larsbj Exp $	

#if !defined(lint) && !defined(WITH_WARNINGS)
static char vcid[] = "$Id: main.C,v 1.19 1998/02/03 18:53:22 larsbj Exp $";
#endif /* lint */

// I keep these here so that it will be processed as early in
// the compilation process as possible.
#if !defined(FL_REVISION) || (FL_REVISION != 81 && FL_REVISION != 86 &&\
			      FL_REVISION != 87 && FL_REVISION != 88) \
			  || FL_VERSION != 0
#error LyX will not compile with this version of XForms.\
       Please get version 0.88 (0.81 and 0.86 also work).\
       If you want to try to compile anyway, delete this test in src/main.C.
#endif


int main(int argc, char *argv[])
{
	// lyx_localedir is used by gettext_init() is we have
	//   i18n support built-in
	LString lyx_localedir = getEnvPath("LYX_LOCALEDIR");
	if (lyx_localedir.empty())
		lyx_localedir = LOCALEDIR;
	
	// initialize for internationalized version *EK*
	locale_init();
	gettext_init();

	LyX lyx(&argc,argv);
	return 0; // ok
}
