/* This file is part of
 * ======================================================
 * 
 *           LyX, The Document Processor
 * 	 
 *	    Copyright (C) 1995 Matthias Ettrich
 *          Copyright (C) 1995-1998 The LyX Team.
 *
 *======================================================*/

#include <config.h>


#ifdef __GNUG__
#pragma implementation
#endif

#include "insetlatexdel.h"
#include "lyxdraw.h"
#include "error.h"

// 	$Id: insetlatexdel.C,v 1.26 1998/01/29 12:52:50 larsbj Exp $	

#if !defined(lint) && !defined(WITH_WARNINGS)
static char vcid[] = "$Id: insetlatexdel.C,v 1.26 1998/01/29 12:52:50 larsbj Exp $";
#endif /* lint */

/* LatexDel. Used to insert Latex-Code automatically */

InsetLatexDel::InsetLatexDel()
{
}


InsetLatexDel::InsetLatexDel(LString const & string)
	: contents(string)
{
}


InsetLatexDel::~InsetLatexDel()
{
}


int InsetLatexDel::Ascent(LyXFont const &font) const
{
	return font.maxAscent()+1;
}


int InsetLatexDel::Descent(LyXFont const &font) const
{
	return font.maxDescent()+1;
}


int InsetLatexDel::Width(LyXFont const &font) const
{
	return 6 + font.stringWidth(contents);
}


void InsetLatexDel::Draw(LyXFont font, LyXScreen &scr,
			 int baseline, float &x)
{
	// Draw it as a box with the LaTeX text

	x += 1;

	//scr.drawFilledRectangle(int(x), baseline - Ascent(font)+1,
	//	     Width(font)-2, Ascent(font)+Descent(font)-2,
	//	     FL_GRAY80);
	scr.fillRectangle(gc_lighted, int(x), baseline - Ascent(font)+1,
			  Width(font)-2, Ascent(font)+Descent(font)-2);
	//scr.drawRectangle(int(x), baseline-Ascent(font)+1,
	//	     Width(font)-2, Ascent(font)+Descent(font)-2,
	//	     FL_RED);
	scr.drawRectangle(gc_foot, int(x), baseline-Ascent(font)+1,
			  Width(font)-2, Ascent(font)+Descent(font)-2);
	// Red text
	font.setColor(LyXFont::RED);
	scr.drawString(font, contents, baseline, int(x+2));
	x +=  Width(font) - 1;
}


void InsetLatexDel::Write(FILE *file)
{
	fprintf(file, "LatexDel %s\n", contents.c_str());
}


void InsetLatexDel::Read(LyXLex &lex)
{
	if (lex.EatLine()) {
		contents = lex.GetString();
	} else
		lex.printError("InsetLatexDel: Parse error: `$$Token'");
}


int InsetLatexDel::Latex(FILE *file, signed char /*fragile*/)
{
	fprintf(file, "%s", contents.c_str());
	return 0;
}


int InsetLatexDel::Latex(LString &file, signed char /*fragile*/)
{
	file += contents;
	return 0;
}


bool InsetLatexDel::Deletable() const
{
	return true;
}


Inset* InsetLatexDel::Clone()
{
	InsetLatexDel *result = new InsetLatexDel(contents);
	return result;
}


Inset::Code InsetLatexDel::LyxCode() const
{
	if (contents == "\\label{") return Inset::MARK_CODE;
	if (contents == "\\ref{") return Inset::REF_CODE;
	if (contents == "\\url{") return Inset::URL_CODE;
	if (contents == "\\htmlurl{") return Inset::HTMLURL_CODE;
	if (contents == "}{") return Inset::SEPARATOR_CODE;
	if (contents == "}") return Inset::ENDING_CODE;
	return Inset::NO_CODE;
}
