/*  Light-weight streams.
    These are meant to be used with the same syntax as the C++ streams
    classes, but are much more economical.  (Use of iostreams makes the
    executable files much bigger, e.g., over 300K on UNIX.)

    Author: John Collins, collins@phys.psu.edu.
    22 Jan 96

    (C) John Collins & Penn State University.
*/

#include <stdio.h>

// Flag that I've been included:
#define SOS_H

// ============== Standard streams:
class sos;
extern sos lite_cout, lite_cerr;



/* ==================== class sos ========================
   "sos" means "Simple_ostream".
   It is used for output files that have already been opened,
   e.g., stdout.
   Note that assignment works.  E.g.,
      sos oldf(stderr);
      sos newf = oldf;
      sos newf1;
      newf1 = oldf;
   At present, this is done by C++'s implicitly generated copy constructor,
   which just copies the data members of the object, i.e., the pointer myfile.
*/
class sos {

   protected:
      FILE* myfile;

   public:
      sos(){
         // For debugging, to show how many constructors are called.
         // fprintf (stderr, "=== Opening an sos().\n");
         myfile=NULL;
      }
      sos(FILE * already_open_FILE);
      virtual ~sos();

      inline int IsOpen() { return (myfile != NULL);}

      virtual void flush();

      int bad() {return ferror(myfile);}
      sos & put(char);
      sos & write(const char *string, int length);

      sos & operator <<(char*);
         // Write the string to the stream
      sos & operator <<(char);
         // Write the character to the stream
      sos & operator <<(int);
         // Write a string representation of the integer to the stream
//      sos & sos::operator << (sos &(*manipulator)(sos &));
      sos & sos::operator << ( void manipulator(sos &));
         // For manipulators

      void endl ();
         // Writes end-of-line, and flushes the file.
};

void endl (sos & f);
void flush (sos & f);



/* ==================== class fsos ========================
   This is sos with means to open named files and close them.
   Note that assignment works.  E.g.,
      fsos oldf("FILENAME");
      sos  newf = oldf;
      fsos newfsos = newf
      sos newf1;
      newf1 = oldf;
   At present, this is done by C++'s implicitly generated copy constructor,
   which just copies the data members of the object, i.e., the pointer myfile.
*/
class fsos : public sos {
   public:
      fsos (char * filename);
        // Just open the file
      virtual int open (char *filename);
        /* Open the file.
           Return 0 if successful, 0 otherwise.
           Error (e.g., file doesn't exist) => myfile = NULL,
           so that IsOpen() returns 0.
        */
      virtual ~fsos();
        // Remember to close the file.
      virtual int close();
       // Close the associated file.  Return the error code given by fclose().
};

