#!/bin/sh -i
# usage: logwrite [logfile]
# this will establish a shell (from $SHELL) and
# log all changes to files into the logfile

# Default:
logfile="logwrite.log"

usage() {
	echo "usage: `basename $0` [logfile]" >&2
}

while test "$1"; do
case "$1" in 
	-b) export backups=1; shift ;;
	-*) usage; exit 1 ;;
	 *) logfile=$1;  shift
	    if test "$1"; then usage; exit 1; fi
	    break;;
	esac
done

export INSTALL_LOG=$logfile
export LD_PRELOAD=/usr/lib/logwrites.so
test "$backups" && export DO_BACKUPS=1

echo "** started `date` **" >> $logfile
echo "** logwrite shell started on `date` **" 
echo "** output goes to $logfile **"
test "$backups" && echo "** backups enabled **"
$SHELL 
echo "** logwrite shell done on    `date` **"
echo "** output is in $logfile **"
echo "** done    `date` **" >> $logfile
