;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.8/Rgc/trap.scm              */
;*                                                                     */
;*    Auteur      :  Manuel SERRANO                                    */
;*    Creation    :  Fri Jun 21 10:23:39 1991                          */
;*    Last change :  Mon Jul 10 14:43:43 1995 (serrano)                */
;*                                                                     */
;*    La generation des traps                                          */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*     Le module                                                       */
;*---------------------------------------------------------------------*/
(module __rgc_trap
   
   (import  (__error                   "Llib/error.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__structure               "Llib/struct.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__r4_numbers_6_5          "Ieee/number.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_input_6_10_2         "Ieee/input.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_ports_6_10_1         "Ieee/port.scm")
	    (__r4_output_6_10_3        "Ieee/output.scm")
	    (__rgc                     "Rgc/runtime.scm"))

   (use     (__type                    "Llib/type.scm")
	    (__evenv                   "Eval/evenv.scm"))

   (export  (pre-trap  t-trap)
	    (trapped?  num)
	    (test-trap num)))

;*---------------------------------------------------------------------*/
;*     Les variables statics                                           */
;*---------------------------------------------------------------------*/
(define *local-trap* #f)

;*---------------------------------------------------------------------*/
;*     pre-trap ...                                                    */
;*---------------------------------------------------------------------*/
(define (pre-trap t-trap)
   (set! *local-trap* t-trap))

;*---------------------------------------------------------------------*/
;*     trapped? ...                                                    */
;*---------------------------------------------------------------------*/
(define (trapped? num)
   (not (null? (vector-ref *local-trap* num))))

;*---------------------------------------------------------------------*/
;*     test-trap ...                                                   */
;*---------------------------------------------------------------------*/
(define (test-trap num)
   (case (vector-ref *local-trap* num)
      ((eof) '(input-port-eof? input-port))
      ((eol) '(input-port-eol? input-port))
      ((bol) '(input-port-bol? input-port))
      (else  `(eq? current-context
		   ',(cadr (vector-ref *local-trap* num))))))
