;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.8/Rgc/optimize.scm          */
;*                                                                     */
;*    Auteur      :  Manuel SERRANO                                    */
;*    Creation    :  Fri Jun 28 09:29:43 1991                          */
;*    Last change :  Mon Jul 10 14:40:51 1995 (serrano)                */
;*                                                                     */
;*    Le module ou on detecte les optimisations possibles.             */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*     Le module                                                       */
;*---------------------------------------------------------------------*/
(module __rgc_optimize
   
   (import  (__type                    "Llib/type.scm")
	    (__error                   "Llib/error.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__structure               "Llib/struct.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__r4_numbers_6_5          "Ieee/number.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_input_6_10_2         "Ieee/input.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_ports_6_10_1         "Ieee/port.scm")
	    (__r4_output_6_10_3        "Ieee/output.scm")
	    (__rgc                     "Rgc/runtime.scm")
	    (__rgc_trap                "Rgc/trap.scm")
	    (__evenv                   "Eval/evenv.scm"))

   (export  (prepare-optimisation nb-states states)
	    (compute-looping      s v a n)
	    (end-of-optimisation)
	    (looping?             state-num accept?)))

;*---------------------------------------------------------------------*/
;*     Les variables statics                                           */
;*---------------------------------------------------------------------*/
(define *t-looping* 'dummy)
(define *t-states-for-looping* 'dummy)

;*---------------------------------------------------------------------*/
;*     prepare-optimisation ...                                        */
;*---------------------------------------------------------------------*/
(define (prepare-optimisation nb-states states)
   (if *rgc-optim*
       (begin
	  (set! *t-looping* (make-vector nb-states 'not-yet))
	  (set! *t-states-for-looping* states) ) ) )
       
;*---------------------------------------------------------------------*/
;*     end-of-optimisation ... (juste pour que le gc puisse faire son  */
;*                              office)                                */
;*---------------------------------------------------------------------*/
(define (end-of-optimisation)
   (set! *t-looping* '())
   (set! *t-states-for-looping* '()) )

;*---------------------------------------------------------------------*/
;*     compute-looping ...                                             */
;*     ------------------------------------------------------------    */
;*     Un etat est un looping si:                                      */
;*        1. il est acceptant.                                         */
;*        2. Il n'existe que des transitions vers lui-meme.            */
;*        3. Aucune regle n'est trappee.                               */
;*---------------------------------------------------------------------*/
(define (compute-looping state-num vector accept? nb-states)
   (cond
      ((or (not *rgc-optim*) (not (vector-ref *t-looping* state-num)))
       #f)
      ((eq? (vector-ref *t-looping* state-num) 'not-yet)
       (vector-set! *t-looping* state-num
		    (and *rgc-optim*
			 (accept? state-num)
			 (not (trapped? (car (accept? state-num))))
			 (let loop ( (i 0) )
			    (if (=fx i nb-states)
				#t
				(if (=fx i state-num)
				    (loop (+fx 1 i))
				    (if (vector-ref vector i)
					#f
					(loop (+fx 1 i))))))))
       (vector-ref *t-looping* state-num))
      (else
       #t)))

;*---------------------------------------------------------------------*/
;*     compute-slow-looping ...                                        */
;*---------------------------------------------------------------------*/
(define (compute-slow-looping state-num accept?)
   (vector-set! *t-looping* state-num
		(and *rgc-optim*
		     (accept? state-num)
		     (not (trapped? (car (accept? state-num))))
		     (let loop ( (l (vector-ref *t-states-for-looping*
						state-num)) )
			(if (null? l)
			    #t
			    (if (or (not (char? (car (car l))))
				    (=fx (cdr (car l)) state-num))
				(loop (cdr l))
				#f))))))

;*---------------------------------------------------------------------*/
;*     looping? ...                                                    */
;*---------------------------------------------------------------------*/
(define (looping? state-num accept?)
   (if (not *rgc-optim*)
       #f
       (if (eq? (vector-ref *t-looping* state-num) 'not-yet)
	   (compute-slow-looping state-num accept?)
	   (vector-ref *t-looping* state-num) ) ) )





