;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime1.8/Llib/unix.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jan 20 08:27:19 1995                          */
;*    Last change :  Mon Jan 22 14:35:31 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The unix interface functions.                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __unix

   (import  (__error                   "Llib/error.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__foreign                 "Llib/foreign.scm")
	    (__evenv                   "Eval/evenv.scm"))

   (foreign (obj          c-signal  (int procedure)  "c_signal")
	    (obj          c-get-signal-handler (int) "get_signal_handler")
	    (obj          *the-command-line*         "command_line")
	    (string       *the-executable-name*      "executable_name")
	    (macro bool   c-getenv? (string)         "getenv")
	    (macro string c-getenv  (string)         "getenv")
	    (macro int    c-system  (string)         "system")
	    (string       c-date    ()               "c_date")
	    (macro int    c-chdir   (string)         "chdir")
	    (macro string c-getcwd  (string int)     "getcwd"))

   (export  (signal                  num::int thunk::procedure)
	    (get-signal-handler::obj num::int)

	    (inline getenv           string::string)
	    (inline system           string::string)
	    (inline date::string)
	    (inline chdir            string::string)
	    (pwd)
	    (command-line)
	    (executable-name::string)
	    (basename::bstring       string::bstring)
	    (dirname::bstring        string::bstring)
	    (prefix::bstring         string::bstring)
	    (suffix::bstring         string::bstring)))

;*---------------------------------------------------------------------*/
;*    command-line ...                                                 */
;*---------------------------------------------------------------------*/
(define (command-line)
   *the-command-line*)

;*---------------------------------------------------------------------*/
;*    executable-name ...                                              */
;*---------------------------------------------------------------------*/
(define (executable-name)
   *the-executable-name*)

;*---------------------------------------------------------------------*/
;*    signal ...                                                       */
;*---------------------------------------------------------------------*/
(define (signal num proc)
   (cond
      ((not (=fx (procedure-arity proc) 1))
       (error "signal" "Wrong number of arguments" proc))
      ((or (<fx num 0) (>fx num 31))
       (error "signal" "Illegal signal" num))
      (else
       (c-signal num proc))))

;*---------------------------------------------------------------------*/
;*    get-signal-handler ...                                           */
;*---------------------------------------------------------------------*/
(define (get-signal-handler num)
   (c-get-signal-handler num))

;*---------------------------------------------------------------------*/
;*    getenv ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (getenv string)
   (if (c-getenv? string)
       (c-getenv string)
       #f))

;*---------------------------------------------------------------------*/
;*    system ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (system string)
   (c-system string))
   
;*---------------------------------------------------------------------*/
;*    date ...                                                         */
;*---------------------------------------------------------------------*/
(define-inline (date)
   (c-date))

;*---------------------------------------------------------------------*/
;*    chdir ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (chdir dirname)
   (c-chdir dirname))

;*---------------------------------------------------------------------*/
;*    pwd ...                                                          */
;*---------------------------------------------------------------------*/
(define (pwd)
   (let ((string (make-string 1000)))
      (c-getcwd string 1000)))
	  
;*---------------------------------------------------------------------*/
;*    basename ...                                                     */
;*---------------------------------------------------------------------*/
(define (basename string)
   (let loop ((index (-fx (string-length string) 1)))
      (cond
	 ((=fx index -1)
	  string)
	 ((char=? (string-ref string index) #\/)
	  (substring string (+fx index 1) (string-length string)))
	 (else
	  (loop (-fx index 1))))))

;*---------------------------------------------------------------------*/
;*    prefix ...                                                       */
;*---------------------------------------------------------------------*/
(define (prefix string)
   (let ((len (-fx (string-length string) 1)))
      (let loop ((e len)
                 (s len))
         (cond
            ((<=fx s 0)
             (substring string 0 (+fx 1 e)))
            (else
             (if (and (eq? (string-ref string s) #\.)
                      (=fx e len))
                 (loop (-fx s 1) (-fx s 1))
                 (loop e (-fx s 1))))))))

;*---------------------------------------------------------------------*/
;*    dirname ...                                                      */
;*---------------------------------------------------------------------*/
(define (dirname string)
   (let ((len (-fx (string-length string) 1)))
      (let loop ((read len))
	 (cond
	    ((<=fx read 0)
	     (if (char=? (string-ref string read) #\/)
		 "/"
		 "."))
	    ((char=? (string-ref string read) #\/)
	     (substring string 0 read))
	    (else
	     (loop (-fx read 1)))))))

;*---------------------------------------------------------------------*/
;*    suffix ...                                                       */
;*---------------------------------------------------------------------*/
(define (suffix string)
   (let ((len (string-length string)))
      (let loop ((read (-fx len 1)))
	 (cond
	    ((<fx read 0)
	     "")
	    ((char=? (string-ref string read) #\.)
	     (substring string (+fx read 1) len))
	    (else
	     (loop (-fx read 1)))))))
