;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime1.8/Llib/foreign.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Jul  5 16:50:26 1995                          */
;*    Last change :  Sun Dec 10 10:58:11 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The foreign object management.                                   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __foreign
   
   (import  (__error                   "Llib/error.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__structure               "Llib/struct.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__evenv                   "Eval/evenv.scm"))

   (foreign (macro bool   c-foreign?      (obj)       "FOREIGNP")
	    (macro bool   c-foreign-null? (obj)       "FOREIGN_NULLP")
	    (macro symbol foreign-id      (foreign)   "FOREIGN_ID")
	    (cobj c-obj->cobj             (obj)       "obj_to_cobj"))

   (export  (inline foreign?::bool      ::obj)
	    (inline foreign-null?::bool ::obj)
	    (inline string-null?::bool  ::string)
	    (inline obj->cobj::cobj     ::obj)))

;*---------------------------------------------------------------------*/
;*    foreign? ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (foreign? obj)
   (c-foreign? obj))

;*---------------------------------------------------------------------*/
;*    foreign-null? ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (foreign-null? obj)
   (if (foreign? obj)
       (c-foreign-null? obj)
       (error "foreign-null?" "not a foreign object" obj)))

;*---------------------------------------------------------------------*/
;*    string-null? ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (string-null? obj::string)
   (pragma::bool "($1 == 0L)" obj))

;*---------------------------------------------------------------------*/
;*    obj->cobj ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (obj->cobj obj)
   (c-obj->cobj obj))

