;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime1.9/Ieee/output.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Jul  5 11:13:01 1992                          */
;*    Last change :  Tue Mar 26 12:28:59 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    6.10.3 Output (page 31, r4)                                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __r4_output_6_10_3

   (import  (__error                   "Llib/error.scm")
	    (__r4_ports_6_10_1         "Ieee/port.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__structure               "Llib/struct.scm")
	    (__tstructure              "Llib/tstruct.scm")
	    (__bexit                   "Llib/bexit.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")

	    (__evenv                   "Eval/evenv.scm"))
     
   (foreign (macro bool output-string-port (obj)         "OUTPUT_STRING_PORTP")
            (macro uchar c-write-char (uchar output-port) "WRITE_CHAR")
	    (obj c-write_char     (bchar output-port)    "write_char")
	    (obj display-char     (bchar output-port)    "display_char")
	    (obj write-object     (obj output-port)      "write_object")
	    (obj write-string     (bstring output-port)  "write_string")
	    (obj display-string   (bstring output-port)  "display_string")
	    (obj display-fixnum   (blong output-port)    "display_fixnum")
	    (obj display-flonum   (real output-port)     "display_flonum")
	    (obj display-cell     (cell output-port)     "display_cell")
	    (obj ill-char-rep     (uchar)                "ill_char_rep")
	    (export c-debugging-print "dprint"))
    
   (export  (set-write-length!        ::long)
	    (get-write-length::long)
            (newline                  . port)
	    (write                    obj . port)
	    (display                  obj . port)  
	    (write-char               ::uchar . port)
	    (illegal-char-rep         ::uchar) 
	    (display*                 . obj)
	    (write*                   . obj)
	    (print                    . obj)
	    (fprint                   ::output-port . obj)
	    (set-printer!             ::procedure)
	    (native-printer::procedure)
	    (c-debugging-print        ::obj)))
   
;*---------------------------------------------------------------------*/
;*    *max-length-write* ...                                           */
;*    -------------------------------------------------------------    */
;*    Cette variable contient le nombre maximum d'appels recursifs     */
;*    toleres lors d'un write.                                         */
;*---------------------------------------------------------------------*/
(define *max-length-write* -1)

;*---------------------------------------------------------------------*/
;*    *displayed*                                                      */
;*---------------------------------------------------------------------*/
(define *displayed* 0)

;*---------------------------------------------------------------------*/
;*    set-write-length ...                                             */
;*---------------------------------------------------------------------*/
(define (set-write-length! length)
   (set! *max-length-write* length))

;*---------------------------------------------------------------------*/
;*    get-write-length ...                                             */
;*---------------------------------------------------------------------*/
(define (get-write-length)
   *max-length-write*)

;*---------------------------------------------------------------------*/
;*    newline ...                                                      */
;*---------------------------------------------------------------------*/
(define (newline . port)
   (c-write-char #\Newline
		 (if (or (null? port)
			  (not (output-port? (car port))))
		     (current-output-port)
		     (car port))))

;*---------------------------------------------------------------------*/
;*    display ...                                                      */
;*---------------------------------------------------------------------*/
(define (display obj . port)
   (set! *displayed* 0)
   (if (or (eq? *current-printer* native-display)
	   (not (procedure? *current-printer*)))
       (write/display obj
		      (if (or (null? port) (not (output-port? (car port))))
			  (current-output-port)
			  (car port))
		      #t)
       (try (*current-printer* obj (if (null? port) port (car port)))
	    (lambda (esc proc mes obj)
	       (set-printer! (native-printer))
	       (error proc mes obj)))))

;*---------------------------------------------------------------------*/
;*    native-display ...                                               */
;*---------------------------------------------------------------------*/
(define (native-display obj . port)
   (set! *displayed* 0)
   (if (or (eq? *current-printer* native-display)
	   (not (procedure? *current-printer*)))
       (write/display obj
		      (if (or (null? port) (not (output-port? (car port))))
			  (current-output-port)
			  (car port))
		      #t)
       (try (*current-printer* obj (if (null? port) port (car port)))
	    (lambda (esc proc mes obj)
	       (set-printer! (native-printer))
	       (error proc mes obj)))))

;*---------------------------------------------------------------------*/
;*    write ...                                                        */
;*---------------------------------------------------------------------*/
(define (write obj . port)
   (set! *displayed* 0)
   (write/display obj
		  (if (or (null? port)
			  (not (output-port? (car port))))
		      (current-output-port)
		      (car port))
		  #f))

;*---------------------------------------------------------------------*/
;*    write-char ...                                                   */
;*---------------------------------------------------------------------*/
(define (write-char char . port)
   (c-write-char char
		 (if (or (null? port)
			 (not (output-port? (car port))))
		     (current-output-port)
		     (car port))))

;*---------------------------------------------------------------------*/
;*    illegal-char-rep ...                                             */
;*---------------------------------------------------------------------*/
(define (illegal-char-rep char)
   (ill-char-rep char))

;*---------------------------------------------------------------------*/
;*    write/display ...                                                */
;*    -------------------------------------------------------------    */
;*    As we can't be sure that this module is initialized before       */
;*    used (for example when an error occurs during module             */
;*    intialization process), we can't use symbol to set               */
;*    flag. So is flag is equal to #t it means that                    */
;*    `write-display' is used to display and if flags is equal         */
;*    to #f it writes.                                                 */
;*---------------------------------------------------------------------*/
(define (write/display obj port flag)
   (set! *displayed* (+fx 1 *displayed*))
   (cond
      ((and (>fx *max-length-write* 0)
	    (>=fx *displayed* *max-length-write*))
       (display-string "..." port))
      ((fixnum? obj)
       (display-fixnum obj port))
      ((char? obj)
       (if flag
	   (display-char obj port)
	   (c-write_char obj port)))
      ((string? obj)
       (if flag
	   (display-string obj port)
	   (write-string (string-for-read obj) port)))
      ((vector? obj)
       (write/display-vector obj port flag))
      ((pair? obj)
       (write/display-pair obj port flag))
      ((flonum? obj)
       (display-flonum obj port))
      ((cell? obj)
       (display-cell obj port))
      ((struct? obj)
       (write/display-structure obj port flag))
      ((tstruct? obj)
       (write/display-tstructure obj port flag))
      ((tvector? obj)
       (write/display-tvector obj port flag))
      (else
       (write-object obj port)))
   #unspecified)

;*---------------------------------------------------------------------*/
;*    write/display-structure ...                                      */
;*---------------------------------------------------------------------*/
(define (write/display-structure obj port flag)
   (c-write-char #\# port)
   (c-write-char #\{ port)
   (write-object (struct-key obj) port)
   (if (=fx 0 (struct-length obj))
       (c-write-char #\} port)
       (let ((len (-fx (struct-length obj) 1)))
	  (c-write-char #\space port)
	  (let loop ((i 0))
	     (cond
		((and (>fx *max-length-write* 0)
		      (>fx *displayed* *max-length-write*))
		 (write-object "... }" port))
		((=fx i len)
		 (write/display (struct-ref obj i) port flag)
		 (c-write-char #\} port))
		(else
		 (write/display (struct-ref obj i) port flag)
		 (c-write-char #\space port)
		 (loop (+fx 1 i))))))))

;*---------------------------------------------------------------------*/
;*    write/display-tstructure ...                                     */
;*---------------------------------------------------------------------*/
(define (write/display-tstructure obj port flag)
   (c-write-char #\# port)
   (write-object (tstruct-id obj) port)
   (c-write-char #\{ port)
   (let* ((vect (tstruct->vector obj))
	  (len  (vector-length vect)))
      (cond
	 ((=fx len 0)
	  (c-write-char #\} port))
	 ((=fx len 1)
	  (write-object (vector-ref vect 0) port)
	  (c-write-char #\} port))
	 (else
	  (let loop ((i 0))
	     (if (=fx i (-fx len 1))
		 (begin
		    (write-object (vector-ref vect i) port)
		    (c-write-char #\} port))
		 (begin
		    (write-object (vector-ref vect i) port)
		    (c-write-char #\space port)
		    (loop (+fx i 1)))))))))

;*---------------------------------------------------------------------*/
;*    write/display-vector ...                                         */
;*---------------------------------------------------------------------*/
(define (write/display-vector obj port flag)
   (c-write-char #\# port)
   (let ((tag (vector-tag obj)))
      (if (>fx tag 0)
	  (begin
	     (if (>=fx tag 100)
		 (write-object tag port)
		 (begin
		    (c-write-char #\0 port)
		    (if (>=fx tag 10)
			(write-object tag port)
			(begin
			   (c-write-char #\0 port)
			   (write-object tag port))))))))
   (c-write-char #\( port)
   (if (=fx 0 (vector-length obj))
       (c-write-char #\) port)
       (let ((len (-fx (vector-length obj) 1)))
	  (let loop ((i 0))
	     (cond
		((and (>fx *max-length-write* 0)
		      (>=fx *displayed* *max-length-write*))
		 (write-object "... )" port))
		((=fx i len)
		 (write/display (vector-ref obj i) port flag)
		 (c-write-char #\) port))
		(else
		 (write/display (vector-ref obj i) port flag)
		 (c-write-char #\space port)
		 (loop (+fx 1 i))))))))
 
;*---------------------------------------------------------------------*/
;*    write/display-tvector ...                                        */
;*---------------------------------------------------------------------*/
(define (write/display-tvector tvec port flag)
   (let ((tvector-ref (tvector-ref tvec))
	 (id          (tvector-id tvec)))
      (c-write-char #\# port)
      (write-object id port)
      (c-write-char #\( port)
      (if (not tvector-ref)
	  (begin
	     (write-object "...)" port)
	     tvec)
	  (begin
	     (if (=fx 0 (tvector-length tvec))
		 (c-write-char #\) port)
		 (let ((len (-fx (tvector-length tvec) 1)))
		    (let loop ((i 0))
		       (cond
			  ((and (>fx *max-length-write* 0)
				(>=fx *displayed* *max-length-write*))
			   (write-object "... )" port))
			  ((=fx i len)
			   (write/display (tvector-ref tvec i)
					  port
					  flag)
			   (c-write-char #\) port))
			  (else
			   (write/display (tvector-ref tvec i)
					  port
					  flag)
			   (c-write-char #\space port)
			   (loop (+fx 1 i)))))))))))

;*---------------------------------------------------------------------*/
;*    write/display-pair ...                                           */
;*---------------------------------------------------------------------*/
(define (write/display-pair obj port flag)
   (c-write-char #\( port)
   (let loop ((l obj))
      (cond
	 ((null? (cdr l))
	  (write/display (car l) port flag)
	  (c-write-char #\) port))
	 ((and (>fx *max-length-write* 0)
	       (>=fx *displayed* *max-length-write*))
	  (write-object " . ... )" port))
	 ((not (pair? (cdr l)))
	  (write/display (car l) port flag)
	  (c-write-char #\space port)
	  (c-write-char #\. port)
	  (c-write-char #\space port)
	  (write/display (cdr l) port flag)
	  (c-write-char #\) port))
	 (else
	  (write/display (car l) port flag)
	  (c-write-char #\space port)
	  (loop (cdr l))))))
 
;*---------------------------------------------------------------------*/
;*    Les fonctions qui suivent ne sont pas r4                         */
;*---------------------------------------------------------------------*/
;*---------------------------------------------------------------------*/
;*    print ...                                                        */
;*---------------------------------------------------------------------*/
(define (print . obj)
   (set! *displayed* 0)
   (let ((port (current-output-port)))
      (let loop ((l   obj)
		 (res '()))
	 (if (null? l)
	     (begin
		(c-write-char #\Newline port)
		res)
	     (let ((v (car l)))
		(write/display v port #t)
		(loop (cdr l) v))))))

;*---------------------------------------------------------------------*/
;*    display* ...                                                     */
;*---------------------------------------------------------------------*/
(define (display* . obj)
   (set! *displayed* 0)
   (let ((port (current-output-port)))
      (let loop ((l obj))
	 (if (null? l)
	     #unspecified
	     (let ((v (car l)))
		(write/display (car l) port #t)
		(loop (cdr l)))))))

;*---------------------------------------------------------------------*/
;*    write* ...                                                       */
;*---------------------------------------------------------------------*/
(define (write* . obj)
   (set! *displayed* 0)
   (let ((port (current-output-port)))
      (let loop ((l obj))
	 (if (null? l)
	     #unspecified
	     (let ((v (car l)))
		(write/display (car l) port #f)
		(loop (cdr l)))))))

;*---------------------------------------------------------------------*/
;*    fprint ...                                                       */
;*---------------------------------------------------------------------*/
(define (fprint port . obj)
   (set! *displayed* 0)
   (let loop ((l    obj)
	      (res '()))
      (if (null? l)
	  (begin
	     (c-write-char #\Newline port)
	     res)
	  (let ((v (car l)))
	     (write/display (car l) port #t)
	     (loop (cdr l) v)))))
  
;*---------------------------------------------------------------------*/
;*    *current-printer* ...                                            */
;*    -------------------------------------------------------------    */
;*    On est oblige de faire l'affectation de `*current-printer*'      */
;*    en deux fois car sinon, a cause des optims, on n'aura pas        */
;*    eq? entre `native-printer' et `*current-printer*' !              */
;*---------------------------------------------------------------------*/
(define *current-printer* #unspecified)
(set! *current-printer* native-display)

;*---------------------------------------------------------------------*/
;*    set-printer! ...                                                 */
;*---------------------------------------------------------------------*/
(define (set-printer! f)
   (set! *current-printer* f))

;*---------------------------------------------------------------------*/
;*    native-printer ...                                               */
;*---------------------------------------------------------------------*/
(define (native-printer)
   native-display)

;*---------------------------------------------------------------------*/
;*    c-debugging-print ...                                            */
;*---------------------------------------------------------------------*/
(define (c-debugging-print obj)
   (set! *displayed* 0)
   (let ((port (current-output-port)))
      (write/display obj port #t)
      (c-write-char #\Newline port)
      obj))


