;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/kapture.scm ...              */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon May 11 10:37:55 1992                          */
;*    Last change :  Wed Aug 31 16:49:12 1994 (serrano)                */
;*                                                                     */
;*    Des tests de capture de variables                                */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module kapture
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-kapture)))

;*---------------------------------------------------------------------*/
;*    test1 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test1 x y z)
   (labels ((hux (a)  x)
	    (bar (a) (hux y))
	    (gee ()  (bar z)))
      gee))

;*---------------------------------------------------------------------*/
;*    test2 ...                                                        */
;*---------------------------------------------------------------------*/
(define test2 (labels ((lam_0 ()
			    (labels ((ignore ()
					     (let ((v 1))
						(labels ((foo () v))
						   (foo)))))
			       (ignore))))
	       lam_0))

;*---------------------------------------------------------------------*/
;*    luc ...                                                          */
;*---------------------------------------------------------------------*/
(define luc
   (lambda ()
      (let ((counter 0))
	 (lambda x
	    (set! counter (+ counter 1))
	    (string->symbol ((if (null? x)
				 (lambda (u)
				    (string-append ":X"  u))
				 (if (string? (car x))
				     (lambda (u)
					(string-append (car x)  u))
				     (lambda (u)
					(string-append (symbol->string (car x))  u))))
			     (number->string counter)))))))

;*---------------------------------------------------------------------*/
;*    kapture:test ...                                                 */
;*---------------------------------------------------------------------*/
(define (kapture:test)
   (labels ((gee (y) (lambda (x) (set! y x) y)))
      ((gee 0) 2)))

;*---------------------------------------------------------------------*/
;*    test-kapture ...                                                 */
;*---------------------------------------------------------------------*/
(define (test-kapture)
   (test-module "kapture" "kapture.scm" #f)
   (test "kapture" ((test1 1 2 3)) 1)
   (test "kapture" (test2) 1)
   (test "luc-kapture" (let ((gen-sym (luc)))
			  (gen-sym 'a)) 'a1)
   (test "side-effect" (kapture:test) 2))
