;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Type/pptype.scm ...      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Dec 31 08:28:30 1994                          */
;*    Last change :  Fri Mar 10 17:01:55 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The type pretty-printer                                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module type_pptype
   (include "Type/type.sch"
	    "Ast/ast.sch")
   (export  (type-id->string       <type>)
	    (function-type->string <function>)
	    (variable-type->string <variable>)))

;*---------------------------------------------------------------------*/
;*    type-id->string ...                                              */
;*---------------------------------------------------------------------*/
(define (type-id->string type)
   (if (not (type? type))
       "_"
       (string-downcase (symbol->string (type-id type)))))

;*---------------------------------------------------------------------*/
;*    function-type->string ...                                        */
;*---------------------------------------------------------------------*/
(define (function-type->string fun)
   (string-append (let loop ((args (function-args fun)))
		     (if (null? args)
			 ""
			 (string-append
			  (type-id->string (local-type (car args)))
			  (if (null? (cdr args))
			      ""
			      " x ")
			  (loop (cdr args)))))
		  " -> "
		  (type-id->string (function-type-res fun))))

;*---------------------------------------------------------------------*/
;*    variable-type->string ...                                        */
;*---------------------------------------------------------------------*/
(define (variable-type->string variable)
   (type-id->string (variable-type variable)))
