;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Trace/walk.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Apr 13 13:53:58 1995                          */
;*    Last change :  Tue Feb  6 15:49:33 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The introduction of trace in debuggin mode.                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module trace_walk
   (include "Tools/pass.sch"
	    "Ast/node.sch")
   (import  tools_shape
	    ast_global
	    ast_local
	    ast_dump
	    type_cache
	    engine_param)
   (export  (trace-walk! tree)))

;*---------------------------------------------------------------------*/
;*    *pop-trace* & *push-trace* ...                                   */
;*---------------------------------------------------------------------*/
(define *pop-trace* #unspecified)
(define *push-trace* #unspecified)

;*---------------------------------------------------------------------*/
;*    trace-walk! ...                                                  */
;*---------------------------------------------------------------------*/
(define (trace-walk! ast)
   (pass-prelude "Trace")
   (set! *pop-trace* (require-global 'c-pop-trace 'foreign #f))
   (set! *push-trace* (require-global 'c-push-trace 'foreign #f))
   (global-occurrence-set! *pop-trace* 1000)
   (global-occurrence-set! *push-trace* 1000)
   (for-each trace-fun! ast)
   (set! *pop-trace* #unspecified)
   (set! *push-trace* #unspecified)
   ast)

;*---------------------------------------------------------------------*/
;*    trace-fun! ...                                                   */
;*---------------------------------------------------------------------*/
(define (trace-fun! var)
   (let* ((fun  (variable-value var))
	  (body (function-body fun))
	  (type (function-type-res fun)))
      (enter-function (shape var))
      (let* ((new-body  (if (>=fx *compiler-debug* 2)
			    (trace-ast body)
			    body))
	     (new2-body (make-traced-ast new-body
					 type
					 (variable-name var))))
	 (function-body-set! fun new2-body)
	 (leave-function))))
   
;*---------------------------------------------------------------------*/
;*    make-traced-ast ...                                              */
;*---------------------------------------------------------------------*/
(define (make-traced-ast ast type name)
   [assert check (name) (symbol? name)]
   (let ((loc (ast-location ast))
	 (aux (make-local-variable (gensym 'res) type)))
      ;; we introduce an empty let in order to be sure that
      ;; trace will be enclosed between { and }.
      (ast-let-var
       loc
       #f
       #f
       '()
       (ast-sequence loc
		     #f
		     #f
		     (list
		      (ast-app loc
			       #f
			       #f
			       (ast-var loc #f #f *push-trace*)
			       (list (ast-kwote loc #f #f name #f))
			       #f
			       #f
			       #f
			       #f)
		      (ast-let-var loc
				   #f
				   #f
				   (list (cons aux ast))
				   (ast-sequence loc
						 #f
						 #f
						 (list
						  (ast-app loc
							   #f
							   #f
							   (ast-var
							    loc
							    #f
							    #f
							    *pop-trace*)
							   '()
							   #f
							   #f
							   #f
							   #f)
						  (ast-var loc
							   #f
							   #f
							   aux)))
				   #t)))
       #f)))

;*---------------------------------------------------------------------*/
;*    trace-ast ...                                                    */
;*---------------------------------------------------------------------*/
(define (trace-ast ast)
   (ast-case ast
      ((atom)
       ast)
      ((var)
       ast)
      ((kwote)
       ast)
      ((sequence)
       (let loop ((asts (sequence-exp ast)))
          (if (null? asts)
              ast
              (begin
                 (set-car! asts (trace-ast (car asts)))
                 (loop (cdr asts))))))
      ((make-box)
       (make-box-value-set! ast (trace-ast (make-box-value ast)))
       ast)
      ((box-ref)
       (box-ref-var-set! ast (trace-ast (box-ref-var ast)))
       ast)
      ((box-set!)
       (box-set!-var-set! ast (trace-ast (box-set!-var ast)))
       (box-set!-value-set! ast (trace-ast (box-set!-value ast)))
       ast)
      ((setq)
       (setq-val-set! ast (trace-ast (setq-val ast)))
       ast)
      ((conditional)
       (conditional-test-set! ast (trace-ast (conditional-test ast)))
       (conditional-then-set! ast (trace-ast (conditional-then ast)))
       (conditional-else-set! ast (trace-ast (conditional-else ast)))
       ast)
      ((fail)
       (fail-proc-set! ast (trace-ast (fail-proc ast)))
       (fail-msg-set! ast (trace-ast (fail-msg ast)))
       (fail-obj-set! ast (trace-ast (fail-obj ast)))
       ast)
      ((let-fun)
       (let-fun-body-set! ast (trace-ast (let-fun-body ast)))
       (for-each trace-fun! (let-fun-locals ast))
       ast)
      ((let-var)
       (for-each (lambda (binding)
		    (set-cdr! binding (trace-ast (cdr binding))))
		 (let-var-bindings ast))
       (let-var-body-set! ast (trace-ast (let-var-body ast)))
       ast)
      ((app-ly)
       (app-ly-fun-set! ast (trace-ast (app-ly-fun ast)))
       (app-ly-value-set! ast (trace-ast (app-ly-value ast)))
       ast) 
      ((funcall)
       (funcall-fun-set! ast (trace-ast (funcall-fun ast)))
       (let loop ((actuals (funcall-actuals ast)))
	  (if (null? actuals)
	      ast
	      (begin
		 (set-car! actuals (trace-ast (car actuals)))
		 (loop (cdr actuals))))))
      ((fun)
       (internal-error "do-set-recursive-call!"
		       "Illegal node (see `Bivaluation' pass)"
		       (ast->sexp ast)))
      ((app)
       (let loop ((actuals (app-actuals ast)))
	  (if (null? actuals)
	      ast
	      (begin
		 (set-car! actuals (trace-ast (car actuals)))
		 (loop (cdr actuals))))))
      ((set-ex-it)
       (set-ex-it-body-set! ast (trace-ast (set-ex-it-body ast)))
       ast)
      ((jump-ex-it)
       (jump-ex-it-exit-set! ast (trace-ast (jump-ex-it-exit ast)))
       (jump-ex-it-value-set! ast (trace-ast (jump-ex-it-value ast)))
       ast)
      ((switch)
       (switch-test-set! ast (trace-ast (switch-test ast)))
       (for-each (lambda (clause)
                    (set-cdr! clause (trace-ast (cdr clause))))
                 (switch-clauses ast))
       ast)
      ((prag-ma)
       (let loop ((asts (prag-ma-values ast)))
          (if (null? asts)
              ast
              (begin
                 (set-car! asts (trace-ast (car asts)))
                 (loop (cdr asts))))))))
   
