;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.8/Tools/trace.scm          */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Jun 15 15:04:42 1992                          */
;*    Last change :  Mon Jan 22 16:00:42 1996 (serrano)                */
;*                                                                     */
;*    La gestion des traces                                            */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module tools_trace
   (import tools_error
	   engine_param)
   (export (start-trace      what mode)
	   stop-trace
	   *trace-port* 
	   (add-trace-mask   mask)
	   (satisfy?         mask)
	   (trace-mask-value m)
	   (mask             . values)
	   (when-trace       mask . t)))

;*---------------------------------------------------------------------*/
;*    L'initialisation des variables locales                           */
;*---------------------------------------------------------------------*/
(define *trace-port* #f)
(define *trace-mask* 0)
(define *trace-mode* 'or)

;*---------------------------------------------------------------------*/
;*    start-trace ...                                                  */
;*---------------------------------------------------------------------*/
(define (start-trace what mode)
   (set! *trace-mode* mode)
   (let ((trace-name "trace"))
      (set! *trace-port* (open-output-file trace-name))
      (if (not (output-port? *trace-port*))
	  (internal-error "start-trace" "Can't open trace file" trace-name))
      (if (eq? what 'all)
	  (set! *trace-mask* (+ 524288 262144 131072 65536 65535))
	  (set! *trace-mask* 0))))
       
;*---------------------------------------------------------------------*/
;*    stop-trace ...                                                   */
;*---------------------------------------------------------------------*/
(define (stop-trace)
   (if (output-port? *trace-port*)
       (close-output-port *trace-port*)))

;*---------------------------------------------------------------------*/
;*    add-trace-mask ...                                               */
;*---------------------------------------------------------------------*/
(define (add-trace-mask m)
   (set! *trace-mask* (bit-or *trace-mask* (trace-mask-value m))))

;*---------------------------------------------------------------------*/
;*    trace-one-mask-value ...                                         */
;*---------------------------------------------------------------------*/
(define (trace-one-mask-value m)
   (case m
      ((all)
       -1)
      ((read)
       1)
      ((init)
       2)
      ((env)
       4)
      ((eps)
       8)
      ((inline)
       16)
      ((hoist)
       32)
      ((type)
       64)
      ((remove)
       128)
      ((parse)
       256)
      ((globalize)
       512)
      ((loop)
       1024)
      ((cnst)
       2048)
      ((cgen)
       4096)
      ((other)
       8192)
      ((reduce)
       16384)
      ((effect)
       32768)
      ((cfa)
       65536)
      ((assert)
       131072)
      ((integrate)
       262144)
      ((stack)
       524288)
      (else
       (internal-error "add-trace-mask" "unknown mask" m))))

;*---------------------------------------------------------------------*/
;*    trace-mask-value ...                                             */
;*---------------------------------------------------------------------*/
(define (trace-mask-value m)
   (if (not (pair? m))
       (trace-one-mask-value m)
       (let loop ((m   m)
		  (acc 0))
	  (if (null? m)
	      acc
	      (loop (cdr m)
		    (bit-or (trace-one-mask-value (car m)) acc))))))
			  
;*---------------------------------------------------------------------*/
;*    satisfy? ...                                                     */
;*---------------------------------------------------------------------*/
(define (satisfy? mask)
   (let ((*debug-mode* #f))
      (cond
	 ((not *debug-mode*)
	  #f)
	 ((= *trace-mask* 0)
	  #f)
	 ((= mask -1)
	  #f)
	 ((eq? *trace-mode* 'or)
	  (not (= (bit-and *trace-mask* mask) 0)))
	 (else
	  (and (>= (bit-and *trace-mask* mask) 0)
	       (<= mask *trace-mask*)
	       (>= (* 2 mask) *trace-mask*))))))
	    
;*---------------------------------------------------------------------*/
;*    when-trace ...                                                   */
;*---------------------------------------------------------------------*/
(define (when-trace mask . thunks)
   (if (satisfy? (trace-mask-value mask))
       (begin
	  (for-each (lambda (v) (v)) thunks)
	  (flush-output-port *trace-port*))))
		 
;*---------------------------------------------------------------------*/
;*    mask                                                             */
;*---------------------------------------------------------------------*/
(define (mask . values)
   (let loop ((values values))
      (if (null? values)
	  0
	  (bit-or (trace-mask-value (car values)) (loop (cdr values))))))
	      
	      
       
       
	 
