;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/bigloo1.7/comptime1.8/Tools/progn.scm ...                */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Dec 29 11:08:04 1994                          */
;*    Last change :  Mon Jan  9 08:43:39 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The code sequence normalization.                                 */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module tools_progn
   (import tools_misc
	   tools_error)
   (export (normalize-progn <expression>)))

;*---------------------------------------------------------------------*/
;*    normalize-progn ...                                              */
;*    sexp --> sexp                                                    */
;*---------------------------------------------------------------------*/
(define (normalize-progn body*)
   (cond
      ((not (pair? body*))
       (internal-error "normalize-progn" "Ilegal expression" body*))
      ((null? (cdr body*))
       (car body*))
      (else
       (let ((res `(begin ,@(let loop ((body* (if (eq? (car body*) 'begin)
						  (cdr body*)
						  body*)))
			       (if (null? body*)
				   '()
				   (let ((expr (car body*)))
				      (if (and (pair? expr)
					       (eq? (car expr) 'begin))
					  (append (cdr expr)
						  (loop (cdr body*)))
					  (cons expr (loop (cdr body*))))))))))
	  (replace! body* res)))))

