;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Tools/pass.sch           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Dec 25 10:29:06 1994                          */
;*    Last change :  Thu Mar 28 11:29:34 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The pass prelude                                                 */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The directives clause                                            */
;*---------------------------------------------------------------------*/
(directives
   (import  tools_speek
	    (*error-on-pass* tools_error)
	    tools_pass))
 
;*---------------------------------------------------------------------*/
;*    pass-prelude ...                                                 */
;*    -------------------------------------------------------------    */
;*    The pass prelude.                                                */
;*---------------------------------------------------------------------*/
(define-macro (pass-prelude name . hooks)
   `(begin
       (verbose 1 "   . " ,name #\newline)
       (set! *error-on-pass* 0)
       (set! *current-pass*  ,name)
       (let loop ((hooks ,(cons 'list hooks))
		  (hnames ',hooks))
	  (cond
	     ((null? hooks)
	      'pass-started)
	     (((car hooks))
	      (loop (cdr hooks) (cdr hnames)))
	     (else
	      (internal-error ,name
			      "failure during prelude hook"
			      (car hnames)))))))

;*---------------------------------------------------------------------*/
;*    pass-postlude ...                                                */
;*---------------------------------------------------------------------*/
(define-macro (pass-postlude value . hooks)
   `(let ((value ,value))
       (if (>fx *error-on-pass* 0)
	   (begin
	      (fprint (current-error-port)
		      *error-on-pass*
		      " error"
		      (if (and (integer? *error-on-pass*)
			       (> *error-on-pass* 1))
			  "s"
			  "")
		      " occured, ending ...")
	      (exit -1))
	   (let loop ((hooks  ,(cons 'list hooks))
		      (hnames ',hooks))
	      (cond
		 ((null? hooks)
		  value)
		 (((car hooks))
		  (loop (cdr hooks) (cdr hnames)))
		 (else
		  (internal-error *current-pass*
				  "failure during postlude hook"
				  (car hnames))))))))
	      
	       

	   
