;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Tools/location.scm       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Dec 29 08:48:32 1994                          */
;*    Last change :  Mon Jan 22 14:41:13 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The `location' managment                                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module tools_location
   (include "Tools/location.sch")
   (export  (find-location     <s-exp>)
	    (find-location/loc <s-exp> <loc>)
	    (loc-full-fname    <loc>)))

;*---------------------------------------------------------------------*/
;*    find-location ...                                                */
;*---------------------------------------------------------------------*/
(define (find-location exp)
   (cond
      ((epair? exp)
       ;; easy the location has been directly produced by the reader.
       (let ((reader-location (cer exp)))
	  (match-case reader-location
	     ((at ?fname ?pos)
	      (loc fname pos))
	     (else
	      #f))))
      (else
       #f)))

;*---------------------------------------------------------------------*/
;*    find-location/loc ...                                            */
;*---------------------------------------------------------------------*/
(define (find-location/loc exp loc)
   [assert check (exp loc) (or (loc? loc) (not loc))]
   (let ((new-loc (find-location exp)))
      (if (loc? new-loc)
	  new-loc
	  loc)))

;*---------------------------------------------------------------------*/
;*    loc-full-fname ...                                               */
;*---------------------------------------------------------------------*/
(define (loc-full-fname loc)
   (let ((fname (loc-fname loc))
	 (pwd   (let ((vpwd (getenv "PWD")))
		   (if (string? vpwd)
		       vpwd
		       (pwd)))))
      (string-append pwd "/" fname)))
   
