;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Reduce/common.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Sep 13 15:21:22 1995                          */
;*    Last change :  Wed Oct 11 11:42:32 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The common subexpression elimination                             */
;*=====================================================================*/
 
;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module reduce_common
   (include "Ast/node.sch"
	    "Reduce/common.sch"
	    "Tools/trace.sch")
   (import  tools_shape
	    tools_speek
	    effect_effect
	    ast_sexp)
   (export  (reduce-common! globals)))

;*---------------------------------------------------------------------*/
;*    Statistics ...                                                   */
;*---------------------------------------------------------------------*/
(define *nb-app*          0)
(define *nb-app-reduced*  0)

;*---------------------------------------------------------------------*/
;*    reduce-common! ...                                               */
;*---------------------------------------------------------------------*/
(define (reduce-common! globals)
   (verbose 2 "        common subexpressions" #\Newline)
   (for-each (lambda (global)
		(let* ((fun (global-value global))
		       (ast (function-body fun))) 
		   (function-body-set! fun (ast-common! ast '()))
		   #unspecified))
	     globals)
   (verbose 2"            reduction: "
	    (if (=fx *nb-app-reduced* 0)
		0
		(inexact->exact
		 (*fl 100.0 (/fl (exact->inexact *nb-app-reduced*)
				 (exact->inexact *nb-app*)))))
	    " % [" *nb-app-reduced* "/" *nb-app* "]"
	    #\Newline))

;*---------------------------------------------------------------------*/
;*    ast-common! ...                                                  */
;*---------------------------------------------------------------------*/
(define (ast-common! ast set)
   (ast-case ast
      ((atom)
       ast)
      ((kwote)
       ast)
      ((var)
       (let* ((var   (var-variable ast))
	      (alpha (variable-fast-alpha var)))
	  (if (calpha? alpha)
	      (var-variable-set! ast (calpha-var alpha)))
	  ast))
      ((make-box)
       (make-box-value-set! ast (ast-common! (make-box-value ast) set))
       ast)
      ((box-ref)
       (box-ref-var-set! ast (ast-common! (box-ref-var ast) set))
       ast)
      ((box-set!)
       (box-set!-value-set! ast (ast-common! (box-set!-value ast) set))
       ast)
      ((prag-ma)
       (let loop ((exp (prag-ma-values ast))
		  (set set))
	  (if (null? exp)
	      ast
	      (begin
		 (set-car! exp (ast-common! (car exp) set))
		 (loop (cdr exp) set)))))
      ((fail)
       (fail-proc-set! ast (ast-common! (fail-proc ast) set))
       (fail-msg-set!  ast (ast-common! (fail-msg ast) set))
       (fail-obj-set!  ast (ast-common! (fail-obj ast) set))
       ast)
      ((sequence)
       (let loop ((exp (sequence-exp ast))
		  (set set))
	  (if (null? exp)
	      ast
	      (let ((new (ast-common! (car exp) set)))
		 (set-car! exp new)
		 (if (side-effect-free? new)
		     (loop (cdr exp) set)
		     (loop (cdr exp) '()))))))
      ((conditional)
       (common-conditional! ast set))
      ((switch)
       (let ((new (ast-common! (switch-test ast) set)))
	  (if (side-effect-free? new)
	      (for-each (lambda (clause)
			   (set-cdr! clause (ast-common! (cdr clause) set)))
			(switch-clauses ast))
	      (for-each (lambda (clause)
			   (set-cdr! clause (ast-common! (cdr clause) '())))
			(switch-clauses ast)))
	  ast))
      ((setq)
       (let ((val (setq-val ast)))
	  (setq-val-set! ast (ast-common! val set)))
       ast)
      ((let-var)
       (common-let-var! ast set))
      ((let-fun)
       (for-each (lambda (local)
		    (let ((fun (local-value local)))
		       (function-body-set! fun
					   (ast-common! (function-body fun)
							set))))
		 (let-fun-locals ast))
       (let-fun-body-set! ast (ast-common! (let-fun-body ast) set))
       ast)
      ((set-ex-it)
       (set-ex-it-body-set! ast (ast-common! (set-ex-it-body ast) set))
       ast)
      ((jump-ex-it)
       (jump-ex-it-exit-set! ast (ast-common! (jump-ex-it-exit ast) set))
       (jump-ex-it-value-set! ast (ast-common! (jump-ex-it-value ast) set))
       ast)
      ((fun)
       (fun-value-set! ast (ast-common! (fun-value ast) set))
       ast)
      ((app-ly)
       (app-ly-fun-set! ast (ast-common! (app-ly-fun ast) set))
       (app-ly-value-set! ast (ast-common! (app-ly-value ast) set))
       ast)
      ((funcall)
       (funcall-fun-set! ast (ast-common! (funcall-fun ast) set))
       (let loop ((actuals (funcall-actuals ast)))
	  (if (null? actuals)
	      ast
	      (begin
		 (set-car! actuals (ast-common! (car actuals) set))
		 (loop (cdr actuals))))))
      ((app)
       (common-app! ast set))))

;*---------------------------------------------------------------------*/
;*    common-conditional! ...                                          */
;*---------------------------------------------------------------------*/
(define (common-conditional! ast set)
   (trace reduce "common-conditional!: " (shape ast) #\Newline)
   (set! *nb-app* (+fx *nb-app* 1))
   (let ((new-test (ast-common! (conditional-test ast) set)))
      (if (side-effect-free? new-test)
	  (let ((c (find-common new-test set)))
	     (trace reduce "   set   : " (shape set) #\Newline)
	     (trace reduce "   common: " (shape c) #\Newline)
	     (cond
		((and (common? c)
		      (boolean? (common-bool-value c))
		      (common-bool-value c))
		 (set! *nb-app-reduced* (+fx *nb-app-reduced* 1))
;* 		 (print "Je reduis le test #t: "                       */
;* 			(shape ast) #\Newline                          */
;* 			"   " (ast-location ast))                      */
		 (conditional-test-set! ast
					(sexp->ast #t '() #f #f #f))
		 (conditional-then-set! ast
					(ast-common! (conditional-then ast)
						     set))
		 (conditional-else-set! ast
					(sexp->ast #f '() #f #f #f))
		 ast)
		((and (common? c)
		      (boolean? (common-bool-value c))
		      (not (common-bool-value c)))
;* 		 (print "Je reduis le test #f: "                       */
;* 			(shape ast) #\Newline                          */
;* 			"   " (ast-location ast))                      */
		 (set! *nb-app-reduced* (+fx *nb-app-reduced* 1))
		 (conditional-test-set! ast
					(sexp->ast #f '() #f #f #f))
		 (conditional-then-set! ast
					(sexp->ast #f '() #f #f #f))
		 (conditional-else-set! ast
					(ast-common! (conditional-else ast)
						     set))
		 ast)
		((and (common? c)
		      (variable? (common-variable c)))
;* 		 (print "Je reduis le test par une variable: "         */
;* 			(shape ast) #\Newline                          */
;* 			"   " (ast-location ast))                      */
		 (conditional-test-set! ast
					(ast-var #f
						 #f
						 #f 
						 (common-variable c)))
		 (common-bool-value-set! c #t)
		 (conditional-then-set! ast
					(ast-common! (conditional-then ast)
						     set))
		 (common-bool-value-set! c #f)
		 (conditional-else-set! ast
					(ast-common! (conditional-else ast)
						     set))
		 ast)
		(else
		 (conditional-test-set! ast new-test)
		 (let ((c (common new-test #unspecified #unspecified)))
		    (common-bool-value-set! c #t)
		    (conditional-then-set! ast
					   (ast-common! (conditional-then ast)
							(cons c set)))
		    (common-bool-value-set! c #f)
		    (conditional-else-set! ast
					   (ast-common! (conditional-else ast)
							(cons c set))))
		 ast)))
	  (begin
	     (conditional-test-set! ast new-test)
	     (conditional-then-set! ast
				    (ast-common! (conditional-then ast) '()))
	     (conditional-else-set! ast
				    (ast-common! (conditional-else ast) '()))
	     ast))))

;*---------------------------------------------------------------------*/
;*    common-let-var! ...                                              */
;*---------------------------------------------------------------------*/
(define (common-let-var! ast set)
   (trace reduce "common-let-var!: " (shape ast) #\Newline)
   (let loop ((bindings  (let-var-bindings ast))
	      (nbindings '())
	      (new-set   set)
	      (se?       #f))
      (if (null? bindings)
	  (begin
;* 	     (if (not (=fx (length nbindings) (length (let-var-bindings ast)))) */
;* 		 (print "J'ai vire des bindings: " (shape ast)         */
;*  			"old: " (shape (let-var-bindings ast)) #\Newline */
;* 			"new: " (shape nbindings) #\Newline            */
;* 			"    " (ast-location ast)))                    */
	     (let-var-bindings-set! ast (reverse! nbindings))
	     (let-var-body-set! ast (ast-common! (let-var-body ast)
						 (if se?
						     '()
						     new-set)))
	     ast)
	  (let* ((binding (car bindings))
		 (var     (car binding)))
	     (set-cdr! binding (ast-common! (cdr binding) set))
	     (let ((val (cdr binding)))
		(cond
		   ((not (side-effect-free? val))
		    (loop (cdr bindings)
			  (cons binding nbindings)
			  '()
			  #t))
		   ((eq? (variable-access var) 'write)
		    (loop (cdr bindings)
			  (cons binding nbindings)
			  new-set
			  se?))
		   ((and (var? val)
			 (eq? (variable-access (var-variable val)) 'read))
;* 		    (print "Je vire la variable: " (shape val) #\Newline */
;* 			   "    " (ast-location ast))                  */
		    (variable-fast-alpha-set! var
					      (calpha (var-variable val)))
		    (loop (cdr bindings)
			  nbindings
			  new-set
			  se?))
		   (se?
		    (loop (cdr bindings)
			  (cons binding nbindings)
			  '()
			  #t))
		   (else
		    (let ((common (common val var #unspecified)))
		       (loop (cdr bindings)
			     (cons binding nbindings)
			     (cons common new-set)
			     se?)))))))))

;*---------------------------------------------------------------------*/
;*    common-app! ...                                                  */
;*---------------------------------------------------------------------*/
(define (common-app! ast set)
   (set! *nb-app* (+fx *nb-app* 1))
   (trace reduce "common-app!: " (shape ast) #\Newline)
   (app-fun-set! ast (ast-common! (app-fun ast) set))
   (let loop ((actuals (app-actuals ast)))
      (if (null? actuals)
	  (if (side-effect-free? ast)
	      (let ((common (find-common ast set)))
		 (trace reduce "   set   : " (shape set) #\Newline)
		 (trace reduce "   common: " (shape common) #\Newline)
		 (if (and (common? common)
			  (variable? (common-variable common)))
		     (begin
			(set! *nb-app-reduced* (+fx *nb-app-reduced* 1))
;* 			(print "Je reduis l'application: "             */
;* 			       (shape ast)                             */
;* 			       #\Newline                               */
;* 			       "  " (ast-location ast))                */
			(ast-var #f #f #f (common-variable common)))
		     ast))
	      ast)
	  (begin
	     (set-car! actuals (ast-common! (car actuals) set))
	     (loop (cdr actuals))))))

;*---------------------------------------------------------------------*/
;*    find-common ...                                                  */
;*---------------------------------------------------------------------*/
(define (find-common ast set)
   (let loop ((set set))
      (cond
	 ((null? set)
	  #f)
	 ((ast-equal? (common-ast (car set)) ast)
	  (car set))
	 (else
	  (loop (cdr set))))))

;*---------------------------------------------------------------------*/
;*    ast-equal? ...                                                   */
;*---------------------------------------------------------------------*/
(define (ast-equal? ast1 ast2)
   (define (ast-equal*? exp1 exp2)
      (and (=fx (length exp1) (length exp2))
	   (let loop ((exp1 exp1)
		      (exp2 exp2))
	      (cond
		 ((null? exp1)
		  #t)
		 ((not (ast-equal? (car exp1) (car exp2)))
		  #f)
		 (else
		  (loop (cdr exp1) (cdr exp2)))))))
   (cond
      ((eq? ast1 ast2)
       #t)
      ((not (eq? (struct-ref ast1 0) (struct-ref ast2 0)))
       #f)
      (else
       (ast-case ast1
	  ((atom)
	   (equal? (atom-value ast1) (atom-value ast2)))
	  ((kwote)
	   (equal? (atom-value ast1) (atom-value ast2)))
	  ((var)
	   (eq? (var-variable ast1) (var-variable ast2)))
	  ((make-box)
	   #f)
	  ((box-ref)
	   #f)
	  ((box-set!)
	   #f)
	  ((prag-ma)
	   #f)
	  ((fail)
	   #f)
	  ((sequence)
	   (ast-equal*? (sequence-exp ast1) (sequence-exp ast2)))
	  ((conditional)
	   (and (ast-equal? (conditional-test ast1)
			    (conditional-test ast2))
		(ast-equal? (conditional-then ast1)
			    (conditional-then ast2))
		(ast-equal? (conditional-else ast1)
			    (conditional-else ast2))))
	  ((switch)
	   #f)
	  ((setq)
	   #f)
	  ((let-var)
	   #f)
	  ((let-fun)
	   #f)
	  ((set-ex-it)
	   #f)
	  ((jump-ex-it)
	   #f)
	  ((app-ly)
	   #f)
	  ((funcall)
	   #f)
	  ((app)
	   (and (eq? (var-variable (app-fun ast1))
		     (var-variable (app-fun ast2)))
		(ast-equal*? (app-actuals ast1) (app-actuals ast2))))))))


      
